/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util;

import com.huawei.ism.drm.drp.sdk.model.RecoverySetting;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Set;

public class RecoveryUtil {
    private static final int MAX_POPROPS_LEN = 8192;
    private static final Log logger = LogFactory.getInstance(RecoveryUtil.class);

    private RecoveryUtil() {
    }

    public static boolean isTemplate(ProtectObject po) {
        FixLengthProps recoveryVmProps = new FixLengthProps(po.getProps(), 8192);
        String vmMgrJson = recoveryVmProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        if (null != vmMgrJson) {
            try {
                JSONObject jsonObj = JSONObject.fromObject((Object)vmMgrJson);
                Boolean isTemplate = (Boolean)jsonObj.get("template");
                return isTemplate;
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"get template from po failed. Json format error.", (Throwable)e, 90160758787071L);
            }
        }
        return false;
    }

    public static RecoverySetting getVmStartupSetting(Set<RecoverySetting> vMRecoverySettings, String poId, String settingName) {
        if (VerifyUtil.isEmpty((String)poId) || VerifyUtil.isEmpty(vMRecoverySettings)) {
            return null;
        }
        for (RecoverySetting setting : vMRecoverySettings) {
            if (!poId.equals(setting.getOwnerId()) || !settingName.equals(setting.getName())) continue;
            return setting;
        }
        return null;
    }
}

