/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.alarm;

import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.galax.constant.cloudenum.PoExParamsEnum;
import com.huawei.ism.drm.galax.sdk.pg.model.FixLengthProps;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.HashSet;
import java.util.Set;

public class AlarmGenerator {
    private static final Log LOGGER = LogFactory.getInstance(AlarmGenerator.class);

    private AlarmGenerator() {
    }

    public static void generatePGHasDifferentTypeVMAlarm(String pgID, String pgName) {
        try {
            AlarmReporter.sendAlarm((long)52625425L, (String)pgID, (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MINOR, (String[])new String[]{pgID, pgName});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to send alarm for protectgroup(" + pgID + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public static void restorePGHasDifferentTypeVMAlarm(String pgID) {
        try {
            AlarmReporter.restoreAlarm((long)52625425L, (String[])new String[]{pgID});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to send alarm for protectgroup(" + pgID + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public static void generateVMNotMappingAlarm(String vmUuid, String vmName, String pguuid) {
        try {
            AlarmReporter.sendAlarm((long)0x3230020L, (String)pguuid, (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.MAJOR, (String[])new String[]{vmUuid, vmName});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to send alarm for vm(" + vmUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    public static void restoreVMNotMappingAlarm(String vmUuid) {
        try {
            AlarmReporter.restoreAlarm((long)0x3230020L, (String[])new String[]{vmUuid});
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to send alarm for vm(" + vmUuid + ")" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786989L);
        }
    }

    private static JSONObject getVmMgrInfo(ProtectObject po) {
        FixLengthProps poRecoveryProps = new FixLengthProps(po.getProps(), 8192);
        String vmMgrJson = poRecoveryProps.getValue(PoExParamsEnum.VM_MGR_INFO.getValue());
        if (!VerifyUtil.isEmpty((String)vmMgrJson)) {
            return JSONUtils.fromString(vmMgrJson);
        }
        return new JSONObject();
    }

    public static void sendProtectObjectRemoveAlarm(String protectGroupId, String protectGroupName, Set<ProtectObject> poToBeDeleted) {
        HashSet<String> linkVmUuids = new HashSet<String>();
        for (ProtectObject protectObject : poToBeDeleted) {
            Boolean isLinkClone = false;
            JSONObject jo = AlarmGenerator.getVmMgrInfo(protectObject);
            try {
                isLinkClone = jo.getBoolean(PoExParamsEnum.LINK_CLONE_VM.getValue());
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"parse linkClone from vmMgrInfo error");
            }
            if (!isLinkClone.booleanValue()) continue;
            linkVmUuids.add(protectObject.getMoUuid());
        }
        if (!VerifyUtil.isEmpty(poToBeDeleted)) {
            try {
                for (ProtectObject po : poToBeDeleted) {
                    if (!linkVmUuids.contains(po.getMoUuid())) {
                        AlarmReporter.sendAlarm((long)52625422L, (String)protectGroupId, (String)FaultEnum.AlarmResourceType.DRMOBJECT.getValue(), (FaultEnum.AlarmSeverity)FaultEnum.AlarmSeverity.CRITICAL, (String[])new String[]{po.getMoUuid(), protectGroupName, po.getName()});
                    }
                    AlarmReporter.restoreAlarm((long)0x3230022L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)52625441L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)0x3230023L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                    AlarmReporter.restoreAlarm((long)52625434L, (String[])new String[]{protectGroupId + po.getMoUuid()});
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("send galax vm alarm error" + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }
}

