/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.cloud;

import com.huawei.ism.drm.galax.sdk.model.CloudInfo;
import com.huawei.ism.drm.galax.sdk.model.DrFm;
import com.huawei.ism.drm.galax.sdk.model.DrVrm;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class FmUtils {
    private static final Log logger = LogFactory.getInstance(FmUtils.class);

    public static CloudInfo translateCloudInfo(DrResource res, CloudInfo parentRes) {
        if (null == res) {
            throw new LegoCheckedException(1073947393L);
        }
        CloudInfo cloud = new CloudInfo();
        cloud.setDbId(res.getDbId());
        cloud.setDeviceSn(res.getDeviceSn());
        cloud.setExtProperty(res.getExtProperty());
        cloud.setIpAddress(res.getIpAddress());
        cloud.setName(res.getName());
        cloud.setVersion(res.getVersion());
        cloud.setSiteId(res.getSiteId());
        cloud.setStatus(res.getStatus());
        cloud.setResType(res.getClass().getSimpleName());
        cloud.setParentResource(null == parentRes ? null : parentRes.getDbId());
        if (res instanceof DrFm) {
            cloud.setPort(((DrFm)res).getPort());
        } else if (res instanceof DrVrm) {
            cloud.setPort(((DrVrm)res).getPort());
        }
        return cloud;
    }
}

