/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.common.encrypt;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public class SHAEncrypt {
    private static final Log LOGGER = LogFactory.getInstance(SHAEncrypt.class);
    private static final int NUM = 4;
    private static final int FILTER = 15;
    private static final String HEX_DIGITS = "0123456789abcdef";
    private static final String SHA256 = "SHA-256";
    private static final String CODE_UTF_8 = "UTF-8";

    public static String encryptSHA256(String strSrc) {
        byte[] strDes;
        if (StringUtils.isEmpty((CharSequence)strSrc)) {
            return strSrc;
        }
        try {
            byte[] bt = strSrc.getBytes(CODE_UTF_8);
            MessageDigest md = MessageDigest.getInstance(SHA256);
            md.update(bt);
            strDes = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error((Object)("encrypt message falied" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)("encrypt message falied, can support utf-8 encode." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            return null;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < strDes.length; ++i) {
            for (int j = 4; j >= 0; j -= 4) {
                buf.append(HEX_DIGITS.charAt(strDes[i] >>> j & 0xF));
            }
        }
        return buf.toString();
    }
}

