/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.common.task.controller;

import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.galax.util.common.task.controller.TaskScheduleController;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class BatchExecuteTaskManager {
    private static final Log LOGGER = LogFactory.getInstance(BatchExecuteTaskManager.class);
    private static Map<String, BatchExecuteTaskManager> mapMgr = new HashMap<String, BatchExecuteTaskManager>();
    private ExecutorService executorService = null;
    private Map<String, Integer> mapTaskCounts = new HashMap<String, Integer>();
    private Map<String, CountDownLatch> mapTaskLatch = new HashMap<String, CountDownLatch>();
    private Map<IExecuteTask, Future<?>> serviceMap = new ConcurrentHashMap();

    private BatchExecuteTaskManager(int threshold) {
        this.executorService = Executors.newFixedThreadPool(threshold);
    }

    public static synchronized BatchExecuteTaskManager getInstance(String taskType) {
        String threshold = String.valueOf(8);
        BatchExecuteTaskManager instance = mapMgr.get(taskType);
        if (null == instance) {
            int threadNum = NumberUtil.convertToInteger((Object)threshold);
            instance = new BatchExecuteTaskManager(threadNum);
            mapMgr.put(taskType, instance);
            return instance;
        }
        return instance;
    }

    private ExecutorService getExecuteService() {
        return this.executorService;
    }

    public synchronized Future<?> addTask(IExecuteTask task) {
        if (null == task) {
            LOGGER.error((Object)"parameter task is empty.", 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
        this.handleSynTask(task.getTaskFlag());
        Future<?> future = this.getExecuteService().submit(new TaskScheduleController(task, this));
        this.serviceMap.put(task, future);
        return future;
    }

    private void handleSynTask(String taskFlag) {
        CountDownLatch stopLatch = this.mapTaskLatch.get(taskFlag);
        if (null == stopLatch || 0L == stopLatch.getCount()) {
            stopLatch = new CountDownLatch(1);
            this.mapTaskLatch.put(taskFlag, stopLatch);
        }
        this.mapTaskCounts.putIfAbsent(taskFlag, 0);
        if (null != this.mapTaskCounts.get(taskFlag)) {
            int count = this.mapTaskCounts.get(taskFlag);
            this.mapTaskCounts.put(taskFlag, ++count);
        }
    }

    public synchronized void shutDownTask(IExecuteTask task) {
        if (null == task) {
            return;
        }
        Future<?> future = this.serviceMap.remove(task);
        future.cancel(true);
        String taskFlag = task.getTaskFlag();
        int count = null == this.mapTaskCounts.get(taskFlag) ? 0 : this.mapTaskCounts.get(taskFlag);
        this.mapTaskCounts.put(taskFlag, --count);
        if (0 >= count) {
            CountDownLatch stopLatch = this.mapTaskLatch.get(taskFlag);
            if (null != stopLatch) {
                stopLatch.countDown();
            }
            this.mapTaskLatch.remove(taskFlag);
            this.mapTaskCounts.remove(taskFlag);
        }
    }

    public synchronized void shutDownAllTask(String taskFlag) {
        for (IExecuteTask task : this.serviceMap.keySet()) {
            if ((null != taskFlag || null != task.getTaskFlag()) && !task.getTaskFlag().equals(taskFlag)) continue;
            this.shutDownTask(task);
        }
        CountDownLatch stopLatch = this.mapTaskLatch.get(taskFlag);
        if (stopLatch.getCount() > 0L) {
            stopLatch.countDown();
        }
        this.mapTaskLatch.remove(taskFlag);
        this.mapTaskCounts.remove(taskFlag);
    }

    public boolean waitTask(String taskFlag) {
        try {
            CountDownLatch stopLatch = this.mapTaskLatch.get(taskFlag);
            if (null != stopLatch) {
                stopLatch.await();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Failed to wait,", (Throwable)e, 90160758787071L);
            return false;
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to wait," + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
            return false;
        }
        return true;
    }
}

