/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.common.task.controller;

import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.galax.util.common.task.constants.TaskExecuteStatus;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.concurrent.CountDownLatch;

public class CircleTaskPoller
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(CircleTaskPoller.class);
    private IExecuteTask task;
    private Object response;
    private CountDownLatch stopLatch = new CountDownLatch(1);

    public CircleTaskPoller(IExecuteTask task, Object response) {
        this.task = task;
        this.response = response;
    }

    @Override
    public void run() {
        try {
            TaskExecuteStatus taskResult = this.task.handleCmdResult(this.response);
            if (taskResult.name().equals(TaskExecuteStatus.success.name()) || taskResult.name().equals(TaskExecuteStatus.failed.name())) {
                this.stopLatch.countDown();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to execute cmdResponse," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.handleException(e);
            this.stopLatch.countDown();
        }
    }

    private void handleException(Exception e) {
        try {
            this.task.handleCmdResult(e);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to execute cmdResponse," + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
        }
    }

    public boolean waitTask() {
        try {
            this.stopLatch.await();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Failed to wait,", (Throwable)e, 90160758787071L);
            return false;
        }
        return true;
    }
}

