/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.common.task.controller;

import com.huawei.ism.drm.galax.util.common.task.IExecuteTask;
import com.huawei.ism.drm.galax.util.common.task.controller.BatchExecuteTaskManager;
import com.huawei.ism.drm.galax.util.common.task.controller.CircleTaskPoller;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TaskScheduleController
implements Runnable {
    private static final Log LOGGER = LogFactory.getInstance(TaskScheduleController.class);
    private static ScheduledExecutorService executorService = Executors.newScheduledThreadPool(10);
    private BatchExecuteTaskManager mgr;
    private Object response = null;
    private IExecuteTask task;

    public TaskScheduleController(IExecuteTask task, BatchExecuteTaskManager mgr) {
        this.task = task;
        this.mgr = mgr;
    }

    @Override
    public void run() {
        try {
            this.response = this.task.excuteCommand();
            if (null == this.response) {
                this.task.handleCmdResult(null);
                this.shutDown();
                return;
            }
            if (this.task.getPeriod() > 0L) {
                this.asynExecuteTask();
            } else {
                this.synExecuteTask();
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to excute cmd," + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            this.handleException(e);
        }
    }

    private void asynExecuteTask() {
        this.submitSchedualTask(this.task);
    }

    private void synExecuteTask() {
        this.task.handleCmdResult(this.response);
        this.shutDown();
    }

    private void handleException(Exception e) {
        try {
            this.task.handleCmdResult(e);
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Failed to handle exception," + ExceptionUtil.getErrorMessage((Throwable)ex)), 90160758787071L);
        }
        this.shutDown();
    }

    private void submitSchedualTask(IExecuteTask execTask) {
        CircleTaskPoller queryTask = new CircleTaskPoller(execTask, this.response);
        ScheduledFuture<?> future = executorService.scheduleWithFixedDelay(queryTask, execTask.getInitialDelay(), execTask.getPeriod(), TimeUnit.SECONDS);
        queryTask.waitTask();
        future.cancel(true);
        this.shutDown();
    }

    private void shutDown() {
        this.mgr.shutDownTask(this.task);
        LOGGER.debug((Object)("Shut down this task, flag=" + this.task.getTaskFlag()), 90160758786816L);
    }
}

