/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.huawei.ism.drm.galax.sdk.vrm.model.VrmObject;
import com.huawei.ism.drm.galax.util.rest.JSONUtils;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.AddressUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.text.Normalizer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class CommonUtil {
    private static final Log LOG = LogFactory.getInstance(CommonUtil.class);
    private static final String LOCAL_HOST_IP_FIRST = "127";
    private static final String NULL_STR = "null";
    private static final int NET_MASK_LEN = 8;
    private static ObjectMapper mapper;

    public static synchronized ObjectMapper getMapperInstance() {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String beanToJson(Object obj) {
        String json = null;
        JsonGenerator gen = null;
        StringWriter writer = new StringWriter();
        try {
            ObjectMapper objMapper = CommonUtil.getMapperInstance();
            gen = new JsonFactory().createGenerator((Writer)writer);
            objMapper.writeValue(gen, obj);
            json = writer.toString();
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to transfer bean to json" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            writer = null;
        }
        finally {
            if (null != gen) {
                try {
                    gen.close();
                }
                catch (Exception e) {
                    LOG.error((Object)("close JsonGenerator falied." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                }
            }
            try {
                if (null != writer) {
                    writer.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("close StringWriter falied." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            }
        }
        return json;
    }

    public static <T> Object jsonToBean(String json, Class<T> cls) {
        if (VerifyUtil.isEmpty((String)json) || NULL_STR.equalsIgnoreCase(json)) {
            return null;
        }
        Object vo = null;
        try {
            JSONObject js = CommonUtil.getJsonObject(json);
            if (js != null) {
                vo = JSONUtils.toBean(js, cls);
            } else {
                JSONArray array = JSONArray.fromObject((Object)json);
                if (array.size() > 0) {
                    vo = JSONUtils.toBean(array.getJSONObject(0), cls);
                }
            }
        }
        catch (Exception e) {
            CommonUtil.handleException(e, cls);
        }
        return vo;
    }

    private static JSONObject getJsonObject(String json) {
        try {
            return JSONObject.fromObject((Object)json);
        }
        catch (LegoCheckedException e) {
            LOG.error((Object)"Failed to transfer json to jsonObject, maybe is JsonArray", 90160758787071L);
            return null;
        }
    }

    public static <T> Object json2Bean(String json, Class<T> cls) {
        List<?> vo;
        if (VerifyUtil.isEmpty((String)json) || NULL_STR.equalsIgnoreCase(json)) {
            return null;
        }
        try {
            if (cls.isArray()) {
                JSONArray array = JSONArray.fromObject((Object)json);
                vo = JSONUtils.toCollection(array, cls.getComponentType());
            } else {
                JSONObject js = JSONObject.fromObject((Object)json);
                vo = (List<?>)JSONUtils.toBean(js, cls);
            }
        }
        catch (Exception e) {
            vo = null;
            CommonUtil.handleException(e, cls);
        }
        return vo;
    }

    private static <T> void handleException(Exception e, Class<T> cls) {
        ExceptionUtil.rethrowException((Throwable)e, (String)("Failed to transfer json to bean(" + cls + ")"), (long)-1L, null, (Log)LOG);
    }

    public static boolean isIpValid(String inputIp) {
        if (VerifyUtil.isEmpty((String)inputIp) || inputIp.startsWith(LOCAL_HOST_IP_FIRST)) {
            return false;
        }
        return AddressUtil.isIpAddress((String)inputIp);
    }

    public static boolean validateNetMask(String mask) {
        if (CommonUtil.regNetMask(mask)) {
            String[] masks = mask.split("\\.");
            StringBuilder sb = new StringBuilder();
            for (String one : masks) {
                String binaryStr = Integer.toBinaryString(Integer.parseInt(one));
                int times = 8 - binaryStr.length();
                for (int idx = 0; idx < times; ++idx) {
                    sb.append("0");
                }
                sb.append(binaryStr);
            }
            int index0 = sb.indexOf("0");
            int validate = sb.indexOf("1", index0);
            return validate <= 0;
        }
        return false;
    }

    private static boolean regNetMask(String str) {
        if (null == str || str.trim().length() <= 0) {
            return false;
        }
        String reg = "^(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})(\\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[0-9]{1,2})){3}$";
        str = Normalizer.normalize(str, Normalizer.Form.NFKC);
        return Pattern.compile(reg).matcher(str).matches();
    }

    public static boolean isVrmMoreR5C00(VrmObject vrmObject) {
        if (null == vrmObject || null == vrmObject.getVersion()) {
            throw new LegoCheckedException(1073947393L);
        }
        String version = vrmObject.getVersion().getVersion();
        return 0 > "v5.0".compareToIgnoreCase(version);
    }

    public static boolean isConnectFailedExcpetion(LegoCheckedException e) {
        if (null == e) {
            return false;
        }
        boolean isMatch = 1073947399L == e.getErrorCode() || 1073947398L == e.getErrorCode() || 1073947395L == e.getErrorCode();
        isMatch = isMatch || 1073947647L == e.getErrorCode() || 1073947401L == e.getErrorCode();
        return isMatch;
    }

    public static Set<String> stringArray2Set(String uuids, String splitStr) {
        HashSet<String> uuidSet = new HashSet<String>();
        if (!VerifyUtil.isEmpty((String)uuids)) {
            String[] uuidArray;
            for (String uuid : uuidArray = uuids.split(splitStr)) {
                uuidSet.add(uuid);
            }
        }
        return uuidSet;
    }

    public static String getStringFromSet(Set<String> uuidSet, String unitStr) {
        if (VerifyUtil.isEmpty(uuidSet)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String vmUuid : uuidSet) {
            sb.append(vmUuid + unitStr);
        }
        if (sb.length() != 0) {
            sb.delete(sb.length() - unitStr.length(), sb.length());
        }
        return sb.toString();
    }

    public static Integer getSubNetMaskCount(String netMask) {
        String[] masks;
        if (VerifyUtil.isEmpty((String)netMask)) {
            return 0;
        }
        int num = 0;
        for (String mask : masks = netMask.split("\\.")) {
            int maskInt;
            try {
                maskInt = Integer.parseInt(mask);
            }
            catch (NumberFormatException e) {
                throw new LegoCheckedException(1073947393L, (Throwable)e);
            }
            num += Integer.bitCount(maskInt);
        }
        return num;
    }

    public static String getDescription(String des) {
        if (VerifyUtil.isEmpty((String)des)) {
            return des;
        }
        try {
            return CommonUtil.getSubstring(des);
        }
        catch (Exception e) {
            LOG.error((Object)("getDescription error, des=" + des + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786816L);
            return "";
        }
    }

    private static String getSubstring(String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]";
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < value.length(); ++i) {
            String temp = value.substring(i, i + 1);
            valueLength = temp.matches(chinese) ? (valueLength += 3) : ++valueLength;
            if (valueLength > 1024) break;
            result.append(temp);
        }
        return result.toString();
    }
}

