/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.rest;

import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;

public class JSONUtils {
    private static Log logger = LogFactory.getInstance(JSONUtils.class);
    private static final String CLASS_STR = "class";
    private static final String NULL_VALUE = "null";
    private static final int KEY_HEADER_LENHTH = 2;
    private static final int LIST_LOC = 2;

    public static JSONObject getJSONObjectFromObject(Object obj) {
        if (JSONUtils.isObjectNullOrEmpty(obj)) {
            return new JSONObject();
        }
        if (obj instanceof Map) {
            return JSONUtils.getJSONObjectFromMap(obj);
        }
        return JSONUtils.getJSONObjectFromBean(obj);
    }

    public static JSONObject fromString(String jsonStr) {
        JSONObject jsonObject;
        if (VerifyUtil.isEmpty((String)jsonStr)) {
            return new JSONObject();
        }
        try {
            jsonObject = JSONObject.fromObject((Object)jsonStr);
        }
        catch (Exception e) {
            logger.error((Object)("Create jsonObject from string error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
            jsonObject = new JSONObject();
        }
        return jsonObject;
    }

    public static JSONArray getJSONArrayFromString(String jsonStr) {
        JSONArray array;
        if (null == jsonStr) {
            return new JSONArray();
        }
        try {
            array = JSONArray.fromObject((Object)jsonStr);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Create jsonArray from string error.", (Throwable)e, 90160758787071L);
            array = new JSONArray();
        }
        return array;
    }

    public static JSONObject getJSONObjectFromMap(Object obj) {
        JSONObject jsonObject = new JSONObject();
        if (JSONUtils.isObjectNullOrEmpty(obj)) {
            return jsonObject;
        }
        if (!(obj instanceof Map)) {
            return jsonObject;
        }
        Map mapObject = (Map)obj;
        for (Map.Entry entity : mapObject.entrySet()) {
            JSONUtils.setValueByType(jsonObject, entity.getValue(), entity.getKey().toString());
        }
        return jsonObject;
    }

    private static <T> T generateClazzInstance(Class<T> clazz) {
        Boolean result = null;
        if (null == clazz) {
            logger.error((Object)"The class is null.", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        try {
            if (clazz == Boolean.class || clazz == Boolean.TYPE) {
                result = Boolean.FALSE;
            } else {
                if (clazz.equals(Timestamp.class)) {
                    return (T)new Timestamp(new Date().getTime());
                }
                result = clazz.newInstance();
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Create new instance error. The class is :" + clazz.getName()), (long)-1L, null, (Log)logger);
        }
        return (T)result;
    }

    public static <T> T toBean(JSONObject jsonObject, Class<T> clazz) {
        T result = JSONUtils.generateClazzInstance(clazz);
        if (null == result) {
            return null;
        }
        if (JSONUtils.isObjectNullOrEmpty(jsonObject)) {
            logger.error((Object)"The json parameter is null.", 90160758787071L);
            return null;
        }
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors(result);
        if (null == propertyDescriptors || propertyDescriptors.length <= 0) {
            return result;
        }
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            Method method = descriptor.getWriteMethod();
            if (null == method) continue;
            JSONUtils.setPropertyValue(jsonObject, descriptor, result);
        }
        return result;
    }

    private static <T> T[] json2Array(String json, Class<T> cl) {
        Object[] resultList;
        JSONArray jsonArray = new JSONArray();
        if (null == json) {
            return (Object[])Array.newInstance(cl, jsonArray.size());
        }
        try {
            jsonArray = JSONArray.fromObject((Object)json);
            resultList = (Object[])Array.newInstance(cl, jsonArray.size());
            for (int index = 0; index < jsonArray.size(); ++index) {
                JSONObject jsonObj = jsonArray.getJSONObject(index);
                if (null == jsonObj) continue;
                T obj = JSONUtils.toBean(jsonObj, cl);
                resultList[index] = obj;
            }
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"The json parameter is null.", (Throwable)e, 90160758787071L);
            resultList = null;
        }
        return resultList;
    }

    private static <T> void setPropertyValue(JSONObject jsonObject, PropertyDescriptor propertyDescriptor, T result) {
        Class<?> propertyClass = propertyDescriptor.getPropertyType();
        if (null == propertyClass) {
            logger.warn((Object)"the propertyClass is null.", 90160758787071L);
            return;
        }
        if (propertyClass.isArray()) {
            String value = JSONUtils.getJSONObjectValue(jsonObject, propertyDescriptor.getName());
            Class<?> cl = propertyClass.getComponentType();
            if (JSONUtils.isObjectNullOrEmpty(value)) {
                return;
            }
            JSONUtils.setPropertyValue(propertyDescriptor.getName(), JSONUtils.json2Array(value, cl), result);
        } else if (Collection.class.isAssignableFrom(propertyClass)) {
            JSONUtils.setCollectionValue(jsonObject, propertyDescriptor, result);
        } else if (Map.class.isAssignableFrom(propertyClass)) {
            JSONUtils.setMapValue(jsonObject, propertyDescriptor, result);
        } else if (JSONUtils.isSimpleType(propertyClass)) {
            String value = JSONUtils.getJSONObjectValue(jsonObject, propertyDescriptor.getName());
            if (null == value || NULL_VALUE.equals(value)) {
                return;
            }
            JSONUtils.setPropertyValue(propertyDescriptor.getName(), value, result);
        } else if (propertyClass.equals(Timestamp.class)) {
            String value = JSONUtils.getJSONObjectValue(jsonObject, propertyDescriptor.getName());
            if (JSONUtils.isObjectNullOrEmpty(value)) {
                return;
            }
            Timestamp timestamp = (Timestamp)JSONUtils.toBean(jsonObject, propertyClass);
            timestamp.setTime(NumberUtil.convertToLong((Object)value));
            JSONUtils.setPropertyValue(propertyDescriptor.getName(), timestamp, result);
        } else {
            String value = JSONUtils.getJSONObjectValue(jsonObject, propertyDescriptor.getName());
            if (JSONUtils.isObjectNullOrEmpty(value)) {
                return;
            }
            JSONObject propertyJSONObject = JSONUtils.fromString(value);
            JSONUtils.setPropertyValue(propertyDescriptor.getName(), JSONUtils.toBean(propertyJSONObject, propertyClass), result);
        }
    }

    private static <T> void setMapValue(JSONObject jsonObject, PropertyDescriptor propertyDescriptor, T result) {
        Method method = propertyDescriptor.getWriteMethod();
        if (null == method) {
            logger.warn((Object)"no method found.", 90160758787071L);
            return;
        }
        List<Class<?>> classList = JSONUtils.getGenericParameterClasses(method);
        if (null != classList && classList.size() > 1) {
            String value = JSONUtils.getJSONObjectValue(jsonObject, propertyDescriptor.getName());
            JSONObject propertyJSONObject = JSONUtils.fromString(value);
            if (null == propertyJSONObject || propertyJSONObject.size() < 1) {
                return;
            }
            Class<?> cl = classList.get(1);
            if (cl != List.class) {
                JSONUtils.setPropertyValue(propertyDescriptor.getName(), JSONUtils.toMap(propertyJSONObject, cl), result);
            } else {
                cl = classList.get(2);
                JSONUtils.setPropertyValue(propertyDescriptor.getName(), JSONUtils.toMapList(propertyJSONObject, cl), result);
            }
        } else {
            logger.info((Object)"no generic found", 90160758787071L);
        }
    }

    private static <T> void setCollectionValue(JSONObject jsonObject, PropertyDescriptor propertyDescriptor, T result) {
        Method method = propertyDescriptor.getWriteMethod();
        if (null == method) {
            logger.warn((Object)"no method found.", 90160758787071L);
            return;
        }
        List<Class<?>> classList = JSONUtils.getGenericParameterClasses(method);
        if (null != classList && classList.size() == 1) {
            JSONArray array = JSONUtils.getJSONArrayFromJSONObject(jsonObject, propertyDescriptor.getName());
            if (null == array || array.size() < 1) {
                return;
            }
            JSONUtils.setPropertyValue(propertyDescriptor.getName(), JSONUtils.toCollection(array, classList.get(0)), result);
        } else {
            logger.info((Object)"no generic found", 90160758787071L);
        }
    }

    private static <T> Map<String, T> toMapList(JSONObject jsonObject, Class<T> valueClass) {
        HashMap<String, List<T>> result = new HashMap<String, List<T>>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            JSONArray array;
            String key = (String)iterator.next();
            try {
                String json = JSONUtils.getJSONObjectValue(jsonObject, key);
                array = JSONArray.fromObject((Object)json);
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"Failed to get Array", 90160758787071L);
                array = null;
            }
            List<T> list = JSONUtils.toCollection(array, valueClass);
            result.put(key, list);
        }
        return result;
    }

    private static <T> Map<String, T> toMap(JSONObject jsonObject, Class<T> valueClass) {
        HashMap<String, String> result = new HashMap<String, String>();
        Iterator iterator = jsonObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (JSONUtils.isSimpleType(valueClass)) {
                result.put(key, JSONUtils.getJSONObjectValue(jsonObject, key));
                continue;
            }
            JSONObject propertyjsonObject = JSONUtils.fromString(JSONUtils.getJSONObjectValue(jsonObject, key));
            if (null == propertyjsonObject || propertyjsonObject.size() < 1) {
                return result;
            }
            result.put(key, (String)JSONUtils.toBean(propertyjsonObject, valueClass));
        }
        return result;
    }

    private static JSONArray getJSONArrayFromJSONObject(JSONObject jsonObject, String key) {
        JSONArray array;
        if (null == jsonObject) {
            logger.error((Object)"The jsonObject is null", 90160758787071L);
            return new JSONArray();
        }
        try {
            String value = jsonObject.getString(key);
            array = JSONArray.fromObject((Object)value);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Create json object error.", (Throwable)e, 90160758787071L);
            array = new JSONArray();
        }
        return array;
    }

    private static String getJSONObjectValue(JSONObject jsonObject, String key) {
        String value;
        if (null == jsonObject || VerifyUtil.isEmpty((String)key)) {
            logger.error((Object)"The method 'getJSONObjectValue'  param is null ", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        try {
            value = jsonObject.getString(key);
        }
        catch (LegoCheckedException e) {
            value = JSONUtils.handleJsonHeader(jsonObject, key);
        }
        return value;
    }

    private static String handleJsonHeader(JSONObject jsonObject, String key) {
        String value;
        try {
            String subKey = key.substring(0, 2);
            String keyHeader = subKey.toLowerCase(Locale.US);
            if (subKey.equals(keyHeader)) {
                return null;
            }
            key = key.replaceFirst(subKey, keyHeader);
            value = jsonObject.getString(key);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("get value error . key:" + key), -1L);
            value = null;
        }
        return value;
    }

    public static <T> List<T> toCollection(JSONArray array, Class<T> clazz) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (null == clazz) {
            logger.info((Object)"The clazz  param is null ", 90160758787071L);
            throw new LegoCheckedException(-1L);
        }
        if (null == array || array.size() < 1) {
            logger.info((Object)"The method 'toCollection'  param is null ", 90160758787071L);
            return result;
        }
        for (int i = 0; i < array.size(); ++i) {
            try {
                if (JSONUtils.isSimpleType(clazz)) {
                    result.add(array.get(i));
                    continue;
                }
                JSONObject obj = array.getJSONObject(i);
                result.add(JSONUtils.toBean(obj, clazz));
                continue;
            }
            catch (LegoCheckedException e) {
                logger.error((Object)"get elements error", (Throwable)e, 90160758787071L);
                return result;
            }
        }
        return result;
    }

    private static List<Class<?>> getGenericParameterClasses(Method method) {
        Type[] genericParameterTypes;
        ArrayList resultList = new ArrayList();
        for (Type genericParameterType : genericParameterTypes = method.getGenericParameterTypes()) {
            if (!(genericParameterType instanceof ParameterizedType)) continue;
            ParameterizedType type = (ParameterizedType)genericParameterType;
            Object[] parameterArgTypes = type.getActualTypeArguments();
            if (VerifyUtil.isEmpty((Object[])parameterArgTypes)) {
                return resultList;
            }
            for (Object parameterArgType : parameterArgTypes) {
                JSONUtils.calResulteList(resultList, (Type)parameterArgType);
            }
        }
        return resultList;
    }

    private static void calResulteList(List<Class<?>> resultList, Type parameterArgType) {
        ParameterizedType newType;
        Class parameterArgClass = null;
        if (parameterArgType instanceof ParameterizedType && (newType = (ParameterizedType)parameterArgType).getRawType() == List.class) {
            parameterArgClass = (Class)newType.getRawType();
            resultList.add(List.class);
            resultList.add((Class)newType.getActualTypeArguments()[0]);
        }
        if (null == parameterArgClass) {
            parameterArgClass = (Class)parameterArgType;
        }
        resultList.add(parameterArgClass);
    }

    private static <T> void setPropertyValue(String key, Object value, T result) {
        try {
            BeanUtils.setProperty(result, (String)key, (Object)value);
        }
        catch (Exception e) {
            logger.error((Object)("Set object property error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
        }
    }

    public static Class<?> getPropertyType(Method method) {
        ParameterizedType type;
        if (null == method) {
            return null;
        }
        Type[] parameterTypes = method.getGenericParameterTypes();
        if (null == parameterTypes || parameterTypes.length != 1) {
            String errorMsg = "the  method of" + method.getName() + " more than one parameter";
            logger.error((Object)errorMsg, 90160758787071L);
            return null;
        }
        Type parameterType = parameterTypes[0];
        if (parameterType instanceof ParameterizedType && (type = (ParameterizedType)parameterType).getRawType() != null) {
            return (Class)type.getRawType();
        }
        return null;
    }

    public static JSONArray getJSONArrayFromCollection(Object value) {
        try {
            JSONArray result = new JSONArray();
            if (JSONUtils.isObjectNullOrEmpty(value)) {
                return result;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                for (Object element : collection) {
                    result.add((Object)JSONUtils.getJSONObjectFromBean(element));
                }
            } else {
                return result;
            }
            return result;
        }
        catch (Exception e) {
            logger.error((Object)("getJSONArrayFromCollection failed:" + ExceptionUtil.getErrorMessage((Throwable)e)));
            return null;
        }
    }

    public static String toJsonString(OperationResult operationResult) {
        JSONObject resultObj = new JSONObject();
        if (null == operationResult) {
            return resultObj.toString();
        }
        try {
            resultObj.put((Object)"args", (Object)operationResult.getArgs());
            resultObj.put((Object)"endTime", (Object)operationResult.getEndTime());
            resultObj.put((Object)"errorCode", (Object)operationResult.getErrorCode());
            resultObj.put((Object)"level", (Object)operationResult.getLevel());
            resultObj.put((Object)"operationName", (Object)operationResult.getOperationName());
            resultObj.put((Object)"startTime", (Object)operationResult.getStartTime());
            resultObj.put((Object)"success", (Object)operationResult.isSuccess());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"toJsonOperationResult failed.", 90160758787071L);
        }
        return resultObj.toString();
    }

    public static OperationResult toOperationResult(String jsonString) {
        OperationResult operationResult;
        try {
            JSONObject resultObj = JSONObject.fromObject((Object)jsonString);
            boolean isSuccess = resultObj.getBoolean("success");
            long startTime = resultObj.getLong("startTime");
            long endTime = resultObj.getLong("endTime");
            String operationName = resultObj.getString("operationName");
            int level = resultObj.getInt("level");
            String errorCode = resultObj.getString("errorCode");
            String args = resultObj.getString("args");
            operationResult = new OperationResult(operationName, true, isSuccess, errorCode, level, new String[]{args});
            operationResult.setStartTime(startTime);
            operationResult.setEndTime(endTime);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"toOperationResult failed.", 90160758787071L);
            operationResult = null;
        }
        return operationResult;
    }

    public static String getValueFromJsonKey(String json, String key) {
        if (VerifyUtil.isEmpty((String)json) || VerifyUtil.isEmpty((String)key)) {
            return null;
        }
        try {
            JSONObject resultObj = JSONObject.fromObject((Object)json);
            if (resultObj.containsKey((Object)key)) {
                return resultObj.getString(key);
            }
            return null;
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"parse json string failed.", (Throwable)e, 90160758787071L);
            return null;
        }
    }

    private static JSONObject getJSONObjectFromBean(Object bean) {
        JSONObject jsonObject = new JSONObject();
        if (JSONUtils.isObjectNullOrEmpty(bean)) {
            return jsonObject;
        }
        PropertyDescriptor[] pds = PropertyUtils.getPropertyDescriptors((Object)bean);
        if (null == pds || pds.length <= 1) {
            return jsonObject;
        }
        for (int i = 0; i < pds.length; ++i) {
            String key = pds[i].getName();
            Object value = null;
            if (CLASS_STR.equals(key)) continue;
            if (pds[i].getReadMethod() != null) {
                try {
                    value = PropertyUtils.getProperty((Object)bean, (String)key);
                }
                catch (Exception e) {
                    logger.error((Object)("get property error." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                }
                if (value == null) continue;
                JSONUtils.setValueByType(jsonObject, value, key);
                continue;
            }
            logger.info((Object)("Property " + key + " of " + bean.getClass() + "  has no read method.   "), 90160758787071L);
        }
        return jsonObject;
    }

    private static void setValueByType(JSONObject jsonObject, Object value, String key) {
        if (value instanceof Map) {
            JSONUtils.setJSONObjectValue(jsonObject, JSONUtils.getJSONObjectFromMap(value), key);
        } else if (value instanceof Collection) {
            JSONUtils.setJSONObjectValue(jsonObject, JSONUtils.getJSONArrayFromCollection(value), key);
        } else if (value.getClass().isArray()) {
            JSONUtils.setJSONObjectValue(jsonObject, JSONUtils.getJSONArrayFromArray(value), key);
        } else if (value instanceof String) {
            JSONUtils.setJSONObjectValue(jsonObject, value, key);
        } else if (JSONUtils.isNumber(value)) {
            JSONUtils.setJSONObjectValue(jsonObject, value, key);
        } else {
            JSONUtils.setJSONObjectValue(jsonObject, JSONUtils.getJSONObjectFromBean(value), key);
        }
    }

    private static JSONArray getJSONArrayFromArray(Object value) {
        Object[] objArray;
        JSONArray result = new JSONArray();
        if (JSONUtils.isObjectNullOrEmpty(value)) {
            return result;
        }
        for (Object element : objArray = (Object[])value) {
            result.add((Object)JSONUtils.getJSONObjectFromBean(element));
        }
        return result;
    }

    private static void setJSONObjectValue(JSONObject jsonObject, Object value, String key) {
        try {
            jsonObject.put((Object)key, value);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"set jsonObject value error ", (Throwable)e, 90160758787071L);
        }
    }

    private static boolean isObjectNullOrEmpty(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof String) {
            return VerifyUtil.isEmpty((Object)obj) || NULL_VALUE.equals((String)obj);
        }
        if (obj instanceof JSONObject) {
            JSONObject json = (JSONObject)obj;
            return json.size() < 1;
        }
        if (obj instanceof JSONArray) {
            JSONArray json = (JSONArray)obj;
            return json.size() < 1;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.isEmpty();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.isEmpty();
        }
        return false;
    }

    private static boolean isNumber(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == Byte.TYPE || obj.getClass() == Short.TYPE || obj.getClass() == Integer.TYPE || obj.getClass() == Long.TYPE) {
            return true;
        }
        if (obj.getClass() == Float.TYPE || obj.getClass() == Double.TYPE) {
            return true;
        }
        return obj instanceof Number;
    }

    private static boolean isSimpleType(Class<?> clazz) {
        if (null == clazz) {
            return false;
        }
        if (clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Character.TYPE)) {
            return true;
        }
        if (clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Double.TYPE)) {
            return true;
        }
        return Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz);
    }
}

