/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.rest;

import com.huawei.ism.drm.galax.sdk.vrm.model.ListAllVmsResponseType;
import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.galax.util.rest.LoginVrmResponseType;
import com.huawei.ism.drm.galax.util.rest.VrmResponseHandler;
import com.huawei.ism.drm.rest.client.IResponseHandler;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;

public class RestServiceClient
extends RestClient {
    private static final Log log = LogFactory.getInstance(RestServiceClient.class);
    private static final String CONTENT_TYPE_KEY = "Content-type";
    private static final String CONTENT_TYPE_VALUE = "application/json;charset=UTF-8";
    private static final String ACCEPT_KEY = "Accept";
    private static final String ACCEPT_VALUE = "application/json;charset=UTF-8";
    private static final String X_AUTH_TOKEN_KEY = "X-Auth-Token";
    private static final String X_AUTH_LANGUAGE_KEY = "Accept-Language";
    private static final String X_AUTH_LANGUAGE_VALUE = "zh_CN";
    private static final String X_AUTH_USER_KEY = "X-Auth-User";
    private static final String X_AUTH_PASSWORD_KEY = "X-Auth-Key";
    private static final String X_AUTH_USERTYPE_KEY = "X-Auth-UserType";
    private static final String X_AUTH_USERTYPE_VALUE = "2";
    private static final String LOGIN_PATH = "/service/session";
    private static final String VRM_VERSION = ";version=";
    private static final String VRM_ROLE = "administrator";
    private static final String VRM_SECURITY_ROLE = "sysadmin";
    private static final String REPLACE_RULE = "\"storageType\":.*?,";
    private static final String REPLACE_VALUE = "";
    private static final String STORAGE_TYPE = "storageType";
    private static final String TYPE_REPLACE_RULE = "\"type\":[0-9a-zA-Z]+,";
    private static final String TYPE_REPLACE_RULE_BEHIND = ",\"type\":[0-9a-zA-Z]+}";
    private static final String REPLACE_VALUE_BEHIND = "}";
    private static final String VM_DISK_TYPE = "\"type\":";
    private static final String TEMPLATE_REPLACE_RULE = "\"isTemplate\":[0-9a-zA-Z]+,";
    private static final String TEMPLATE_REPLACE_RULE_BEHIND = ",\"isTemplate\":[0-9a-zA-Z]+}";
    private static final String VM_TEMPLATE = "\"isTemplate\":";
    private static final int RETRYTIMES = 3;
    private final Object[] lock = new Object[0];
    private String pwd;
    private String token;
    private String version;
    private String logUri;

    public RestServiceClient(String ip, int port, String userName, String pwd) {
        super(ip, port, userName, pwd, (IResponseHandler)new VrmResponseHandler(), new String[]{"TLSv1"});
        this.pwd = pwd;
    }

    public RestServiceClient(String ip, int port, String userName, String pwd, IResponseHandler handler) {
        super(ip, port, userName, pwd, handler, new String[]{"TLSv1"});
        this.pwd = pwd;
    }

    public RestServiceClient(String ip, int port, String userName, String pwd, String version, String loguri) {
        super(ip, port, userName, pwd, (IResponseHandler)new VrmResponseHandler(), new String[]{"TLSv1"});
        this.pwd = pwd;
        this.version = version;
        this.logUri = loguri;
    }

    public String getPwd() {
        return this.pwd;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getLogUri() {
        return this.logUri;
    }

    public void setLogUri(String logUri) {
        this.logUri = logUri;
    }

    protected String login() {
        log.info((Object)"Entry into login", 90160758786816L);
        ServiceResponse response = this.post(this.getLoginUrl());
        this.checkAdminUser(response.getResponseString());
        this.getTokenInfo(response.getResponseHeaders());
        return REPLACE_VALUE;
    }

    protected boolean isNeedRetry(LegoCheckedException e, int times) {
        return 1073947398L == e.getErrorCode() && times < 2;
    }

    public <T> T get(String url, Class<T> responseType) {
        log.debug((Object)("Enter get, url = " + url), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                String responseStr = this.getResponseByUrl(url);
                log.debug((Object)("Leave get success, url=" + url + ", response :" + responseStr), 90160758786816L);
                this.checkErrorCode(responseStr, responseType);
                return this.getBody(responseStr, responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Get message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("Get message catch exception, ip=" + this.getIp() + ", url=" + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
        }
        log.error((Object)("get message failed for three times, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    private <T> void checkErrorCode(String responseStr, Class<T> responseType) {
        String errorCode;
        JSONObject jsonObject;
        String trimResponse;
        if (!VerifyUtil.isEmpty((String)responseStr) && ListAllVmsResponseType.class.equals(responseType) && (trimResponse = responseStr.trim()).startsWith("{") && trimResponse.endsWith(REPLACE_VALUE_BEHIND) && (jsonObject = JSONObject.fromObject((Object)trimResponse)).containsKey((Object)"errorCode") && !VerifyUtil.isEmpty((String)(errorCode = jsonObject.getString("errorCode")))) {
            log.error((Object)"response contain error:%s", new Object[]{errorCode});
            throw new LegoCheckedException(-1L, new String[]{"fusionsphere.error." + errorCode});
        }
    }

    protected String getResponseByUrl(String url) {
        return this.getGetResponse(url);
    }

    private String getGetResponse(String url) {
        try {
            return this.get(url, null, this.getHeader());
        }
        catch (LegoCheckedException ex) {
            log.error((Object)"get response error", (Throwable)ex, 90160758787071L);
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"get response error", (long)-1L, null, (Log)log);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public <T> ServiceResponse post(String url) {
        log.debug((Object)("Enter post, url = " + url), 90160758786816L);
        ServiceResponse response = this.getPostResponse(url, null, this.getLoginHeader(), false);
        this.checkLogin(response);
        if (response.getResponseString().contains("errorCode=10100119")) {
            Object[] objectArray = this.lock;
            // MONITORENTER : this.lock
            response = this.getPostResponse(url, null, this.getPostHeader(), false);
            // MONITOREXIT : objectArray
            log.debug((Object)("postForLogin url = " + url), 90160758786816L);
        }
        log.debug((Object)("Finish post, url = " + url + "response : " + response.getResponseString()), 90160758786816L);
        return response;
    }

    public <T> T post(String url, Object request, Class<T> responseType, boolean replaceFlag) {
        log.debug((Object)("Enter post, url = " + url + ", request : " + request), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                ServiceResponse response = this.getPostResponse(url, request, this.getPostHeader(), replaceFlag);
                log.debug((Object)("Leave post success, url=" + url + ", response :" + response.getResponseString()), 90160758786816L);
                return this.getBody(response.getResponseString(), responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Post message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("Post message failed, ip=" + this.getIp() + ", url=" + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("VrmClient error, targetIp = " + this.getIp() + ", retry = " + i), (long)-1L, null, (Log)log);
            }
        }
        log.error((Object)("get message failed for three times, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    public <T> T put(String url, Object request, Class<T> responseType) {
        log.debug((Object)("Enter put, url = " + url + "request : " + request), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                String response = this.getPutResponse(url, request, this.getHeader());
                log.debug((Object)("Leave put success, url=" + url + "response : " + response), 90160758786816L);
                return this.getBody(response, responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Put message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("Failed to put put response, ip=" + this.getIp() + ", url=" + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)("fail to get put response, targetIp = " + this.getIp() + ", url=" + url + ", retry = " + i + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        log.error((Object)("put message failed for three times, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    public <T> T delete(String url, Class<T> responseType) {
        log.debug((Object)("Enter delete, url = " + url), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                String response = this.getDeleteResponse(url, this.getHeader());
                log.debug((Object)("Leave delete success, url=" + url + ", response :" + response), 90160758786816L);
                return this.getBody(response, responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Delete message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("Delete message catch exception, ip=" + this.getIp() + ", url=" + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)("VrmClient error, targetIp = " + this.getIp() + ", url=" + url + ", retry = " + i + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        log.error((Object)("delete message failed for three times, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    protected List<Header> getHeader() {
        ArrayList<Header> headers = new ArrayList<Header>();
        BasicHeader strToken = new BasicHeader(X_AUTH_TOKEN_KEY, (Object)this.getToken());
        BasicHeader conType = new BasicHeader(CONTENT_TYPE_KEY, (Object)"application/json;charset=UTF-8");
        if (null != this.version && !this.version.isEmpty()) {
            String acceptValue = "application/json;charset=UTF-8;version=" + this.version.substring(1);
            BasicHeader accept = new BasicHeader(ACCEPT_KEY, (Object)acceptValue);
            headers.add((Header)accept);
        } else {
            BasicHeader accept = new BasicHeader(ACCEPT_KEY, (Object)this.getDefaultHeader());
            headers.add((Header)accept);
        }
        headers.add((Header)strToken);
        headers.add((Header)conType);
        return headers;
    }

    protected Map<String, String> getPostHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(X_AUTH_TOKEN_KEY, this.getToken());
        headers.put(CONTENT_TYPE_KEY, "application/json;charset=UTF-8");
        if (null != this.version && !this.version.isEmpty()) {
            String acceptValue = "application/json;charset=UTF-8;version=" + this.version.substring(1);
            headers.put(ACCEPT_KEY, acceptValue);
        } else {
            headers.put(ACCEPT_KEY, this.getDefaultHeader());
        }
        return headers;
    }

    protected String getDefaultHeader() {
        return "application/json;charset=UTF-8";
    }

    private Map<String, String> getLoginHeader() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.putAll(this.getBaseHeaders());
        headers.put(CONTENT_TYPE_KEY, "application/json;charset=UTF-8");
        headers.put(X_AUTH_LANGUAGE_KEY, X_AUTH_LANGUAGE_VALUE);
        headers.put(X_AUTH_USERTYPE_KEY, X_AUTH_USERTYPE_VALUE);
        return headers;
    }

    protected Map<String, String> getBaseHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(X_AUTH_USER_KEY, this.getUserName());
        headers.put(X_AUTH_PASSWORD_KEY, this.getPwd());
        return headers;
    }

    private String replaceStr(String obj, String replaceRule, String replaceVal) {
        String result = obj;
        if (null == obj) {
            return null;
        }
        if (obj.contains(VM_DISK_TYPE) || obj.contains(VM_TEMPLATE)) {
            result = obj.replaceAll(replaceRule, replaceVal);
        }
        return result;
    }

    private String transferRegisterMsg(String msg) {
        String result = msg;
        result = this.replaceStr(result, TYPE_REPLACE_RULE, REPLACE_VALUE);
        result = this.replaceStr(result, TYPE_REPLACE_RULE_BEHIND, REPLACE_VALUE_BEHIND);
        result = this.replaceStr(result, TEMPLATE_REPLACE_RULE, REPLACE_VALUE);
        result = this.replaceStr(result, TEMPLATE_REPLACE_RULE_BEHIND, REPLACE_VALUE_BEHIND);
        return result;
    }

    protected ServiceResponse getPostResponse(String url, Object message, Map<String, String> headers, boolean replaceTypeFlag) {
        String obj = this.getObjectToString(message);
        log.debug((Object)("Get PostResponse start, url : " + url), 90160758786816L);
        if (replaceTypeFlag) {
            obj = this.transferRegisterMsg(obj);
        }
        try {
            ServiceResponse serviceResponse = this.post(url, obj, null, headers);
            log.debug((Object)("Get PostResponse end, url : " + url + "response : " + serviceResponse.getResponseString()), 90160758786816L);
            return serviceResponse;
        }
        catch (LegoCheckedException ex) {
            log.error((Object)"Get response error", (Throwable)ex, 90160758787071L);
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"post response error", (long)-1L, null, (Log)log);
            return null;
        }
    }

    private String getPutResponse(String url, Object message, List<Header> headers) {
        String obj = this.getObjectToString(message);
        log.info((Object)"get PutResponse start", 90160758786816L);
        try {
            return this.put(url, obj, null, headers);
        }
        catch (LegoCheckedException ex) {
            log.error((Object)("get response error, url=" + url), (Throwable)ex, 90160758787071L);
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"put response error", (long)-1L, null, (Log)log);
            return null;
        }
    }

    protected String getDeleteResponse(String url, List<Header> headers) {
        try {
            return this.delete(url, null, null, headers);
        }
        catch (LegoCheckedException ex) {
            log.error((Object)("get response error, url=" + url), (Throwable)ex, 90160758787071L);
            throw ex;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"post response error", (long)-1L, null, (Log)log);
            return null;
        }
    }

    private <T> T getBody(String json, Class<T> responseType) {
        Object body = CommonUtil.jsonToBean(json, responseType);
        return (T)body;
    }

    private String getObjectToString(Object msg) {
        String obj = CommonUtil.beanToJson(msg);
        if (null != obj && obj.contains(STORAGE_TYPE)) {
            obj = obj.replaceAll(REPLACE_RULE, REPLACE_VALUE);
        }
        return obj;
    }

    private String getLoginUrl() {
        if (null != this.logUri && !this.logUri.isEmpty()) {
            return this.logUri;
        }
        return LOGIN_PATH;
    }

    private void checkAdminUser(String response) {
        LoginVrmResponseType body = this.getBody(response, LoginVrmResponseType.class);
        if (!(null == body || VerifyUtil.isEmpty(body.getRoleList()) || body.getRoleList().contains(VRM_ROLE) || body.getRoleList().contains(VRM_SECURITY_ROLE))) {
            throw new LegoCheckedException(1073947400L);
        }
    }

    private void getTokenInfo(Header[] headers) {
        if (headers == null || headers.length == 0) {
            return;
        }
        for (Header header : headers) {
            if (!header.getName().equalsIgnoreCase(X_AUTH_TOKEN_KEY)) continue;
            this.setToken(header.getValue());
            break;
        }
    }

    protected void checkLogin(ServiceResponse response) {
        if (null == response.getResponseString()) {
            throw new LegoCheckedException(1073947399L);
        }
        if (response.getResponseString().contains("10100307") || response.getResponseString().contains("10100103")) {
            throw new LegoCheckedException(256L);
        }
        if (response.getResponseString().contains("10100116")) {
            throw new LegoCheckedException(1073947663L);
        }
    }
}

