/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.rest;

import com.huawei.ism.drm.galax.util.rest.CommonUtil;
import com.huawei.ism.drm.galax.util.rest.RestServiceClient;
import com.huawei.ism.drm.galax.util.rest.VrgResponseHandler;
import com.huawei.ism.drm.rest.client.util.ServiceResponse;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import org.apache.hc.core5.http.Header;

public class VrgRestServiceClient
extends RestServiceClient {
    private static final Log log = LogFactory.getInstance(VrgRestServiceClient.class);
    private static final String ACCEPT_VALUE = "application/json;version=1.1;charset=UTF-8";
    private static final String X_AUTH_TOKEN_KEY = "X-Auth-Token";
    private static final String LOGIN_PATH = "/vrgservice/session";
    private static final int RESPONSE_TIME_OUT = 1800000;
    private static final long LOGIN_INVALID_CODE = 10440208L;
    private static final long ACCOUNT_LOCKED_CODE = 10440207L;
    private static final String UUID = "uuid";
    private static final int RETRYTIMES = 3;
    private int timeout = 1800000;

    public VrgRestServiceClient(String ip, int port, String userName, String pwd) {
        super(ip, port, userName, pwd, new VrgResponseHandler());
    }

    public VrgRestServiceClient(String ip, int port, String userName, String pwd, String version, String loguri) {
        super(ip, port, userName, pwd, new VrgResponseHandler());
        this.setLogUri(loguri);
        this.setVersion(version);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public String login() {
        String uuid;
        log.info((Object)"Entry into login.", 90160758786816L);
        ServiceResponse response = this.post(this.getLoginUrl());
        this.getTokenInfo(response.getResponseHeaders());
        try {
            uuid = (String)JSONObject.fromObject((Object)response.getResponseString()).get(UUID);
        }
        catch (LegoCheckedException e) {
            log.error((Object)"create jsonObject failed", (Throwable)e, 90160758787071L);
            throw new LegoCheckedException(1073947399L, (Throwable)e);
        }
        catch (Exception e) {
            uuid = null;
            ExceptionUtil.rethrowException((Throwable)e, (String)"exception for other reason to get the uuid", (long)1073947399L, null, (Log)log);
        }
        return uuid;
    }

    @Override
    public <T> T get(String url, Class<T> responseType) {
        log.debug((Object)("Enter get, url = " + url), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                String response = this.getResponseByUrl(url);
                log.debug((Object)("Response in get function is" + response + ", url=" + url), 90160758786816L);
                return this.getBody(response, responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Get message failed and retry it, url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("Get message exception, url=" + url), (Throwable)e, 90160758787071L);
                throw e;
            }
        }
        log.error((Object)("get message failed, url=" + url), 90160758787071L);
        throw new LegoCheckedException(1073947399L);
    }

    public synchronized <T> T post(String url, Object request, Class<T> responseType) {
        log.debug((Object)("Enter post, url = " + url + "request :" + request), 90160758786816L);
        this.login();
        for (int i = 0; i < 3; ++i) {
            try {
                ServiceResponse response = this.getPostResponse(url, request, this.getPostHeader(), false);
                log.debug((Object)("Leave post, response is " + response.getResponseString() + ", url=" + url), 90160758786816L);
                return this.getBody(response.getResponseString(), responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Post message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("getPostResponse error, ip=" + this.getIp() + ", url = " + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)("getPostResponse error, targetIp = " + this.getIp() + ", url=" + url + ", retry = " + i), (long)-1L, null, (Log)log);
            }
        }
        log.error((Object)("post message failed, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    @Override
    public <T> T delete(String url, Class<T> responseType) {
        log.debug((Object)("Enter delete, url = " + url), 90160758786816L);
        for (int i = 0; i < 3; ++i) {
            try {
                String response = this.getDeleteResponse(url, this.getHeader());
                log.debug((Object)("Leave delete, response is " + response + ", url=" + url), 90160758786816L);
                return this.getBody(response, responseType);
            }
            catch (LegoCheckedException e) {
                if (1073947691L == e.getErrorCode()) {
                    this.login();
                    continue;
                }
                if (this.isNeedRetry(e, i)) {
                    log.warn((Object)("Delete message failed and retry it, ip=" + this.getIp() + ", url=" + url + ", times=" + i), 90160758787071L);
                    continue;
                }
                log.error((Object)("VRGClient error, ip=" + this.getIp() + ", url = " + url + ", retry = " + i), (Throwable)e, 90160758787071L);
                throw e;
            }
            catch (Exception e) {
                log.error((Object)("VRGClient error, targetIp = " + this.getIp() + ", url=" + url + ", retry = " + i + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758787071L);
                throw new LegoCheckedException(-1L, (Throwable)e);
            }
        }
        log.error((Object)("delete message failed, ip=" + this.getIp() + ", url=" + url), 90160758787071L);
        throw new LegoCheckedException(-1L);
    }

    private <T> T getBody(String json, Class<T> responseType) {
        Object body = CommonUtil.jsonToBean(json, responseType);
        return (T)body;
    }

    private String getLoginUrl() {
        if (null != this.getLogUri() && !this.getLogUri().isEmpty()) {
            return this.getLogUri();
        }
        return LOGIN_PATH;
    }

    private void getTokenInfo(Header[] headers) {
        if (headers != null && headers.length > 0) {
            for (Header header : headers) {
                if (!header.getName().equalsIgnoreCase(X_AUTH_TOKEN_KEY)) continue;
                this.setToken(header.getValue());
                break;
            }
        }
    }

    @Override
    protected void checkLogin(ServiceResponse response) {
        if (null == response) {
            throw new LegoCheckedException(1073947399L);
        }
        if (response.getResponseString().contains("10440200") || response.getResponseString().contains("10440201") || response.getResponseString().contains("10440202") || response.getResponseString().contains("10440203")) {
            log.info((Object)("login response is " + response.getResponseString()), 90160758786816L);
            throw new LegoCheckedException(256L);
        }
        if (response.getResponseString().contains("10440207")) {
            log.info((Object)("login response is " + response.getResponseString()), 90160758786816L);
            throw new LegoCheckedException(10440207L);
        }
        if (response.getResponseString().contains("10440208")) {
            log.info((Object)("login response is " + response.getResponseString()), 90160758786816L);
            throw new LegoCheckedException(10440208L);
        }
        if (response.getResponseString().contains("10440101") || response.getResponseString().contains("10440300") || response.getResponseString().contains("10440301") || response.getResponseString().contains("10440302")) {
            log.info((Object)("login response is " + response.getResponseString()), 90160758786816L);
            throw new LegoCheckedException(1073947393L);
        }
        if (response.getResponseString().contains("10440000") || response.getResponseString().contains("Internal Server Error")) {
            log.info((Object)("login response is " + response.getResponseString()), 90160758786816L);
            throw new LegoCheckedException(1073947850L);
        }
    }

    @Override
    protected String getDefaultHeader() {
        return ACCEPT_VALUE;
    }
}

