/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.galax.util.task;

import com.huawei.lego.cbb.backtask.sdk.model.BackTask;
import com.huawei.lego.cbb.backtask.sdk.model.TaskResultItem;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;

public class GalaxTaskUtil {
    public static void generateTaskResultItem(BackTask backTask, String vmName, int result, LegoCheckedException ex) {
        String nationalKey;
        if (VerifyUtil.isEmpty((Object)backTask)) {
            return;
        }
        TaskResultItem taskResultItem = new TaskResultItem();
        if (null != ex && 0L != ex.getErrorCode()) {
            nationalKey = ex.getErrorMessageKey();
            taskResultItem.setParam(GalaxTaskUtil.getParams(ex.getParameters()));
        } else {
            nationalKey = "ism.drm.site.success";
        }
        taskResultItem.setDetail(nationalKey);
        taskResultItem.setResName(vmName);
        taskResultItem.setResult(Integer.valueOf(result));
        taskResultItem.setResultItem(backTask);
        backTask.getTaskResultSet().add(taskResultItem);
    }

    private static String getParams(String[] params) {
        if (null == params || params.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String param : params) {
            builder.append(param);
            builder.append("|");
        }
        return builder.toString();
    }

    public static void cancelFutureList(List<Future<?>> futureList) {
        if (VerifyUtil.isEmpty(futureList)) {
            return;
        }
        for (Future<?> future : futureList) {
            if (future.isDone()) continue;
            future.cancel(true);
        }
    }

    public static void throwTaskFailedException(BackTask backTask) {
        if (null == backTask) {
            return;
        }
        boolean isAllSuccessed = true;
        Set taskResultItems = backTask.getTaskResultSet();
        for (TaskResultItem taskResultItem : taskResultItems) {
            if (taskResultItem.getResult() != 1) continue;
            isAllSuccessed = false;
            break;
        }
        if (!isAllSuccessed) {
            throw new LegoUncheckedException("SubTask Failed.");
        }
    }
}

