/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.model;

import com.huawei.ism.drm.openstack.sdk.constants.OpenstackEnumDefine;
import com.huawei.ism.drm.openstack.sdk.model.OpenStackPortFixedIp;
import com.huawei.ism.drm.openstack.sdk.msg.PortIPInfo;
import com.huawei.ism.drm.openstack.sdk.msg.PortInfo;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OpenStackPort
extends ManagedObject {
    private static final long serialVersionUID = -7897049536971640483L;
    private String networkUuid;
    private String projectUuid;
    private String type;
    private String mac;
    private boolean primaryInterface;
    private Set<OpenStackPortFixedIp> fixedIps;

    public OpenStackPort() {
    }

    public OpenStackPort(String openstackUuid, PortInfo info) {
        this.setUuid(openstackUuid + ":" + info.getId());
        this.setStatus(OpenstackEnumDefine.NETNE_STATUS_E.getStatus(info.getStatus()).getValue());
        this.setNetworkUuid(openstackUuid + ":" + info.getNetworkId());
        this.setProjectUuid(openstackUuid + ":" + info.getProjectId());
        this.setMac(info.getMacAddress());
        this.setName(info.getName());
        List<PortIPInfo> ipInfoList = info.getFixedIps();
        if (null != ipInfoList) {
            for (PortIPInfo ipInfo : ipInfoList) {
                OpenStackPortFixedIp fixIp = new OpenStackPortFixedIp();
                fixIp.setSubnetUuid(openstackUuid + ":" + ipInfo.getSubnetId());
                fixIp.setIp(ipInfo.getIpAddress());
                this.getFixedIps().add(fixIp);
            }
        }
        if (null != info.getPortVifDetailsInfo()) {
            this.setPrimaryInterface(info.getPortVifDetailsInfo().isPrimaryInterface());
        }
    }

    public boolean isPrimaryInterface() {
        return this.primaryInterface;
    }

    public void setPrimaryInterface(boolean primaryInterface) {
        this.primaryInterface = primaryInterface;
    }

    public String getNetworkUuid() {
        return this.networkUuid;
    }

    public String getProjectUuid() {
        return this.projectUuid;
    }

    public String getMac() {
        return this.mac;
    }

    public Set<OpenStackPortFixedIp> getFixedIps() {
        if (null == this.fixedIps) {
            this.fixedIps = new HashSet<OpenStackPortFixedIp>();
        }
        return this.fixedIps;
    }

    public void setNetworkUuid(String networkUuid) {
        this.networkUuid = networkUuid;
    }

    public void setProjectUuid(String projectUuid) {
        this.projectUuid = projectUuid;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setFixedIps(Set<OpenStackPortFixedIp> fixedIps) {
        this.fixedIps = fixedIps;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

