/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.openstack.sdk.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.ism.drm.constant.coreenum.ServiceInstaceEnumDefine;
import com.huawei.ism.drm.util.ParamChecker;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Iterator;
import java.util.List;

public class OpenStackVolTypeMapping
extends ManagedObject {
    private static final long serialVersionUID = -9198986830521222513L;
    private static Log logger = LogFactory.getInstance(OpenStackVolTypeMapping.class);
    @JsonProperty(value="primary_volType")
    private String primaryVolType;
    @JsonProperty(value="second_volType")
    private String secondVolType;
    @JsonProperty(value="voltype_pair_id")
    private Long moId;
    @JsonProperty(value="primary_az_id")
    private String primaryAzId;
    @JsonProperty(value="second_az_id")
    private String secondAzId;
    @JsonProperty(value="priority")
    private int priority;

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getPrimaryVolType() {
        return this.primaryVolType;
    }

    public void setPrimaryVolType(String primaryVolType) {
        this.primaryVolType = primaryVolType;
    }

    public String getSecondVolType() {
        return this.secondVolType;
    }

    public void setSecondVolType(String secondVolType) {
        this.secondVolType = secondVolType;
    }

    public Long getMoId() {
        return this.moId;
    }

    public void setMoId(Long moId) {
        this.moId = moId;
    }

    public String getPrimaryAzId() {
        return this.primaryAzId;
    }

    public void setPrimaryAzId(String primaryAzId) {
        this.primaryAzId = primaryAzId;
    }

    public String getSecondAzId() {
        return this.secondAzId;
    }

    public void setSecondAzId(String secondAzId) {
        this.secondAzId = secondAzId;
    }

    public String getAzIdentity() {
        return OpenStackVolTypeMapping.getAzIdentity(this.primaryAzId, this.secondAzId);
    }

    public static String getAzIdentity(String primaryRegion, String primaryAz, String secondRegion, String secondAz) {
        return OpenStackVolTypeMapping.getAzIdentity(OpenStackVolTypeMapping.getMappingAzId(primaryRegion, primaryAz), OpenStackVolTypeMapping.getMappingAzId(secondRegion, secondAz));
    }

    public static String getMappingAzId(String region, String az) {
        if (VerifyUtil.isEmpty((String)region) || VerifyUtil.isEmpty((String)az)) {
            return "";
        }
        return region + "_@_" + az;
    }

    private static String getAzIdentity(String primaryAzId, String secondAzId) {
        String sAz;
        if (VerifyUtil.isEmpty((String)primaryAzId) && VerifyUtil.isEmpty((String)secondAzId)) {
            return "";
        }
        String pAz = VerifyUtil.isEmpty((String)primaryAzId) ? "" : primaryAzId;
        String string = sAz = VerifyUtil.isEmpty((String)secondAzId) ? "" : secondAzId;
        if (pAz.compareTo(sAz) <= 0) {
            return pAz + "_@_" + sAz;
        }
        return sAz + "_@_" + pAz;
    }

    private boolean checkAzId() {
        if (ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)this.getType()) == ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.REPLICATION || ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)this.getType()) == ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.HYPERMETRO) {
            return this.checkAzId(this.primaryAzId) && this.checkAzId(this.secondAzId);
        }
        return true;
    }

    private boolean checkAzId(String azId) {
        if (!VerifyUtil.isEmpty((String)azId)) {
            String[] array = azId.split("_@_");
            return array.length == 2 && ParamChecker.checkGeneralId((String)array[0]) && ParamChecker.checkGeneralId((String)array[1]);
        }
        return false;
    }

    public boolean checkObject() {
        return this.checkVolTypleName(this.primaryVolType) && this.checkVolTypleName(this.secondVolType) && this.typeIsExists(super.getType()) && this.checkAzId();
    }

    public boolean checkSame() {
        String primaryIdentity;
        if (!this.checkObject()) {
            logger.error((Object)"OpenStackAvailabilityZoneMapping is null or empty.", 90160758786989L);
            return false;
        }
        String secondIdentity = this.secondVolType + this.secondAzId;
        return !secondIdentity.equals(primaryIdentity = this.primaryVolType + this.primaryAzId);
    }

    public boolean checkSame(OpenStackVolTypeMapping mapping) {
        String primVolType = mapping.getPrimaryVolType();
        String secVolType = mapping.getSecondVolType();
        String otherType = mapping.getType();
        if (!VerifyUtil.isEmpty((String)otherType) && !otherType.equals(this.getType())) {
            return false;
        }
        if (OpenStackVolTypeMapping.checkVolTypeMatch(this.primaryVolType, primVolType) && OpenStackVolTypeMapping.checkVolTypeMatch(this.secondVolType, secVolType) || OpenStackVolTypeMapping.checkVolTypeMatch(this.primaryVolType, secVolType) && OpenStackVolTypeMapping.checkVolTypeMatch(this.secondVolType, primVolType)) {
            return this.getAzIdentity().equals(mapping.getAzIdentity());
        }
        return false;
    }

    private boolean checkVolTypleName(String name) {
        return !VerifyUtil.isEmpty((String)name) && ParamChecker.checkVolumeType((String)name);
    }

    private boolean typeIsExists(String type) {
        return !VerifyUtil.isEmpty((String)type) && null != ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)type);
    }

    public static String checkSameByVolTypeMapping(List<OpenStackVolTypeMapping> mappings1, List<OpenStackVolTypeMapping> mappings2) {
        StringBuffer flag = new StringBuffer();
        for (OpenStackVolTypeMapping mapping1 : mappings1) {
            for (OpenStackVolTypeMapping mapping2 : mappings2) {
                if (!VerifyUtil.isEmpty((String)mapping1.getType()) && !mapping1.getType().equals(mapping2.getType()) || !mapping1.getAzIdentity().equals(mapping2.getAzIdentity())) continue;
                if (OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getPrimaryVolType()) && OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getSecondVolType())) {
                    flag.append(mapping1.getPrimaryVolType());
                    flag.append(',');
                }
                if (!OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getPrimaryVolType()) || !OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getSecondVolType())) continue;
                flag.append(mapping1.getSecondVolType());
                flag.append(',');
            }
        }
        return VerifyUtil.isEmpty((String)flag.toString()) ? flag.toString() : flag.substring(0, flag.length() - 1);
    }

    public static boolean checkVolTypeListRepeat(List<OpenStackVolTypeMapping> mappingLists) {
        if (VerifyUtil.isEmpty(mappingLists)) {
            return false;
        }
        for (int i = 0; i < mappingLists.size(); ++i) {
            if (!mappingLists.get(i).checkSame()) {
                return true;
            }
            for (int j = i + 1; j < mappingLists.size(); ++j) {
                if (!mappingLists.get(i).checkSame(mappingLists.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToJson(List<OpenStackVolTypeMapping> mappings) {
        JSONArray jsonMapping = new JSONArray();
        for (OpenStackVolTypeMapping mapping : mappings) {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"volType_pair_id", (Object)mapping.getMoId());
            jsonObj.put((Object)"primary_volType", (Object)mapping.getPrimaryVolType());
            jsonObj.put((Object)"second_volType", (Object)mapping.getSecondVolType());
            jsonObj.put((Object)"primary_az_id", (Object)mapping.getPrimaryAzId());
            jsonObj.put((Object)"second_az_id", (Object)mapping.getSecondAzId());
            jsonObj.put((Object)"priority", (Object)mapping.getPriority());
            ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E type = ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.getTypeFromValue((String)mapping.getType());
            if (null != type) {
                jsonObj.put((Object)"type", (Object)type.getFrontValue());
            } else {
                jsonObj.put((Object)"type", (Object)mapping.getType());
            }
            jsonMapping.add((Object)jsonObj);
        }
        return jsonMapping.toString();
    }

    public static boolean checkSamePriorityByVolTypeMapping(List<OpenStackVolTypeMapping> mappings1, List<OpenStackVolTypeMapping> mappings2) {
        Iterator<OpenStackVolTypeMapping> iterator = mappings1.iterator();
        if (iterator.hasNext()) {
            OpenStackVolTypeMapping mapping1 = iterator.next();
            return OpenStackVolTypeMapping.isExistSamePriority(mappings2, mapping1);
        }
        return false;
    }

    private static boolean isExistSamePriority(List<OpenStackVolTypeMapping> mappings2, OpenStackVolTypeMapping mapping1) {
        for (OpenStackVolTypeMapping mapping2 : mappings2) {
            if (!mapping1.getAzIdentity().equals(mapping2.getAzIdentity()) || !mapping1.getType().equals(mapping2.getType()) || mapping1.getPriority() != mapping2.getPriority() || !OpenStackVolTypeMapping.checkVolTypeMapping(mapping1, mapping2)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkVolTypeMapping(OpenStackVolTypeMapping mapping1, OpenStackVolTypeMapping mapping2) {
        return mapping1.getType().equals(ServiceInstaceEnumDefine.SERVICEINSTANCE_TYPE_E.VHA.getValue()) ? OpenStackVolTypeMapping.isVhaReqiure(mapping1, mapping2) : OpenStackVolTypeMapping.isCshaCsdrRequire(mapping1, mapping2);
    }

    private static boolean isCshaCsdrRequire(OpenStackVolTypeMapping mapping1, OpenStackVolTypeMapping mapping2) {
        if (OpenStackVolTypeMapping.checkCshaAndCshaVolType(mapping1, mapping2)) {
            logger.error((Object)"Added volumeType mapping %s has same priority with AZ: %s", new Object[]{mapping1.getAzIdentity(), mapping2.getAzIdentity()});
            return true;
        }
        return false;
    }

    private static boolean isVhaReqiure(OpenStackVolTypeMapping mapping1, OpenStackVolTypeMapping mapping2) {
        if (OpenStackVolTypeMapping.checkVhaVolType(mapping1, mapping2)) {
            logger.error((Object)"Added volumeType mapping has same priority with AZ: %s", new Object[]{mapping1.getAzIdentity()});
            return true;
        }
        return false;
    }

    private static boolean checkCshaAndCshaVolType(OpenStackVolTypeMapping mapping1, OpenStackVolTypeMapping mapping2) {
        return OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getPrimaryVolType()) && !OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getSecondVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getSecondVolType()) && !OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getPrimaryVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getSecondVolType()) && !OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getPrimaryVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getPrimaryVolType()) && !OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getSecondVolType());
    }

    private static boolean checkVhaVolType(OpenStackVolTypeMapping mapping1, OpenStackVolTypeMapping mapping2) {
        return OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getPrimaryVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getPrimaryVolType(), mapping2.getSecondVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getPrimaryVolType()) || OpenStackVolTypeMapping.checkVolTypeMatch(mapping1.getSecondVolType(), mapping2.getSecondVolType());
    }

    private static boolean checkVolTypeMatch(String primaryVolumeType, String secondVolumeTpe) {
        return primaryVolumeType.equals(secondVolumeTpe);
    }
}

