/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.check;

import com.huawei.drm.install.common.check.VersionList;
import com.huawei.lego.common.extend.ExtendCommon;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class VersionCheck {
    public static final String VERSION_KEY = "version";
    public static final String R3C10 = "OceanStor ReplicationDirector V100R003C10";
    private static VersionCheck instance = new VersionCheck();
    private static Log logger = LogFactory.getInstance(VersionCheck.class);
    private static final String UPDATE_SUPPORT_FILE = "config/conf/update_support.xml";

    private VersionCheck() {
    }

    public static VersionCheck getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        if (!instance.isPreVersionCanUpdate()) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("drm.update.version.err.00001"));
            System.exit(-1);
        } else {
            System.exit(0);
        }
    }

    public boolean isSupportUpgrade(String oldVersion) {
        logger.info((Object)("check is support upgrade, oldVersion is " + oldVersion), "");
        VersionList list = this.initUpgradeSupportVersion();
        if (VerifyUtil.isEmpty(list.getSupportMap()) || VerifyUtil.isEmpty((String)oldVersion)) {
            logger.error((Object)"support map is null, or oldVersion is null.", "");
            return false;
        }
        if (list.getNotSupportList().contains(oldVersion)) {
            logger.error((Object)"the target version is not support upgrade.", "");
            return false;
        }
        String currentFile = "Runtime/LegoRuntime/conf/legoDeploy.conf";
        String newVersion = this.getVersion(currentFile);
        if (VerifyUtil.isEmpty((String)newVersion)) {
            logger.error((Object)("get new version failed, new version is: " + newVersion), "");
            return false;
        }
        Map<String, List<String>> maps = list.getSupportMap();
        Set<String> data = maps.keySet();
        for (String key : data) {
            if (oldVersion.startsWith(key) && !newVersion.startsWith(key)) {
                logger.info((Object)"C upgrade.", "");
                return true;
            }
            if (!oldVersion.equals(key) && (!oldVersion.startsWith(key) || !newVersion.startsWith(key) || !maps.get(key).contains(oldVersion))) continue;
            logger.info((Object)"SPC upgrade.", "");
            return true;
        }
        logger.error((Object)"old version is not support upgrade", "");
        return false;
    }

    private VersionList initUpgradeSupportVersion() {
        VersionList list = new VersionList();
        HashMap<String, List<String>> mapping = new HashMap<String, List<String>>();
        ArrayList<String> excepts = new ArrayList<String>();
        try {
            File file = new File(UPDATE_SUPPORT_FILE);
            SAXReader xmlReader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)xmlReader);
            Document document = xmlReader.read(file);
            List vElement = document.selectNodes("/Upgrade/version");
            for (Node version : vElement) {
                ArrayList<String> spcVersion = new ArrayList<String>();
                String targetVer = ((Element)version).attribute("target").getValue();
                List childNodes = version.selectNodes("child");
                for (Node child : childNodes) {
                    String tarVer = targetVer + child.getText();
                    spcVersion.add(tarVer);
                }
                mapping.put(targetVer, spcVersion);
                List exceptList = version.selectNodes("except");
                for (Node except : exceptList) {
                    if (targetVer.equals(except.getText())) {
                        excepts.add(except.getText());
                        continue;
                    }
                    excepts.add(targetVer + except.getText());
                }
            }
            list.setSupportMap(mapping);
            list.setNotSupportList(excepts);
        }
        catch (DocumentException e) {
            logger.error((Object)e, "parase update_support.xml failed1.");
        }
        catch (Exception e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "parase update_support.xml failed2.");
        }
        return list;
    }

    public String getPreVersion() {
        try {
            String installedFile = OSInformation.getInstalledFile();
            if (!new File(installedFile).exists()) {
                logger.error((Object)"get preversion failed, the RDInstalled.xml is not exists.", "");
                return null;
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(installedFile));
            Element element = (Element)document.selectSingleNode("/install/installpath");
            Attribute attri = element.attribute("path");
            String path = attri.getText();
            String legoDeployConfFilePath = path + "/Runtime/LegoRuntime/conf/legoDeploy.conf";
            String version = this.getVersion(legoDeployConfFilePath);
            ExtendCommon.setOldVersion(version);
            return version;
        }
        catch (Exception e) {
            logger.error((Object)("Generate installed xml Error " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            return null;
        }
    }

    public boolean isPreVersionCanUpdate() {
        String preVersion = this.getPreVersion();
        if (null == preVersion) {
            logger.error((Object)"The preVersion is null", "");
            return false;
        }
        boolean isPreVersionCanUpdate = this.isSupportUpgrade(preVersion);
        logger.info((Object)("isPreVersionCanUpdate preVersion=" + preVersion + "; isPreVersionCanUpdate=" + isPreVersionCanUpdate), "");
        return isPreVersionCanUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getVersion(String legoDeployConfFilePath) {
        FileInputStream newfile = null;
        try {
            newfile = new FileInputStream(legoDeployConfFilePath);
            Properties proType = new Properties();
            proType.load(newfile);
            String string = proType.getProperty(VERSION_KEY);
            return string;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"can not find the version file in LegoRuntime.", "");
        }
        catch (Exception e) {
            logger.error((Object)("get package type failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        finally {
            try {
                ((InputStream)newfile).close();
            }
            catch (IOException e1) {
                logger.error((Object)"colse FileInputStream failed.", "");
            }
        }
        return null;
    }
}

