/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.dto;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class DataBaseUtil {
    private static Log logger = LogFactory.getInstance(DataBaseUtil.class);

    public static void updatePassword(String installPath, String managPwd, String dbaPwd) {
        logger.info((Object)"start update db password.", "");
        if (VerifyUtil.isEmpty((String)managPwd) && VerifyUtil.isEmpty((String)dbaPwd)) {
            logger.info((Object)"all password is empty. no need update", "");
            return;
        }
        XMLWriter output = null;
        try {
            String dbFile = installPath + File.separator + LegoResourceManager.getProValue("db.config.file");
            File file = new File(dbFile);
            if (!file.exists()) {
                logger.error((Object)"get database config failed, system.xml not found.", "");
                throw new PatchException("");
            }
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(dbFile));
            Element installElement = (Element)document.selectSingleNode("/install/database");
            if (!VerifyUtil.isEmpty((String)managPwd)) {
                installElement.addAttribute("managerpassword", WccEncryptor.encode(managPwd));
            }
            if (!VerifyUtil.isEmpty((String)dbaPwd)) {
                installElement.addAttribute("dbpassword", WccEncryptor.encode(dbaPwd));
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            output = new XMLWriter((Writer)new FileWriter(dbFile), format);
            output.write(document);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("update db password failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("");
            }
            catch (Throwable throwable) {
                DataBaseUtil.closeXmlWriter(output);
                throw throwable;
            }
        }
        DataBaseUtil.closeXmlWriter(output);
    }

    public static void updateDatabaseConfig(String installPath, DataBaseInfo dbInfo) {
        logger.info((Object)"start update database config.", "");
        Document document = null;
        Element dbEle = null;
        FileOutputStream fos = null;
        String filePath = installPath + File.separator + LegoResourceManager.getProValue("db.config.file");
        XMLWriter writer = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                logger.info((Object)"db config file not found, create it.", "");
                document = DocumentHelper.createDocument();
                Element sysEle = document.addElement("install");
                dbEle = sysEle.addElement("database");
            } else {
                logger.info((Object)"db config file already exists, update it.", "");
                SAXReader reader = new SAXReader();
                CommonUtil.setSecurityFeatures((SAXReader)reader);
                document = reader.read(file);
                dbEle = (Element)document.selectSingleNode("/install/database");
            }
            dbEle.addAttribute("type", dbInfo.getDbType());
            dbEle.addAttribute("dbhost", dbInfo.getDbHost());
            dbEle.addAttribute("dbport", dbInfo.getDbPort());
            dbEle.addAttribute("dbuserName", dbInfo.getDbaUsername());
            dbEle.addAttribute("dbpassword", WccEncryptor.encode(dbInfo.getDbaPassword()));
            dbEle.addAttribute("manageruserName", dbInfo.getManagerUsername());
            dbEle.addAttribute("managerpassword", WccEncryptor.encode(dbInfo.getManagerPassword()));
            dbEle.addAttribute("dbfilepath", dbInfo.getDbFilePath());
            dbEle.addAttribute("dbpath", dbInfo.getDbPath());
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            fos = new FileOutputStream(filePath);
            writer = new XMLWriter((OutputStream)fos, format);
            writer.write(document);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("update database config failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("");
            }
            catch (Throwable throwable) {
                DataBaseUtil.closeXmlWriter(writer);
                FileUtil.close(fos, "");
                throw throwable;
            }
        }
        DataBaseUtil.closeXmlWriter(writer);
        FileUtil.close(fos, "");
    }

    private static void closeXmlWriter(XMLWriter writer) {
        try {
            if (null != writer) {
                writer.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)("close xml writer failed. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }
}

