/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.util.CommonDBUtil;
import com.huawei.lego.common.util.Schedule;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class ProtectGroupUpdateHandler {
    private static final Log logger = LogFactory.getInstance(ProtectGroupUpdateHandler.class);

    public static void processPolicyTemplate(DataBaseInfo dbInfor) throws SQLException {
        try (Connection dbConnection = null;){
            dbConnection = LegoDBConnection.getInstance().connectGaussDB(dbInfor, "lego");
            ProtectGroupUpdateHandler.addColumn(dbConnection);
            ProtectGroupUpdateHandler.upgradeProtectPolicy(dbConnection);
        }
    }

    private static void addColumn(Connection dbConnection) throws SQLException {
        PreparedStatement pst = null;
        try {
            CommonDBUtil.executeSQL(dbConnection, "alter table TI_SCHEDULE add column HOURS varchar(255)");
            CommonDBUtil.executeSQL(dbConnection, "alter table TI_SCHEDULE add column SECONDS varchar(255)");
            CommonDBUtil.executeSQL(dbConnection, "alter table TI_SCHEDULE add column MINUTES varchar(255)");
        }
        finally {
            ProtectGroupUpdateHandler.closePreparedStatement(pst);
        }
    }

    private static void upgradeProtectPolicy(Connection conn) throws SQLException {
        ArrayList<Schedule> scheduleList = new ArrayList<Schedule>();
        PreparedStatement pst = null;
        try {
            pst = CommonDBUtil.executeSQLQuery(conn, "select t.scheduleid, t.starttime from ti_schedule t where t.peirodtype in (2,3,4)");
            ResultSet result = pst.executeQuery();
            while (result.next()) {
                String scheduleId = result.getString("scheduleid");
                String startTime = result.getString("starttime");
                scheduleList.add(new Schedule(scheduleId, startTime));
            }
        }
        catch (SQLException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "upgradeProtectPolicy failed.");
            throw new SQLException();
        }
        finally {
            ProtectGroupUpdateHandler.closePreparedStatement(pst);
        }
        ProtectGroupUpdateHandler.updateSchedule(conn, scheduleList);
    }

    private static void updateSchedule(Connection conn, List<Schedule> scheduleList) throws SQLException {
        for (Schedule schedule : scheduleList) {
            String startTime = schedule.getStartTime();
            Calendar startCalendar = Calendar.getInstance();
            long parseLong = 0L;
            try {
                parseLong = Long.parseLong(startTime);
            }
            catch (NumberFormatException e) {
                logger.error((Object)e, "error");
                throw e;
            }
            startCalendar.setTimeInMillis(parseLong);
            int hour = startCalendar.get(11);
            int min = startCalendar.get(12);
            int sec = startCalendar.get(13);
            String sql = "update ti_schedule set hours='" + hour + "', minutes='" + min + "', seconds='" + sec + "' where scheduleid='" + schedule.getScheduleId() + "'";
            CommonDBUtil.executeSQL(conn, sql);
        }
    }

    private static void closePreparedStatement(PreparedStatement pst) {
        try {
            if (pst != null) {
                pst.close();
            }
        }
        catch (SQLException e) {
            logger.error((Object)("PreparedStatement close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)));
        }
    }
}

