/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util;

import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ScriptExecutor {
    private static Log logger = LogFactory.getInstance(ScriptExecutor.class);
    private Connection conn = null;

    public ScriptExecutor(Connection conn) {
        this.conn = conn;
    }

    public List<String> runQuerySql(String sql) throws SQLException {
        Statement stmt = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            stmt = this.conn.createStatement();
            logger.info((Object)"runQuerySql.", "");
            ResultSet rs = stmt.executeQuery(sql);
            while (rs.next()) {
                list.add(rs.getString(1));
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (SQLException e) {
            logger.error((Object)("runQuerySql failed:" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new SQLException();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("statement close failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
    }

    public void runScripts(List<String> sqlScripts) throws SQLException {
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            logger.info((Object)("run scripts, size = " + sqlScripts.size()), "");
            for (int index = 0; index < sqlScripts.size(); ++index) {
                String sql = sqlScripts.get(index);
                stmt.execute(sql);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("runScripts sql failed, exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new SQLException();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("statement close failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
    }
}

