/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class LegoDBConnection {
    private static LegoDBConnection sInstance = null;
    private static final String GAUSS = "Gauss";
    private Log logger = LogFactory.getInstance(LegoDBConnection.class);

    public static LegoDBConnection getInstance() {
        if (null == sInstance) {
            sInstance = new LegoDBConnection();
        }
        return sInstance;
    }

    public Connection connectionGauss(DataBaseInfo dbInfor) {
        Connection conn = null;
        try {
            String host = dbInfor.getDbHost();
            int port = Integer.parseInt(dbInfor.getDbPort());
            String user = dbInfor.getManagerUsername();
            String pwd = dbInfor.getManagerPassword();
            String url = "jdbc:postgresql://" + host + ":" + port + "/postgres";
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection(url, user, pwd);
        }
        catch (SQLException ex) {
            this.logger.error((Object)("Gauss DB Connection Test Error" + ExceptionUtil.getErrorMessage((Throwable)ex)), "0x000252000FB5003A");
            return null;
        }
        catch (ClassNotFoundException ef) {
            this.logger.error((Object)("Gauss DB Connection Test Error" + ExceptionUtil.getErrorMessage((Throwable)ef)), "0x000252000FB5003A");
            return null;
        }
        this.logger.info((Object)"Gauss DB Connection Test success", "");
        return conn;
    }

    public Connection connectGaussDB(DataBaseInfo dbInfor, String dbName) {
        Connection conn = null;
        try {
            String host = dbInfor.getDbHost();
            int port = Integer.parseInt(dbInfor.getDbPort());
            String user = dbInfor.getDbaUsername();
            String pwd = dbInfor.getDbaPassword();
            String url = "jdbc:postgresql://" + host + ":" + port + "/" + dbName;
            Class.forName("org.postgresql.Driver");
            conn = DriverManager.getConnection(url, user, pwd);
        }
        catch (SQLException e) {
            this.logger.error((Object)("No DB:" + dbName), "");
            this.logger.error((Object)("Gauss DB Connection Test SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003A");
            return null;
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)("No DB:" + dbName), "");
            this.logger.error((Object)("Gauss DB Connection Test ClassNotFoundException" + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003A");
            return null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dbExist(DataBaseInfo dbInfor, String dbName) {
        boolean succ = false;
        Connection conn = null;
        try {
            if (dbInfor.getDbType().equalsIgnoreCase(GAUSS)) {
                conn = this.connectGaussDB(dbInfor, dbName);
            }
            if (conn != null) {
                succ = true;
            }
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)("close connection Error: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                }
            }
        }
        return succ;
    }
}

