/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.drm.install.common.util.dbtool;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DbScript;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.dbtool.InitDBTool;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitBundleXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.SignatureException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UninstallDBTool {
    private static Log logger = LogFactory.getInstance(UninstallDBTool.class);
    private static final String GAUSS = "Gauss";

    public static void uninstallDB(DataBaseInfo dbInfor, String savePath) throws IOException, SQLException {
        Connection conn = null;
        String uninstallFile = "";
        try {
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                uninstallFile = savePath + "/" + LegoResourceManager.getProValue("install.uninstalldb.target") + "/gauss/drop-lego.sql";
                conn = LegoDBConnection.getInstance().connectionGauss(dbInfor);
            }
            if (null == conn) {
                logger.info((Object)"Connection is null ,no need to fix database", "");
                return;
            }
            List<String> sqls = UninstallDBTool.getSqlList(uninstallFile);
            int count = 0;
            for (String sql : sqls) {
                if (sql.trim().length() <= 0) continue;
                UninstallDBTool.dealDB(sql, count, conn);
            }
        }
        catch (SQLException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), "uninstallDB SQL Error");
            throw new SQLException();
        }
        finally {
            UninstallDBTool.closeConnAndPStatement(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dealDB(String sql, int count, Connection conn) throws SQLException {
        PreparedStatement pst = null;
        try {
            logger.info((Object)("dealDB, Count:" + count++), "");
            if (null != conn) {
                pst = UninstallDBTool.getPreparedStatement(sql.trim(), conn);
            }
            if (null != pst) {
                pst.execute();
            }
        }
        catch (Throwable throwable) {
            UninstallDBTool.closeRes(pst);
            throw throwable;
        }
        UninstallDBTool.closeRes(pst);
    }

    private static PreparedStatement getPreparedStatement(String dropSql, Connection conn) throws SQLException {
        return conn.prepareStatement(dropSql);
    }

    private static void closeRes(PreparedStatement pst) {
        if (pst != null) {
            try {
                pst.close();
            }
            catch (SQLException e) {
                logger.error((Object)("PreparedStatement close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private static void closeConnAndPStatement(Connection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                logger.error((Object)("Connection close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void uninstallProductDBForInstall(DataBaseInfo dbInfor, String savePath) throws IOException, SQLException, SignatureException {
        Map<String, ProductBundles> productBundlesMap = InitBundleXmlTool.initProductBundls();
        for (ProductBundles productBundles : productBundlesMap.values()) {
            String dbFolder = "";
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                dbFolder = savePath + "/Runtime/bin/script/" + productBundles.getId() + "/dbscript/uninstall/gauss/";
            }
            DbScript dbUninstall = new DbScript();
            try {
                dbUninstall.setDataFiles(InitDBTool.getInsertDB(dbFolder));
                dbUninstall.setTable(InitDBTool.getKeyValueMap(dbFolder + "drop-table.properties"));
                dbUninstall.setDb(InitDBTool.getKeyValueMap(dbFolder + "drop-db.properties"));
            }
            catch (FileNotFoundException e1) {
                logger.error((Object)("bundle's dbfolder  " + productBundles.getId() + " or DROP_TABLE or DROP_DB not exists."), "");
                throw new FileNotFoundException();
            }
            catch (IOException e) {
                logger.error((Object)"dbUninstall set table and db error:", (Throwable)e, "");
                throw e;
            }
            InitSQL init = new InitSQL(dbUninstall);
            try {
                init.dropDB(dbInfor);
                init.dropTable(dbInfor);
                init.fixData(dbInfor);
            }
            catch (SQLException e) {
                logger.error((Object)("Drop product db error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new SQLException();
            }
            catch (FileNotFoundException e) {
                logger.error((Object)("bundle's dbfolder  " + productBundles.getId() + "not exists."), "");
                throw new FileNotFoundException();
            }
            catch (IOException e) {
                logger.error((Object)"Drop product db error", (Throwable)e, "");
                throw e;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> getSqlList(String fileName) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(fileName));
            String text = null;
            while ((text = FileUtil.getLineFromFile(reader)) != null) {
                list.add(text);
            }
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)("getSqlList error, file not found: " + new File(fileName).getName()), "");
                throw new FileNotFoundException();
                catch (IOException e2) {
                    logger.error((Object)e2, "getSqlList error");
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                UninstallDBTool.closeReader(reader);
                throw throwable;
            }
        }
        UninstallDBTool.closeReader(reader);
        return list;
    }

    private static void closeReader(BufferedReader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)"BufferedReader close IOException", (Throwable)e, "");
        }
    }

    public static boolean checkDbValid(DataBaseInfo dbInfor) {
        boolean isDbValied = false;
        if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
            isDbValied = UninstallDBTool.connectionGauss(dbInfor);
        }
        return isDbValied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean connectionGauss(DataBaseInfo dbtoInfor) {
        Connection connection = null;
        boolean isValid = false;
        try {
            String host = dbtoInfor.getDbHost();
            int port = Integer.parseInt(dbtoInfor.getDbPort());
            String userText = dbtoInfor.getDbaUsername();
            String password = dbtoInfor.getDbaPassword();
            String url = "jdbc:postgresql://" + host + ":" + port + "/postgres";
            Class.forName("org.postgresql.Driver");
            connection = DriverManager.getConnection(url, userText, password);
            isValid = true;
            if (null == connection) return isValid;
        }
        catch (SQLException e) {
            logger.error((Object)("connectionGauss failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            boolean bl = false;
            return bl;
        }
        catch (ClassNotFoundException e2) {
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (null != connection) {
                UninstallDBTool.closeRes(connection);
            }
        }
        UninstallDBTool.closeRes(connection);
        return isValid;
    }

    private static void closeRes(Connection conn) {
        try {
            conn.close();
        }
        catch (SQLException e) {
            logger.error((Object)("Connection close SQLException" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }
}

