/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.clichangedb.database;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.PasswordCheckUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;

public class DBInfo {
    private static final String MYSQL = "MYSQL";
    private static final String SQLSERVER = "MICROSOFT SQL SERVER";
    private static final String ORACLE = "ORACLE";
    private static final String GAUSS = "GAUSS";
    private static final int WRONGTIMES = 3;
    private static int times = 0;
    private static final Log LOGGER = LogFactory.getInstance(DBInfo.class);

    public static boolean checkCurrentDataBasePwd(String input, DataBaseInfo dbInfor) {
        if (input == null || input.isEmpty()) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.SET.PASSWORD.ERROR"));
            return false;
        }
        if (!PasswordCheckUtil.checkPasswordComplexity4Gauss(input)) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.GAUSSDB.PASSWORD.COMPLEX.CHECK"));
            return false;
        }
        if (!input.equals(dbInfor.getDbaPassword())) {
            if (++times >= 3) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.OLDDB.SET.FAILURE"));
                PrepareParamUtil.exitFail(1);
            }
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.OLDDB.SET.PASSWORD.ERROR"));
            return false;
        }
        return true;
    }

    public static boolean checkDBConnection(DataBaseInfo dbInfo) {
        return DBInfo.getDBUrl(dbInfo).map(url -> DBInfo.testDBConnection(url, dbInfo.getDbaUsername(), dbInfo.getDbaPassword())).orElse(Boolean.FALSE);
    }

    public static boolean checkManagerDBConnection(DataBaseInfo dbInfo) {
        return DBInfo.getDBUrl(dbInfo).map(url -> DBInfo.testDBConnection(url, dbInfo.getManagerUsername(), dbInfo.getManagerPassword())).orElse(Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testDBConnection(String url, String user, String password) {
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.CONNECTION.STATE"));
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, user, password);
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.CONNECTION.SUCCESS"));
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error((Object)(LegoResourceManager.getString("LEGO.DB.CONNECTION.TEST.ERROR.CLI") + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003A");
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)(LegoResourceManager.getString("LEGO.DB.CONNECTION.CLOSE.ERROR.CLI") + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003B");
                }
            }
        }
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.DB.CONNECTION.FAILED"));
        return false;
    }

    public static Optional<String> getDBUrl(DataBaseInfo dbInfo) {
        if (dbInfo == null) {
            return Optional.empty();
        }
        String host = dbInfo.getDbHost();
        int port = Integer.parseInt(dbInfo.getDbPort());
        try {
            switch (dbInfo.getDbType().toUpperCase(Locale.ENGLISH)) {
                case "MYSQL": {
                    Class.forName("com.mysql.jdbc.Driver");
                    return Optional.of("jdbc:mysql://" + host + ":" + port);
                }
                case "MICROSOFT SQL SERVER": {
                    Class.forName("com.microsoft.jdbc.sqlserver.SQLServerDriver");
                    return Optional.of("jdbc:microsoft:sqlserver://" + host + ":" + port);
                }
                case "ORACLE": {
                    Class.forName("oracle.jdbc.driver.OracleDriver");
                    return Optional.of("jdbc:oracle:thin:@" + host + ":" + port + ":lego");
                }
                case "GAUSS": {
                    Class.forName("org.postgresql.Driver");
                    return Optional.of("jdbc:postgresql://" + host + ":" + port + "/postgres");
                }
            }
            LOGGER.warn((Object)"dbInfor is not legal.");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error((Object)(LegoResourceManager.getString("LEGO.DB.CONNECTION.TEST.ERROR.CLI") + ExceptionUtil.getErrorMessage((Throwable)e)), "0x000252000FB5003A");
        }
        return Optional.empty();
    }
}

