/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.climain;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cli.clichangedb.main.CliChangeDB;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.action.InstallPatchAction;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.util.InitPatchZipTool;
import com.huawei.lego.common.patch.util.PatchChecker;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.NetWorkUtil;
import com.huawei.lego.common.util.PortCheckUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CliMain {
    public static final String SOFTWARE_NAME = LegoResourceManager.getProValue("software.install.name");
    private static PatchDto newDto = new PatchDto();
    private static PatchDto oldDto = new PatchDto();
    private static String patchInfoFile = "patchInfoTmp";
    private static final int TWO = 2;
    private static final int NOTOK = -1;
    private static final int OK = 0;
    private static CliMain instance = null;
    private static final Log LOGGER = LogFactory.getInstance(CliMain.class);
    private InstalledSystem system = new InstalledSystem();
    private boolean dbInstalled = false;
    private boolean changeWeb = false;

    public boolean isDbInstalled() {
        return this.dbInstalled;
    }

    public void setDbInstalled(boolean changeDB) {
        this.dbInstalled = changeDB;
    }

    public boolean isChangeWeb() {
        return this.changeWeb;
    }

    public void setChangeWeb(boolean changeWeb) {
        this.changeWeb = changeWeb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CliMain getInstance() {
        Class<CliMain> clazz = CliMain.class;
        synchronized (CliMain.class) {
            if (null == instance) {
                instance = new CliMain();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void main(String[] args) {
        CliMain start = CliMain.getInstance();
        if (null == args || args.length < 1) {
            return;
        }
        if (!args[0].equalsIgnoreCase("clipatch")) {
            CliMain.initSystemInfo();
        } else {
            if (args.length > 1) {
                CliMain.getNewDto(InstallConstant.getsBasePath() + "/patch.xml");
            }
            if (args.length == 2 && args[1].equals("install")) {
                LOGGER.info((Object)"start to install the patch.", "");
                start.installPatch();
                return;
            }
            if (args.length == 2 && args[1].equals("getpatchinfo")) {
                CliMain.checkSystemRunning();
                CliMain.writePatchInfoFile();
            }
        }
        if (args[0].equalsIgnoreCase("clichangedb")) {
            LOGGER.info((Object)"Start to change DB password.", "");
            start.changeDB();
        }
        if (args[0].equalsIgnoreCase("cliquerylogsn")) {
            LOGGER.info((Object)"Start to query log sn.", "");
            start.queryLSN();
        }
        if (args[0].equalsIgnoreCase("revokebcmcert")) {
            LOGGER.info((Object)"Start to revoke bcm cert.", "");
            start.revokeBcmCert(args);
        }
    }

    private static void initSystemInfo() {
        try {
            InitInstalledXmlTool.initSystemInfo();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
            SystemExitUtil.exitFail();
        }
    }

    private static PatchDto getNewDto(String patch) {
        try {
            newDto = InitPatchZipTool.getPatchInforFromZip(new File(patch));
        }
        catch (PatchException e) {
            LOGGER.error((Object)"get new patch info failed.", (Throwable)e, "");
            System.exit(-1);
        }
        return newDto;
    }

    private static void writePatchInfoFile() {
        LOGGER.info((Object)"get history and new patch info.", "");
        try {
            CliMain.writeOldPatchPro();
        }
        catch (PatchException e) {
            LOGGER.error((Object)"get patch info faild.", (Throwable)e, "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.PATCH.INFO.GET.ERR"));
            System.exit(-1);
        }
        catch (IOException e) {
            LOGGER.error((Object)"write  patch file faild.", (Throwable)e, "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.PATCH.INFO.GET.ERR"));
            System.exit(-1);
        }
        System.exit(0);
    }

    private static void checkSystemBeforeStartUp() {
        CliMain.checkSystemRunning();
        if (!CliMain.checkPathChar()) {
            LOGGER.error((Object)LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"), "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.CHAR"));
            PrepareParamUtil.exitFail(0);
        }
        if (NetWorkUtil.getLocalAllIps().isEmpty()) {
            LOGGER.error((Object)LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.NOIP"), "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.PATH.ISNTALL.ERROR.NOIP"));
            PrepareParamUtil.exitFail(0);
        }
    }

    private static void checkSystemRunning() {
        int portNumber = PortCheckUtil.checkSystemUsing();
        if (-1 != portNumber) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("start.err.10001"));
            LOGGER.error((Object)LegoResourceManager.getString("start.err.10001"), "");
            PrepareParamUtil.exitFail(-1);
        }
    }

    private static boolean checkPathChar() {
        String[] folderNameArray;
        String checkPath = CliMain.getAbsPath();
        if (null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            String unRootPath = checkPath.replace("\\", "/");
            unRootPath = unRootPath.substring(checkPath.indexOf(":/") + 2);
            folderNameArray = unRootPath.split("/");
        } else {
            folderNameArray = checkPath.split("/");
        }
        for (String folderName : folderNameArray) {
            boolean flag1;
            if (folderName.length() == 0) continue;
            Pattern pattern = Pattern.compile("^[\\u4e00-\\u9fa5\\w-\\s*.]+$");
            Matcher matcher = pattern.matcher(Normalizer.normalize(folderName, Normalizer.Form.NFKC));
            boolean flag = matcher.matches();
            boolean bl = flag1 = folderName.indexOf("  ") == -1;
            if (flag && flag1) continue;
            return false;
        }
        return true;
    }

    private static String getAbsPath() {
        String jarPathStr = CliMain.class.getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            jarPathStr = URLDecoder.decode(jarPathStr, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            SystemPrint.systemPrintStr("decode error :" + e1.getMessage());
        }
        String basePathStr = "";
        if (-1 != jarPathStr.indexOf(":") && null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            basePathStr = jarPathStr.substring(jarPathStr.indexOf("/") + 1, jarPathStr.lastIndexOf("/"));
            basePathStr = basePathStr.substring(0, basePathStr.lastIndexOf("/") + 1);
        } else {
            basePathStr = jarPathStr.substring(jarPathStr.indexOf("/"), jarPathStr.lastIndexOf("/"));
            basePathStr = basePathStr.substring(0, basePathStr.lastIndexOf("/") + 1);
        }
        return basePathStr;
    }

    public InstalledSystem getSystem() {
        return this.system;
    }

    public void setSystem(InstalledSystem system) {
        this.system = system;
    }

    private void changeDB() {
        this.setDbInstalled(true);
        this.setSystem(InitInstalledXmlTool.getInstalledSystem());
        CliMain.checkSystemBeforeStartUp();
        CliChangeDB.getInstance().startChangeDataBaseInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryLSN() {
        DataBaseInfo dataBase = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        String dbUserName = dataBase.getDbaUsername();
        String dbPwd = dataBase.getDbaPassword();
        dataBase.setDbaUsername(dataBase.getManagerUsername());
        dataBase.setDbaPassword(dataBase.getManagerPassword());
        Connection connect = LegoDBConnection.getInstance().connectGaussDB(dataBase, "LEGO");
        dataBase.setDbaUsername(dbUserName);
        dataBase.setDbaPassword(dbPwd);
        PreparedStatement statement = InitSQL.executeSQLQuery(connect, "select pg_last_xlog_receive_location();");
        ResultSet rs = null;
        try {
            rs = statement.executeQuery();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
        }
        catch (SQLException ex) {
            System.out.println("Query log sn failed.");
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    statement.close();
                }
                connect.close();
            }
            catch (SQLException e) {
                System.out.println("close error: " + ExceptionUtil.getErrorMessage((Throwable)e));
            }
        }
    }

    private void revokeBcmCert(String[] args) {
        if (null == args || args.length < 3) {
            SystemPrint.systemPrintStr("param is wrong.");
            return;
        }
        try {
            String bcmKeyStorePath = InitInstalledXmlTool.getInstallPath() + "Runtime/LegoRuntime/certs/bcm.keystore";
            Map<String, String> envMap = System.getenv();
            String iRet = envMap.get("ENV_CERT_PWD");
            KeyStore bcmKeyStore = CertificateUtil.loadKeyStore(bcmKeyStorePath, "JKS", iRet);
            HashMap bcmCertificateMap = new HashMap();
            Enumeration<String> aliases = bcmKeyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                X509Certificate x509Certificate = (X509Certificate)bcmKeyStore.getCertificate(alias);
                String serialNumber = x509Certificate.getSerialNumber().toString(16).toUpperCase();
                CommUtil.addSetToMap(bcmCertificateMap, (Object)serialNumber, (Object)alias);
            }
            String revokedCertsSnStr = args[2];
            String[] revokedCertsSn = revokedCertsSnStr.split(",");
            boolean hasDelete = false;
            for (String revokedCertSn : revokedCertsSn) {
                Set aliasSet = (Set)bcmCertificateMap.get(revokedCertSn = revokedCertSn.toUpperCase());
                if (VerifyUtil.isEmpty((Collection)aliasSet)) continue;
                for (String alias : aliasSet) {
                    bcmKeyStore.deleteEntry(alias);
                    SystemPrint.systemPrintStr(String.format("delete cert sn:%s alias:%s", revokedCertSn, alias));
                    hasDelete = true;
                }
            }
            if (hasDelete) {
                CertificateUtil.saveKeyStore(bcmKeyStore, bcmKeyStorePath, iRet);
            } else {
                SystemPrint.systemPrintStr("There is no cert need to revoke.");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"revokeBcmCert failed. ", (Throwable)e, "");
            String errorMessage = e.getMessage();
            SystemPrint.systemPrintStr(errorMessage);
        }
    }

    private void installPatch() {
        try {
            CliMain.parsePatchPkg();
            InstallPatchAction.doAction(true);
        }
        catch (IOException e) {
            LOGGER.error((Object)"parse patch package failed. ", (Throwable)e, "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("patch.err.20016"));
            System.exit(-1);
        }
        catch (PatchException e) {
            LOGGER.error((Object)"parse patch package failed. ", (Throwable)e, "");
            String errorMessage = e.getErrorMsg();
            SystemPrint.systemPrintStr(errorMessage);
            System.exit(-1);
        }
        SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.PATCH.INSTALL.SUCCESS", SOFTWARE_NAME));
        System.exit(0);
    }

    private static void writeOldPatchPro() throws IOException, PatchException {
        File oldF;
        String oldXml = InitPatchZipTool.getRuntimePath() + "Runtime" + File.separator + "patch" + File.separator + "package" + File.separator + "patch.xml";
        File patchFile = new File(patchInfoFile);
        if (patchFile.exists()) {
            patchFile.delete();
        }
        StringBuilder builder = new StringBuilder();
        String version = InitPatchZipTool.getSystemVersion();
        if (!version.equals("")) {
            builder.append(InitPatchZipTool.getSystemVersion()).append("\t").append(LegoResourceManager.getString("LEGO.PATCH.SELECT.ACTIVE")).append("\n");
        }
        if ((oldF = new File(oldXml)).exists()) {
            oldDto = InitPatchZipTool.getPatchInfoFromXml(oldXml);
            builder.append(oldDto.getPatchVersion()).append("\t").append(LegoResourceManager.getString("LEGO.PATCH.SELECT.ACTIVE")).append("\n");
        }
        String newVersion = newDto.getPatchVersion();
        builder.append(newVersion).append("\t").append(LegoResourceManager.getString("LEGO.PATCH.SELECT.INACTIVE"));
        FileWriter writer = null;
        try {
            writer = new FileWriter(patchFile);
            writer.write(builder.toString());
            writer.flush();
        }
        catch (IOException e) {
            LOGGER.error((Object)"FileWriter IOException.", "");
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close FileWriter failed.", "");
                }
            }
        }
    }

    private static void parsePatchPkg() throws IOException {
        PatchChecker.isLegal(newDto);
    }

    public static PatchDto getDto() {
        return newDto;
    }
}

