/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.initcloud;

import com.huawei.lego.common.util.IPv4Util;
import com.huawei.lego.common.util.NetWorkUtil;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.PortCheckUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class CheckUtil {
    private static final Log LOGGER = LogFactory.getInstance(CheckUtil.class);
    private static final List<String> EXCEPTIONIP = new ArrayList<String>(Arrays.asList("255.255.255.255", "127.0.0.1", "0.0.0.0"));

    public static boolean checkFloatIp(String selectIp, String floatIp) {
        if (VerifyUtil.isEmpty((String)floatIp) || VerifyUtil.isEmpty((String)selectIp)) {
            LOGGER.error((Object)("checkFloatIp failed, floatIp=" + floatIp + ", selectIp: " + selectIp), "");
            return false;
        }
        if (!CheckUtil.checkIp(floatIp, false)) {
            LOGGER.error((Object)("checkFloatIp failed, is not illegal, floatIp=" + floatIp), "");
            return false;
        }
        Map<String, Short> ipMap = NetWorkUtil.getLocalAllIpAndMask();
        String mask = ipMap.get(selectIp).toString();
        if (ipMap.get(selectIp) < 0 || ipMap.get(selectIp) > 32) {
            LOGGER.error((Object)("checkNetMask failed, localIp: " + selectIp), "");
            return false;
        }
        if (!IPv4Util.getIPSegment(selectIp, mask).equals(IPv4Util.getIPSegment(floatIp, mask))) {
            LOGGER.error((Object)("is not in same net, FloatIp: " + floatIp), "");
            return false;
        }
        return true;
    }

    public static boolean checkPort(String port, boolean isLocalPort) {
        if (VerifyUtil.isEmpty((String)port)) {
            LOGGER.error((Object)"checkPort failed, port is null.", "");
            return false;
        }
        if (!port.matches("\\d{4,5}") || Integer.parseInt(port) < 1024 || Integer.parseInt(port) > 65535) {
            LOGGER.error((Object)("checkPort failed, port: " + port), "");
            return false;
        }
        if (isLocalPort && PortCheckUtil.checkPortUsed(port)) {
            LOGGER.error((Object)("checkPort failed, + " + port + " is occupid"), "");
            return false;
        }
        return true;
    }

    public static boolean checkIp(String ip, boolean isLocalIp) {
        if (!ParamCheck.checkIpAddress(ip) || EXCEPTIONIP.contains(ip)) {
            LOGGER.error((Object)("checkIp failed, ip: " + ip), "");
            return false;
        }
        List<String> allIps = NetWorkUtil.getLocalAllIps();
        if (isLocalIp && !allIps.contains(ip)) {
            LOGGER.error((Object)("local ip is not exists, ip: " + ip), "");
            return false;
        }
        if (!isLocalIp && allIps.contains(ip)) {
            LOGGER.error((Object)("check not local ip, but the ip is found in local: " + ip), "");
            return false;
        }
        return true;
    }
}

