/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.initcloud;

import com.huawei.lego.common.ha.HaLinkNode;
import java.util.ArrayList;
import java.util.List;

public class HAInfoModel {
    public static final String ACTIVE = "active";
    public static final String STANDBY = "standby";
    private String localRole;
    private String localName;
    private String remoteName;
    private List<HaLinkNode> syncList = new ArrayList<HaLinkNode>();
    private List<HaLinkNode> heartList = new ArrayList<HaLinkNode>();

    public String getLocalRole() {
        return this.localRole;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public void setLocalRole(String localRole) {
        this.localRole = localRole;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public void setRemoteName(String remoteName) {
        this.remoteName = remoteName;
    }

    public List<HaLinkNode> getSyncList() {
        return this.syncList;
    }

    public List<HaLinkNode> getHeartList() {
        return this.heartList;
    }

    public void setSyncList(List<HaLinkNode> syncList) {
        this.syncList = syncList;
    }

    public void setHeartList(List<HaLinkNode> heartList) {
        this.heartList = heartList;
    }

    public String getCmdLine() {
        StringBuffer cmdBuff = new StringBuffer();
        cmdBuff.append(" -m double ");
        cmdBuff.append(" -j " + this.getLocalRole());
        cmdBuff.append(" -l " + this.getLocalName());
        cmdBuff.append(" -p " + this.getRemoteName());
        cmdBuff.append(" -b ");
        StringBuffer heartBuf = new StringBuffer();
        heartBuf.append("\"");
        for (HaLinkNode heartLink : this.getHeartList()) {
            heartBuf.append(this.getLocalName());
            heartBuf.append(":");
            heartBuf.append(heartLink.getLocalIp());
            heartBuf.append(":");
            heartBuf.append(heartLink.getLocalPort());
            heartBuf.append(",");
            heartBuf.append(this.getRemoteName());
            heartBuf.append(":");
            heartBuf.append(heartLink.getPeerIp());
            heartBuf.append(":");
            heartBuf.append(heartLink.getPeerPort());
            heartBuf.append(";");
        }
        String heartStr = heartBuf.toString();
        cmdBuff.append(heartStr.substring(0, heartStr.lastIndexOf(";")) + "\"");
        cmdBuff.append(" -s ");
        StringBuffer syncBuf = new StringBuffer();
        syncBuf.append("\"");
        for (HaLinkNode syncLink : this.getSyncList()) {
            syncBuf.append(this.getLocalName());
            syncBuf.append(":");
            syncBuf.append(syncLink.getLocalIp());
            syncBuf.append(":");
            syncBuf.append(syncLink.getLocalPort());
            syncBuf.append(",");
            syncBuf.append(this.getRemoteName());
            syncBuf.append(":");
            syncBuf.append(syncLink.getPeerIp());
            syncBuf.append(":");
            syncBuf.append(syncLink.getPeerPort());
            syncBuf.append(";");
        }
        String syncStr = syncBuf.toString();
        cmdBuff.append(syncStr.substring(0, syncStr.lastIndexOf(";")) + "\"");
        return cmdBuff.toString();
    }
}

