/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.initcloud;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cli.initcloud.CheckUtil;
import com.huawei.lego.cli.initcloud.CloudConfig;
import com.huawei.lego.cli.initcloud.HAInfoModel;
import com.huawei.lego.common.changeport.ProcessFile;
import com.huawei.lego.common.changeweb.ChangeWebAction;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.ha.HaLinkNode;
import com.huawei.lego.common.install.NetWorkPanel;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InitCloudConfig {
    private static final String CLOUDCONFIG = "TI_CLOUDCONFIG";
    private static final Properties PROPERTIES = new Properties();
    private static final NetWorkPanel NETWORK = new NetWorkPanel();
    private static final HAInfoModel HAINFO = new HAInfoModel();
    private static final List<String> PORTLIST = new ArrayList<String>();
    private static final int EXIT_SUCC = 0;
    private static final int EXIT_FAIL = 1;
    private static final Log LOGGER = LogFactory.getInstance(InitCloudConfig.class);
    private static final boolean MODULE_ENABLE = true;
    private static final boolean MODULE_DISABLE = false;
    private static boolean G_HA_MODULE_CONFIG = false;
    private static boolean G_OC_MODULE_CONFIG = false;
    private static boolean G_BCM_MODULE_CONFIG = false;
    private static final int MODE_NULL = 0;
    private static final int MODE_HA = 1;
    private static final int MODE_ACTIVE_STANDBY = 2;
    private static int G_EREPLICATION_MODE = 0;

    public static void main(String[] args) {
        try {
            InitCloudConfig.checkParam(args);
            InitCloudConfig.initUserConfig(args[0]);
            InitCloudConfig.saveAndCheckConfigObject();
            InitCloudConfig.configUsersConfiguration();
            InitCloudConfig.updateCloudConfig();
        }
        catch (Exception e) {
            LOGGER.error((Object)("init cloud config failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            System.exit(1);
        }
        System.exit(0);
    }

    private static void checkParam(String[] args) {
        if (args.length != 1) {
            throw new LegoCheckedException("args.length is error.");
        }
        File file = new File(args[0]);
        if (!file.exists()) {
            throw new LegoCheckedException("the file is not exists.");
        }
    }

    private static void seteReplicationMode() {
        String streReplicationMode = PROPERTIES.getProperty("SYS.MODE");
        if (VerifyUtil.isEmpty((String)streReplicationMode)) {
            LOGGER.error((Object)"Init_Cloud config mode is NULL!", "");
            System.exit(1);
        }
        if (streReplicationMode.equals("HA")) {
            LOGGER.info((Object)"Init_Cloud config HA.", "");
            G_EREPLICATION_MODE = 1;
        } else if (streReplicationMode.equals("Active-Standby")) {
            LOGGER.info((Object)"Init_Cloud config Active-Standby.", "");
            G_EREPLICATION_MODE = 2;
        } else {
            LOGGER.error((Object)("Not recognise config mode(" + streReplicationMode + ")"), "");
            System.exit(1);
        }
    }

    private static void setHAModuleChoice() {
        String strSysIP = PROPERTIES.getProperty("SYS.IP");
        String strSysPort = PROPERTIES.getProperty("SYS.Port");
        String strSysFloatIP = PROPERTIES.getProperty("SYS.FloatIP");
        String strHARole = PROPERTIES.getProperty("HA.localRole");
        String strHALocalName = PROPERTIES.getProperty("HA.localName");
        String strHARemoteName = PROPERTIES.getProperty("HA.remoteName");
        String strHALocalHeart = PROPERTIES.getProperty("HA.heartbeat.local");
        String strHARemoteHeart = PROPERTIES.getProperty("HA.heartbeat.remote");
        String strHALocalSync = PROPERTIES.getProperty("HA.syncfile.local");
        String strHARemoteSync = PROPERTIES.getProperty("HA.syncfile.remote");
        if (VerifyUtil.isEmpty((String)strSysIP) && VerifyUtil.isEmpty((String)strSysPort) && VerifyUtil.isEmpty((String)strSysFloatIP) && VerifyUtil.isEmpty((String)strHARole) && VerifyUtil.isEmpty((String)strHALocalName) && VerifyUtil.isEmpty((String)strHARemoteName) && VerifyUtil.isEmpty((String)strHALocalHeart) && VerifyUtil.isEmpty((String)strHARemoteHeart) && VerifyUtil.isEmpty((String)strHALocalSync) && VerifyUtil.isEmpty((String)strHARemoteSync)) {
            LOGGER.info((Object)"Init_Cloud not config HA.", "");
            G_HA_MODULE_CONFIG = false;
        } else {
            LOGGER.info((Object)"Init_Cloud config HA.", "");
            G_HA_MODULE_CONFIG = true;
        }
    }

    private static void setOCModuleChoice() {
        String strOcUser = PROPERTIES.getProperty("OC.username");
        String strOcPwd = PROPERTIES.getProperty("OC.password");
        String strOcPort = PROPERTIES.getProperty("OC.port");
        String strOcDomain = PROPERTIES.getProperty("OC.domain");
        String strOcVersion = PROPERTIES.getProperty("OC.version");
        if (VerifyUtil.isEmpty((String)strOcUser) && VerifyUtil.isEmpty((String)strOcPwd) && VerifyUtil.isEmpty((String)strOcPort) && VerifyUtil.isEmpty((String)strOcDomain) && VerifyUtil.isEmpty((String)strOcVersion)) {
            LOGGER.info((Object)"Init_Cloud not config OC.", "");
            G_OC_MODULE_CONFIG = false;
        } else {
            LOGGER.info((Object)"Init_Cloud config OC.", "");
            G_OC_MODULE_CONFIG = true;
        }
    }

    private static void setBCMModuleChoice() {
        String strBCMDomain = PROPERTIES.getProperty("BCM.domain");
        String strBCMFailoverMode = PROPERTIES.getProperty("BCM.system_autorecovery");
        if (VerifyUtil.isEmpty((String)strBCMDomain) && VerifyUtil.isEmpty((String)strBCMFailoverMode)) {
            LOGGER.info((Object)"Init_Cloud not config BCM.", "");
            G_BCM_MODULE_CONFIG = false;
        } else {
            LOGGER.info((Object)"Init_Cloud config BCM.", "");
            G_BCM_MODULE_CONFIG = true;
        }
    }

    private static boolean isModuleEnabled(String strModule) {
        if (strModule.equals("HA")) {
            return G_HA_MODULE_CONFIG;
        }
        if (strModule.equals("OC")) {
            return G_OC_MODULE_CONFIG;
        }
        if (strModule.equals("BCM")) {
            return G_BCM_MODULE_CONFIG;
        }
        return false;
    }

    private static CloudConfig getCloudConfigData() {
        CloudConfig cloudConfig = new CloudConfig();
        if (InitCloudConfig.isModuleEnabled("OC")) {
            String ocUser = PROPERTIES.getProperty("OC.username");
            String ocPwd = PROPERTIES.getProperty("OC.password");
            String ocPort = PROPERTIES.getProperty("OC.port");
            String ocDomain = PROPERTIES.getProperty("OC.domain");
            String ocVersion = PROPERTIES.getProperty("OC.version");
            if (VerifyUtil.isEmpty((String)ocUser) || VerifyUtil.isEmpty((String)ocPwd) || VerifyUtil.isEmpty((String)ocPort) || VerifyUtil.isEmpty((String)ocDomain) || VerifyUtil.isEmpty((String)ocVersion)) {
                throw new LegoCheckedException("config value is null.");
            }
            if (!CheckUtil.checkPort(ocPort, false)) {
                throw new LegoCheckedException("oc port is error.");
            }
            cloudConfig.setOcUser(ocUser);
            cloudConfig.setOcPort(ocPort);
            cloudConfig.setOcPwd(WccEncryptor.encode(ocPwd));
            cloudConfig.setOcDomain(ocDomain);
            cloudConfig.setOcVersion(ocVersion);
        }
        if (InitCloudConfig.isModuleEnabled("BCM")) {
            String bussDomain = PROPERTIES.getProperty("BCM.domain");
            if (VerifyUtil.isEmpty((String)bussDomain)) {
                throw new LegoCheckedException("config value is null.");
            }
            cloudConfig.setBusinessDomain(bussDomain);
        }
        return cloudConfig;
    }

    private static boolean isTableExists(Connection connect, String tableName) {
        boolean isExists = false;
        String querySql = "select * from pg_tables where TABLENAME=?;";
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connect.prepareStatement(querySql);
            preparedStatement.setString(1, tableName.toUpperCase(Locale.ENGLISH));
            ResultSet rs = preparedStatement.executeQuery();
            if (null != rs) {
                while (rs.next()) {
                    isExists = true;
                }
            } else {
                LOGGER.error((Object)"ResultSet is null.", "");
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("check isTableExists failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("check isTableExists failed.");
        }
        finally {
            InitCloudConfig.closePreparedStatement(preparedStatement);
        }
        return isExists;
    }

    private static void closePreparedStatement(PreparedStatement st) {
        try {
            if (st != null) {
                st.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error((Object)("close error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    private static void createTable(Connection connect) {
        ArrayList<String> sqlList = new ArrayList<String>();
        LOGGER.info((Object)"table cloudconfig not exits, create it.", "");
        String createSql1 = "CREATE TABLE TI_CLOUDCONFIG (CONFIGTYPE CHARACTER VARYING(255) NOT NULL);CREATE TABLE IF NOT EXISTS TI_CLOUDCONFIG_PROPS (CONFIGTYPE CHARACTER VARYING(255) NOT NULL,PROPVALUE CHARACTER VARYING(1024),PROPNAME CHARACTER VARYING(255) NOT NULL);ALTER TABLE ONLY TI_CLOUDCONFIG ADD CONSTRAINT TI_CLOUDCONFIG_PKEY PRIMARY KEY (CONFIGTYPE);ALTER TABLE ONLY TI_CLOUDCONFIG_PROPS ADD CONSTRAINT TI_CLOUDCONFIG_PROPS_PKEY PRIMARY KEY (CONFIGTYPE, PROPNAME);ALTER TABLE ONLY TI_CLOUDCONFIG_PROPS ADD CONSTRAINT FK196C119E6CD038A5 FOREIGN KEY (CONFIGTYPE) REFERENCES TI_CLOUDCONFIG(CONFIGTYPE);";
        sqlList.add(createSql1);
        InitSQL.executeSQL(connect, sqlList);
    }

    private static void updateCloudConfig() {
        LOGGER.info((Object)"Start update OC and BCM config.", "");
        InitCloudConfig.updateOCConfig();
        InitCloudConfig.updateBCMConfig();
    }

    private static void updateOCConfig() {
        if (!InitCloudConfig.isModuleEnabled("OC")) {
            LOGGER.info((Object)"OC not configed, return normal.", "");
            return;
        }
        LOGGER.info((Object)"Start update OC config.", "");
        CloudConfig cloudConfig = InitCloudConfig.getCloudConfigData();
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        Connection connect = LegoDBConnection.getInstance().connectGaussDB(dbInfo, "LEGO");
        ArrayList<String> ocPropsList = new ArrayList<String>();
        String configIDSql = "";
        String ocPropsSql = "";
        String deleteConfigId = "";
        String ocPropsDelete = "";
        deleteConfigId = "delete from ti_cloudconfig where CONFIGTYPE='oc';";
        ocPropsDelete = "delete from ti_cloudconfig_props where CONFIGTYPE='oc';";
        configIDSql = "insert into ti_cloudconfig (CONFIGTYPE) values ('oc');";
        ocPropsList.add(cloudConfig.getOcUser());
        ocPropsList.add(cloudConfig.getOcPwd());
        ocPropsList.add(cloudConfig.getOcPort());
        ocPropsList.add(cloudConfig.getOcDomain());
        ocPropsList.add(cloudConfig.getOcVersion());
        ocPropsSql = "insert into ti_cloudconfig_props (CONFIGTYPE,PROPNAME,PROPVALUE) values ('oc','oc_username',?),('oc','oc_password',?),('oc','oc_port',?),('oc','oc_domain',?),('oc','oc_version',?);";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(ocPropsDelete);
        sqlList.add(deleteConfigId);
        sqlList.add(configIDSql);
        try {
            if (!InitCloudConfig.isTableExists(connect, CLOUDCONFIG)) {
                InitCloudConfig.createTable(connect);
            }
            InitSQL.executeSQL(connect, sqlList);
            InitSQL.executeSQL(connect, ocPropsSql, ocPropsList);
            LOGGER.info((Object)"end update OC config.", "");
        }
        catch (Exception e) {
            LOGGER.error((Object)("config OC failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("config OC failed.");
        }
        finally {
            if (null != connect) {
                try {
                    connect.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("close error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
    }

    private static void updateBCMConfig() {
        if (!InitCloudConfig.isModuleEnabled("BCM")) {
            LOGGER.info((Object)"BCM not configed, return normal.", "");
            return;
        }
        LOGGER.info((Object)"Start update BCM config.", "");
        CloudConfig cloudConfig = InitCloudConfig.getCloudConfigData();
        DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
        Connection connect = LegoDBConnection.getInstance().connectGaussDB(dbInfo, "LEGO");
        ArrayList<String> bcmData = new ArrayList<String>();
        String configIDSql = "";
        String bcmUpdateSql = "";
        String deleteConfigId = "";
        String bcmPropsDelete = "";
        LOGGER.info((Object)"Start update BCM config.", "");
        deleteConfigId = "delete from ti_cloudconfig where CONFIGTYPE!='oc' and CONFIGTYPE!='system';";
        bcmPropsDelete = "delete from ti_cloudconfig_props where CONFIGTYPE!='oc' and CONFIGTYPE!='system';";
        configIDSql = "insert into ti_cloudconfig (CONFIGTYPE) values ('domain');";
        bcmData.add(cloudConfig.getBusinessDomain());
        bcmUpdateSql = "insert into ti_cloudconfig_props (CONFIGTYPE,PROPNAME,PROPVALUE) values ('domain','domain_bussiness',?);";
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(bcmPropsDelete);
        sqlList.add(deleteConfigId);
        sqlList.add(configIDSql);
        try {
            if (!InitCloudConfig.isTableExists(connect, CLOUDCONFIG)) {
                InitCloudConfig.createTable(connect);
            }
            InitSQL.executeSQL(connect, sqlList);
            InitSQL.executeSQL(connect, bcmUpdateSql, bcmData);
            LOGGER.info((Object)"end update BCM config.", "");
        }
        catch (Exception e) {
            LOGGER.error((Object)("config BCM failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("config BCM failed.");
        }
        finally {
            if (null != connect) {
                try {
                    connect.close();
                }
                catch (SQLException e) {
                    LOGGER.error((Object)("close error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                }
            }
        }
    }

    private static void configUsersConfiguration() {
        if (!InitCloudConfig.isModuleEnabled("HA")) {
            LOGGER.info((Object)"Init_Cloud not config HA, update HA config file return normal.", "");
            return;
        }
        try {
            String runtimePath = new File("../").getCanonicalPath();
            String haConfigScript = runtimePath + "/ha/module/hacom/script/config_ha.sh";
            if (!new File(haConfigScript).exists()) {
                throw new LegoCheckedException("ha config script not found");
            }
            StringBuffer cmdBuf = new StringBuffer();
            cmdBuf.append(HAINFO.getCmdLine());
            cmdBuf.append(" -i ");
            cmdBuf.append(NETWORK.getWorkMangFloatIp());
            LOGGER.info((Object)("haInfo: " + cmdBuf.toString()), "");
            if (!CmdUtil.execShellCmd("/bin/sh", new String[]{haConfigScript, cmdBuf.toString()})) {
                throw new LegoCheckedException("run ha config script faild.");
            }
            String portIni = runtimePath + "/bin/config/conf/port.ini";
            HashMap<String, String> changedPort = new HashMap<String, String>();
            changedPort.put("https.port", NETWORK.getWorkMangHttpsPort());
            ProcessFile.updatePortConfFile(changedPort, portIni);
            ChangeWebAction.updateInstallXML(NETWORK);
        }
        catch (Exception e) {
            LOGGER.error((Object)("configUsersConfiguration failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new LegoCheckedException("configUsersConfiguration failed.");
        }
    }

    private static void saveNetworkConfig() {
        LOGGER.info((Object)"start saveNetworkConfig.", "");
        String sManagerIp = PROPERTIES.getProperty("SYS.IP");
        String sManagerPort = PROPERTIES.getProperty("SYS.Port");
        String sManagerFloatIp = PROPERTIES.getProperty("SYS.FloatIP");
        if (!CheckUtil.checkIp(sManagerIp, true)) {
            LOGGER.error((Object)("saveNetworkConfig failed, sManager ip is: " + sManagerIp), "");
            throw new LegoCheckedException("saveNetworkConfig failed.");
        }
        if (!CheckUtil.checkFloatIp(sManagerIp, sManagerFloatIp)) {
            LOGGER.error((Object)("saveNetworkConfig failed, sManager Float Ip: " + sManagerFloatIp), "");
            throw new LegoCheckedException("saveNetworkConfig failed.");
        }
        if (!CheckUtil.checkPort(sManagerPort, true)) {
            LOGGER.error((Object)("saveNetworkConfig failed, SManager port is error: " + sManagerPort), "");
            throw new LegoCheckedException("saveNetworkConfig failed.");
        }
        PORTLIST.add(sManagerPort);
        NETWORK.setWorkMangIp(sManagerIp);
        NETWORK.setWorkMangHttpsPort(sManagerPort);
        NETWORK.setWorkMangFloatIp(sManagerFloatIp);
        LOGGER.info((Object)("end saveNetworkConfig, network: " + NETWORK), "");
    }

    private static void setLocalRole() {
        String localRole = PROPERTIES.getProperty("HA.localRole");
        if (VerifyUtil.isEmpty((String)localRole)) {
            throw new LegoCheckedException("localRole is null.");
        }
        if (!"active".equals(localRole) && !"standby".equals(localRole)) {
            throw new LegoCheckedException("localRole is error: " + localRole);
        }
        HAINFO.setLocalRole(localRole);
    }

    private static void setNodeName() {
        String localName = PROPERTIES.getProperty("HA.localName");
        String remoteName = PROPERTIES.getProperty("HA.remoteName");
        if (VerifyUtil.isEmpty((String)localName) || VerifyUtil.isEmpty((String)remoteName)) {
            throw new LegoCheckedException("local name or remote name is null.");
        }
        if (localName.equals(remoteName)) {
            throw new LegoCheckedException("local name is the same as remote name.");
        }
        Pattern pattern = Pattern.compile("^[a-zA-Z0-9_-]{1,39}");
        Matcher matcher = pattern.matcher(Normalizer.normalize(localName, Normalizer.Form.NFKC));
        Matcher matcher2 = pattern.matcher(Normalizer.normalize(remoteName, Normalizer.Form.NFKC));
        if (!matcher.matches() || !matcher2.matches()) {
            LOGGER.error((Object)("node name error, local: " + localName + ", remoteName: " + remoteName), "");
            throw new LegoCheckedException("node name is illegal");
        }
        HAINFO.setLocalName(localName);
        HAINFO.setRemoteName(remoteName);
    }

    private static void setLinkInfo(List<HaLinkNode> linkInfo, String localInfo, String remoteInfo) {
        HaLinkNode linkNode = new HaLinkNode();
        LOGGER.info((Object)("localINfo: " + localInfo + " , remoteInfo: " + remoteInfo), "");
        if (VerifyUtil.isEmpty((String)localInfo) || VerifyUtil.isEmpty((String)remoteInfo)) {
            LOGGER.error((Object)"localInfo or remoteInfo is null.", "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        String[] local = localInfo.split(":");
        String[] remote = remoteInfo.split(":");
        if (local.length != 2 || remote.length != 2) {
            LOGGER.error((Object)"localInfo or remoteInfo format is error.", "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        if (!CheckUtil.checkIp(local[0], true)) {
            LOGGER.error((Object)("check local ip failed, ip: " + local[0]), "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        if (!CheckUtil.checkPort(local[1], true)) {
            LOGGER.error((Object)("check local port failed, port: " + local[1]), "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        if (!CheckUtil.checkIp(remote[0], false)) {
            LOGGER.error((Object)("check remote ip failed, ip: " + remote[0]), "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        if (!CheckUtil.checkPort(remote[1], false)) {
            LOGGER.error((Object)("check remote port failed, port: " + remote[1]), "");
            throw new LegoCheckedException("setHeartInfo failed");
        }
        linkNode.setLocalIp(local[0]);
        linkNode.setLocalPort(local[1]);
        linkNode.setPeerIp(remote[0]);
        linkNode.setPeerPort(remote[1]);
        linkInfo.add(linkNode);
    }

    private static void setLinkInfo() {
        ArrayList<HaLinkNode> syncList = new ArrayList<HaLinkNode>();
        ArrayList<HaLinkNode> heartList = new ArrayList<HaLinkNode>();
        for (Map.Entry<Object, Object> entryMap : PROPERTIES.entrySet()) {
            String linkNumber;
            String key = (String)entryMap.getKey();
            String value = (String)entryMap.getValue();
            if (!key.startsWith("HA.heartbeat.") && !key.startsWith("HA.syncfile.")) continue;
            if (key.startsWith("HA.heartbeat.local")) {
                if (key.length() != "HA.heartbeat.local".length() + 1) {
                    throw new LegoCheckedException("heart key is error, key: " + key);
                }
                linkNumber = key.substring(key.length() - 1);
                String heartRemote = PROPERTIES.getProperty("HA.heartbeat.remote" + linkNumber);
                InitCloudConfig.setLinkInfo(heartList, value, heartRemote);
            }
            if (!key.startsWith("HA.syncfile.local")) continue;
            if (key.length() != "HA.syncfile.local".length() + 1) {
                throw new LegoCheckedException("sync key is error, key: " + key);
            }
            linkNumber = key.substring(key.length() - 1);
            String syncRemote = PROPERTIES.getProperty("HA.syncfile.remote" + linkNumber);
            InitCloudConfig.setLinkInfo(syncList, value, syncRemote);
        }
        HAINFO.setHeartList(heartList);
        HAINFO.setSyncList(syncList);
    }

    private static void saveHAConfig() {
        LOGGER.info((Object)"start saveHAConfig.", "");
        InitCloudConfig.setLocalRole();
        InitCloudConfig.setNodeName();
        InitCloudConfig.setLinkInfo();
        LOGGER.info((Object)"end saveHAConfig.", "");
    }

    private static void saveAndCheckConfigObject() {
        if (!InitCloudConfig.isModuleEnabled("HA")) {
            LOGGER.info((Object)"Init_Cloud not config HA, now return to check other configuration.", "");
            return;
        }
        InitCloudConfig.saveNetworkConfig();
        InitCloudConfig.saveHAConfig();
    }

    private static void initUserConfig(String configFile) {
        File file = new File(configFile);
        if (!file.exists()) {
            LOGGER.error((Object)"initUserConfig failed, cloud config file not found.", "");
            throw new LegoCheckedException("initUserConfig failed");
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            PROPERTIES.load(input);
        }
        catch (Exception e) {
            LOGGER.error((Object)("initUserConfig failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new LegoCheckedException("initUserConfig failed");
        }
        InitCloudConfig.seteReplicationMode();
        if (G_EREPLICATION_MODE == 2) {
            G_HA_MODULE_CONFIG = false;
            G_BCM_MODULE_CONFIG = false;
            InitCloudConfig.setOCModuleChoice();
            return;
        }
        InitCloudConfig.setHAModuleChoice();
        InitCloudConfig.setOCModuleChoice();
        InitCloudConfig.setBCMModuleChoice();
    }
}

