/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.nginx;

import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

class CliFillKeypass {
    private static final Log logger = LogFactory.getInstance(CliFillKeypass.class);
    private static final String INSTALL_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final String LEGO_PROPERTIES = INSTALL_PATH + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "lego.properties";
    private static final String KEYPASS_KEY = "nginx.keypass";
    private static final Path KEYPASS_FILE = Paths.get(INSTALL_PATH, "Runtime", "nginx", "conf", "keypass");
    private static final long WRITE_INTERVAL = 500L;

    CliFillKeypass() {
    }

    public static void main(String[] args) {
        int times = 1;
        if (!VerifyUtil.isEmpty((Object[])args)) {
            try {
                times = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException e) {
                logger.error((Object)"Param is invalid.", (Throwable)e);
                System.exit(1);
            }
        }
        String keypass = null;
        try {
            keypass = CertificateUtil.getPasswordFromConfig(LEGO_PROPERTIES, KEYPASS_KEY);
        }
        catch (IOException e) {
            logger.error((Object)"Get keypass from lego.properties failed.", (Throwable)e);
        }
        if (VerifyUtil.isEmpty((String)keypass)) {
            logger.error((Object)"Get or decrypt keypass failed.");
            System.exit(1);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(KEYPASS_FILE, StandardCharsets.UTF_8, new OpenOption[0]);){
            for (int i = 0; i < times; ++i) {
                writer.write(keypass);
                writer.newLine();
                writer.flush();
                logger.info((Object)("Write keypass " + (i + 1) + " times."));
                Thread.sleep(500L);
            }
        }
        catch (IOException | InterruptedException e) {
            logger.error((Object)"Write keypass failed.", (Throwable)e);
            System.exit(1);
        }
    }
}

