/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.patch.rollback;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.common.constant.PatchDefine;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.patch.model.PatchDto;
import com.huawei.lego.common.patch.model.PatchFile;
import com.huawei.lego.common.patch.util.InitPatchZipTool;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.common.util.SysConfigDataUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PatchRollBack {
    private static final Log LOGGER = LogFactory.getInstance(PatchRollBack.class);
    private static String patchTmpPath = "";
    private static String installPath = "";
    private static String dataFilePath = "";
    private static String patchXml = "";
    private static String configData = "";
    private static String currentConfigData = "";
    private static String patchFile = "";
    private static String oldBackPath = "";
    private static String importTmpFile = "";
    private static String backupConfig = "";
    private static String currentConfig = "";
    private static boolean isRollbackPatch = false;
    private static boolean isRollbackData = false;

    public static void main(String[] args) {
        try {
            PatchRollBack.checkPatch();
            PatchDto patchDto = InitPatchZipTool.getPatchInfoFromXml(patchXml);
            PatchRollBack.backupCurrentPatch(patchDto);
            PatchRollBack.rollBackPatchFile(patchDto);
            PatchRollBack.deleteAllFiles(patchDto.getAddFiles());
            PatchRollBack.rollBackConfigData();
            FileUtil.deleteAllFolder(new File(oldBackPath));
            FileUtil.deleteAllFolder(new File(dataFilePath));
            SystemExitUtil.exitOK();
        }
        catch (PatchException e) {
            LOGGER.error((Object)("patch rollback failed1: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchRollBack.cleanFiles();
            PatchRollBack.showMessage(e.getErrorCode());
        }
        catch (Exception e) {
            LOGGER.error((Object)("patch rollback failed2: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchRollBack.cleanFiles();
            PatchRollBack.showMessage(10003L);
        }
        SystemExitUtil.exitFail();
    }

    private static void dealWithWccConfig() throws IOException {
        File tmpFile = new File(importTmpFile);
        if (tmpFile.exists()) {
            tmpFile.setWritable(true);
            tmpFile.delete();
        }
        if (!new File(backupConfig).exists()) {
            throw new PatchException("the backup wcc config not found. error return.");
        }
        String pwd = SysConfigDataUtil.getRandomPassword();
        WccEncryptor.getInstance().exportCipherKey(tmpFile.getCanonicalPath(), pwd);
        if (!new File(currentConfig).exists()) {
            throw new PatchException("the current wcc config not found. error return.");
        }
        WccEncryptor.getInstance().importCipherKey(tmpFile.getCanonicalPath(), pwd);
    }

    private static void showMessage(long code) {
        String langKey = "PATCH.ROLLBACK.ERROR." + code;
        String msg = LegoResourceManager.getString(langKey);
        if (VerifyUtil.isEmpty((String)msg)) {
            langKey = "PATCH.ROLLBACK.ERROR.10003";
            msg = LegoResourceManager.getString(langKey);
        }
        SystemPrint.systemPrintStr("");
        SystemPrint.systemPrintStr(msg);
        SystemPrint.systemPrintStr("");
    }

    private static void rollBackConfigData() {
        File dataPath = new File(dataFilePath);
        if (!dataPath.exists() || !dataPath.isDirectory()) {
            LOGGER.error((Object)"rollBackConfigData failed, dataPath not found.", "");
            throw new PatchException("rollBackConfigData failed");
        }
        String dataZip = "";
        try {
            for (File file : dataPath.listFiles()) {
                if (!file.getName().startsWith("data") || !file.getName().endsWith(".zip")) continue;
                dataZip = file.getCanonicalPath();
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("rollBackConfigData failed, get data file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("rollBackConfigData failed");
        }
        isRollbackData = true;
        SysConfigDataUtil.recoveryConfigData(dataZip, null);
    }

    private static void cleanFiles() {
        try {
            File file = new File(oldBackPath);
            if (isRollbackPatch) {
                LOGGER.info((Object)"patch rollback failed, start recovery patch file.", "");
                PatchRollBack.copyAllFiles(file);
                LOGGER.info((Object)"end recovery patch file.", "");
            }
            if (isRollbackData) {
                LOGGER.info((Object)"patch rollback failed, start recovery config data.", "");
                DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
                SysConfigDataUtil.recoveryConfigData(currentConfigData, dbInfo.getDbaPassword());
                FileUtil.deleteFile(currentConfigData);
                LOGGER.info((Object)"end recovery config data.", "");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("recovery config data failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchRollBack.showMessage(10004L);
        }
    }

    private static void copyAllFiles(File file) {
        if (file.isDirectory()) {
            File[] files;
            for (File fileTmp : files = file.listFiles()) {
                PatchRollBack.copyAllFiles(fileTmp);
            }
        } else {
            try {
                String tmpFilePath = file.getCanonicalPath().substring(oldBackPath.length());
                String destFile = installPath + File.separator + tmpFilePath;
                FileUtil.copyFile(file.getCanonicalPath(), destFile);
                file.delete();
            }
            catch (Exception e) {
                LOGGER.error((Object)("copyFiles failed, file: " + file.getName() + ", error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException(10004L);
            }
        }
    }

    private static void deleteAllFiles(List<PatchFile> files) {
        if (VerifyUtil.isEmpty(files)) {
            return;
        }
        for (PatchFile file : files) {
            for (Map.Entry<String, String> entrys : file.getPaths().entrySet()) {
                String destFile = installPath + File.separator + entrys.getKey() + File.separator + file.getDistName();
                FileUtil.deleteFile(destFile);
            }
        }
    }

    private static void rollBackPatchFile(PatchDto patchDto) {
        LOGGER.info((Object)"start rollBack patch file.", "");
        File file = new File(patchFile);
        if (!file.exists() || !patchFile.endsWith(".zip")) {
            LOGGER.error((Object)"patch zip file not exists, rollBackPatchFile failed.", "");
            throw new PatchException("rollBackPatchFile failed.");
        }
        FileUtil.unzipFile(patchFile, patchTmpPath);
        isRollbackPatch = true;
        File patchFilePath = new File(patchTmpPath);
        List<String> absFileList = PatchRollBack.getAbsFilePathList(patchDto);
        PatchRollBack.copyAllFiles(patchFilePath, patchTmpPath, absFileList);
        LOGGER.info((Object)"end rollBack patch file.", "");
    }

    private static void copyAllFiles(File tmp, String outPath, List<String> absFileList) {
        if (tmp.isDirectory()) {
            File[] files;
            for (File file : files = tmp.listFiles()) {
                PatchRollBack.copyAllFiles(file, outPath, absFileList);
            }
        } else {
            try {
                String srcFile = tmp.getCanonicalPath();
                String tmpPath = srcFile.substring(outPath.length());
                String destFile = PatchRollBack.isAbsFile(absFileList, tmpPath) ? tmpPath : installPath + tmpPath;
                FileUtil.copyFile(srcFile, destFile);
            }
            catch (IOException e) {
                LOGGER.error((Object)("copyAllFiles failed, srcFile is:" + tmp.getName() + ", errorMsg: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("copyAllFiles failed.");
            }
        }
    }

    private static boolean isAbsFile(List<String> absList, String backPath) {
        boolean isAbsFile = false;
        backPath = backPath.replace("\\\\", "/");
        for (String file : absList) {
            if (!backPath.equals(file)) continue;
            isAbsFile = true;
            break;
        }
        return isAbsFile;
    }

    private static List<String> getAbsFilePathList(PatchDto patchDto) {
        String path;
        ArrayList<String> pathList = new ArrayList<String>();
        for (PatchFile rp : patchDto.getRpFiles()) {
            for (Map.Entry<String, String> distPath : rp.getPaths().entrySet()) {
                path = distPath.getValue();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.startsWith("/") && (path.startsWith("/") || !path.contains(":"))) continue;
                pathList.add(path + "/" + rp.getDistName());
            }
        }
        for (PatchFile rp : patchDto.getDelFiles()) {
            for (Map.Entry<String, String> distPath : rp.getPaths().entrySet()) {
                path = distPath.getValue();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (!path.startsWith("/") && (path.startsWith("/") || !path.contains(":"))) continue;
                pathList.add(path);
            }
        }
        return pathList;
    }

    private static void backupCurrentPatch(PatchDto patchDto) {
        LOGGER.info((Object)"start backup current patch.", "");
        File backPath = new File(oldBackPath);
        if (!backPath.exists() || !backPath.isDirectory()) {
            LOGGER.info((Object)("create backup path result: " + backPath.mkdir()), "");
        }
        ArrayList<PatchFile> backUpList = new ArrayList<PatchFile>();
        backUpList.addAll(patchDto.getRpFiles());
        backUpList.addAll(patchDto.getAddFiles());
        try {
            FileUtil.deleteAllFilesInFolder(backPath);
            for (PatchFile backupFile : backUpList) {
                for (Map.Entry<String, String> map : backupFile.getPaths().entrySet()) {
                    String srcFile = map.getValue() + File.separator + backupFile.getDistName();
                    String destPath = oldBackPath + File.separator + map.getKey();
                    String destFile = destPath + File.separator + backupFile.getDistName();
                    File path = new File(destPath);
                    if (!path.exists() || !path.isDirectory()) {
                        LOGGER.info((Object)("create path result: " + path.mkdirs()), "");
                    }
                    FileUtil.copyFile(srcFile, destFile);
                }
            }
            String tmpPath = oldBackPath + File.separator + PatchDefine.PATCH_RELEASE_PATH;
            File tmp = new File(tmpPath);
            if (!tmp.exists() || !tmp.isDirectory()) {
                LOGGER.info((Object)("create tmpPath result: " + tmp.mkdirs()), "");
            }
            String backXml = oldBackPath + File.separator + PatchDefine.OLD_XML_FILE;
            FileUtil.copyFile(patchXml, backXml);
            String srcVersion = installPath + File.separator + PatchDefine.OLD_VERSION_FILE;
            String backVersion = oldBackPath + File.separator + PatchDefine.OLD_VERSION_FILE;
            FileUtil.copyFile(srcVersion, backVersion);
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            SysConfigDataUtil.backupSystemData(currentConfigData, dbInfo.getDbaPassword(), true);
            FileUtil.deleteFile(patchXml);
            FileUtil.deleteFile(srcVersion);
        }
        catch (Exception e) {
            LOGGER.error((Object)("backupCurrentPatch file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            FileUtil.deleteAllFolder(backPath);
            throw new PatchException(10003L);
        }
        LOGGER.info((Object)"end backup current patch.", "");
    }

    private static void checkPatch() throws IOException {
        LOGGER.info((Object)"start check patch.", "");
        PatchRollBack.checkPatchInstalled();
        PatchRollBack.dealWithWccConfig();
        PatchRollBack.checkConfigData();
        PatchRollBack.checkHistoryPatchFile();
        LOGGER.info((Object)"end check patch.", "");
    }

    private static void checkHistoryPatchFile() {
        File path = new File(dataFilePath);
        if (!path.exists() || !path.isDirectory()) {
            LOGGER.error((Object)"checkHistoryPatchFile failed, data path not exists.", "");
            throw new PatchException(10001L);
        }
        File[] files = path.listFiles();
        try {
            for (File file : files) {
                if (!file.getName().startsWith("patch") || !file.getName().endsWith(".zip")) continue;
                patchFile = file.getCanonicalPath();
            }
            if (VerifyUtil.isEmpty((String)patchFile)) {
                LOGGER.error((Object)"get patch zip file failed.", "");
                throw new PatchException(10003L);
            }
            SignVerifier.getInstance().verify(patchFile);
        }
        catch (IOException e) {
            LOGGER.error((Object)("get patch file path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException(10003L);
        }
        catch (SignatureException e) {
            LOGGER.error((Object)e, "check patch zip file signer failed.");
            throw new PatchException(10001L);
        }
    }

    private static void checkConfigData() {
        File path = new File(dataFilePath);
        if (!path.exists() || !path.isDirectory()) {
            LOGGER.error((Object)"checkConfigData failed, data path not exists.", "");
            throw new PatchException(10001L);
        }
        File[] files = path.listFiles();
        try {
            for (File file : files) {
                if (!file.getName().startsWith("data") || !file.getName().endsWith(".zip")) continue;
                configData = file.getCanonicalPath();
            }
            if (VerifyUtil.isEmpty((String)configData)) {
                LOGGER.error((Object)"get data zip file failed.", "");
                throw new PatchException(10003L);
            }
            SignVerifier.getInstance().verify(configData);
        }
        catch (IOException e) {
            LOGGER.error((Object)("get data file path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException(10003L);
        }
        catch (SignatureException e) {
            LOGGER.error((Object)e, "check data zip file signer failed.");
            throw new PatchException(10001L);
        }
    }

    private static void checkPatchInstalled() {
        File xmlFile = new File(patchXml);
        if (!xmlFile.exists()) {
            LOGGER.error((Object)"patch.xml not found, maybe the patch is not to be installed.", "");
            throw new PatchException(10002L);
        }
    }

    static {
        try {
            installPath = new File("../../").getCanonicalPath();
            dataFilePath = installPath + File.separator + PatchDefine.PATCH_BACKUP_PATH;
            patchXml = installPath + File.separator + PatchDefine.OLD_XML_FILE;
            oldBackPath = installPath + File.separator + PatchDefine.ROLLBACK_BACKUP_SYS_PATH;
            patchTmpPath = installPath + File.separator + PatchDefine.PATCH_BACKUP_PATCH_TMP_PATH;
            currentConfigData = oldBackPath + File.separator + "ConfigData.zip";
            importTmpFile = dataFilePath + File.separator + "configTmp";
            backupConfig = dataFilePath + File.separator + "wcc";
            currentConfig = installPath + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "wcc";
        }
        catch (IOException e) {
            LOGGER.error((Object)"get current path failed.", ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }
}

