/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.uninstall.autouninstall;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.UninstallDBTool;
import com.huawei.lego.cli.extendclass.ExtendClassUtil;
import com.huawei.lego.cli.uninstall.autouninstall.IAutoUninstallExtend;
import com.huawei.lego.cli.uninstall.autouninstall.UninstallAction;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.install.InstallCommon;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.dbtool.GaussDBUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.IOException;
import java.sql.SQLException;

public class AutoUninstall {
    private static final Log LOGGER = LogFactory.getInstance(AutoUninstall.class);

    public static void main(String[] args) {
        if (ExtendClassUtil.hasExtendFile()) {
            IAutoUninstallExtend extendClass = (IAutoUninstallExtend)ExtendClassUtil.getExtendClass(AutoUninstall.class.getName());
            extendClass.main();
            return;
        }
        AutoUninstall.initSystemInfo();
        String password = InitInstalledXmlTool.getInstalledSystem().getDbInfor().getDbaPassword();
        String managerdbaPwd = InitInstalledXmlTool.getInstalledSystem().getDbInfor().getManagerPassword();
        boolean isUninstalldb = Boolean.TRUE;
        boolean isUninstallGauss = Boolean.FALSE;
        if (null == password || "".equals(password.trim())) {
            LOGGER.error((Object)"CLI Uninstall can't get database password", "");
            PrepareParamUtil.exitFail(0);
        }
        PrepareParamUtil.initEnv(password, managerdbaPwd);
        if (null != args && args.length > 0) {
            if (args[0].equalsIgnoreCase("isdbvalid")) {
                AutoUninstall.checkDBValid();
            }
            if (args[0].equalsIgnoreCase("savedb")) {
                isUninstalldb = Boolean.FALSE;
            }
            if (args[0].equalsIgnoreCase("nodb")) {
                isUninstalldb = Boolean.FALSE;
            }
            if (args[0].equalsIgnoreCase("uninstallGaussDB")) {
                isUninstallGauss = Boolean.TRUE;
                isUninstalldb = Boolean.TRUE;
            }
        }
        AutoUninstall.run(isUninstalldb, isUninstallGauss);
    }

    private static void initSystemInfo() {
        try {
            InitInstalledXmlTool.initSystemInfo();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
            SystemExitUtil.exitFail();
        }
    }

    private static void checkDBValid() {
        InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
        DataBaseInfo dbInfor = system.getDbInfor();
        boolean isValid = UninstallDBTool.checkDbValid(dbInfor);
        if (isValid) {
            LOGGER.debug((Object)"/n------------------DbValid:true/n", "");
            PrepareParamUtil.exitFail(0);
        } else {
            LOGGER.debug((Object)"/n------------------DbValid:false/n", "");
            PrepareParamUtil.exitFail(1);
        }
    }

    private static void run(boolean isUninstall, boolean isUninstallGauss) {
        try {
            InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
            DataBaseInfo dbInfor = system.getDbInfor();
            if (isUninstallGauss) {
                isUninstall = Boolean.FALSE;
                GaussDBUtil.stopGaussDB();
                GaussDBUtil.unInstallGaussDB();
            }
            if (isUninstall) {
                UninstallDBTool.uninstallDB(dbInfor, system.getInstallpath());
                UninstallAction.updatecallBack();
                LOGGER.debug((Object)"Uninstall Db complete.\n", "");
            }
            UninstallAction.serviceCallBack();
            InstallCommon.uninstallHASoft();
            UninstallAction.deleteAll();
            LOGGER.info((Object)"Uninstallation is completed.\n\n************Uninstall Succeed!************\n\n", "");
            SystemPrint.systemPrintStr("Uninstallation is completed.\n\n************Uninstall Succeed!************\n\n");
            PrepareParamUtil.exitFail(0);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("Uninstall Error " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemPrint.systemPrintStr("Uninstall Error");
            PrepareParamUtil.exitFail(-1);
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)"Uninstall Error", (Throwable)e, "");
            SystemPrint.systemPrintStr("Uninstall Error");
            PrepareParamUtil.exitFail(-1);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Uninstall Error", (Throwable)e, "");
            SystemPrint.systemPrintStr("Uninstall Error");
            PrepareParamUtil.exitFail(-1);
        }
        catch (PatchException e) {
            LOGGER.error((Object)"Uninstall Error", (Throwable)e, "");
            SystemPrint.systemPrintStr("Uninstall Error");
            PrepareParamUtil.exitFail(-1);
        }
    }
}

