/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.uninstall.autouninstall;

import com.huawei.lego.cli.uninstall.autouninstall.IAutoUninstallExtend;
import com.huawei.lego.cli.uninstall.autouninstall.UninstallAction;
import com.huawei.lego.cli.util.PrepareParamUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;

public class AutoUninstallExtend
implements IAutoUninstallExtend {
    private static final Log LOGGER = LogFactory.getInstance(AutoUninstallExtend.class);

    private static void run() {
        try {
            UninstallAction.serviceCallBack();
            UninstallAction.updatecallBack();
            UninstallAction.deleteAll();
            LOGGER.info((Object)"Uninstallation is completed.\n\n************Uninstall Succeed!************\n\n", "");
            PrepareParamUtil.exitFail(0);
        }
        catch (PatchException e) {
            LOGGER.error((Object)"Uninstall Error", (Throwable)e, "");
            PrepareParamUtil.exitFail(-1);
        }
    }

    @Override
    public void main() {
        String managerPwd;
        String password = InitInstalledXmlTool.getInstalledSystem().getDbInfor().getDbaPassword();
        if (null == password || "".equals(password.trim())) {
            LOGGER.error((Object)"CLI Uninstall can't get database password", "");
            PrepareParamUtil.exitFail(0);
        }
        if (null == (managerPwd = InitInstalledXmlTool.getInstalledSystem().getDbInfor().getManagerPassword()) || "".equals(managerPwd.trim())) {
            LOGGER.error((Object)"CLI Uninstall can't get database productPwd", "");
            PrepareParamUtil.exitFail(0);
        }
        PrepareParamUtil.initEnv(password, managerPwd);
        AutoUninstallExtend.run();
    }
}

