/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.uninstall.autouninstall;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.ProductBundles;
import com.huawei.drm.install.common.util.dbtool.InitDBTool;
import com.huawei.lego.cli.extendclass.ExtendClassUtil;
import com.huawei.lego.cli.uninstall.autouninstall.IUninstallActionExtend;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.security.SignatureException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Properties;

public class UninstallAction {
    public static final String SAVE_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final InstalledSystem LEGO_SYSTEM = InitInstalledXmlTool.getInstalledSystem();
    private static final Log LOGGER = LogFactory.getInstance(UninstallAction.class);
    private static boolean sProductDelete = false;

    public static void deleteAll() throws PatchException {
        String paraFileName = LegoResourceManager.getProValue("install.params.tmp.file");
        String file1 = OSInformation.getInstalledFile();
        String file2 = OSInformation.getUserHomePath() + "/" + paraFileName;
        FileUtil.deleteAllFolder(new File(SAVE_PATH + LegoResourceManager.getProValue("install.lego_version.platform.name")));
        FileUtil.deleteFile(file1);
        FileUtil.deleteFile(file2);
        LOGGER.info((Object)"delete all file finish", "");
    }

    public static void serviceCallBack() throws PatchException {
        if (ExtendClassUtil.hasExtendFile()) {
            IUninstallActionExtend extendClass = (IUninstallActionExtend)ExtendClassUtil.getExtendClass(UninstallAction.class.getName());
            extendClass.serviceCallBack();
        } else {
            UninstallAction.legoServiceCallBack();
        }
    }

    private static void legoServiceCallBack() throws PatchException {
        Properties props = System.getProperties();
        String os = props.getProperty("os.name");
        if (os.contains("Windows")) {
            String legoServer = SAVE_PATH + "/Runtime/LegoRuntime/serviceMgr.bat";
            String legoWebSrv = SAVE_PATH + "/Runtime/Tomcat6/bin/service.bat";
            String monitor = SAVE_PATH + "/Runtime/monitor/serviceMgr.bat";
            String menuCmd = SAVE_PATH + "/Runtime/bin/rdShortcut.bat";
            try {
                SignVerifier.getInstance().verify(new String[]{legoServer, legoWebSrv, monitor, menuCmd});
            }
            catch (SignatureException e1) {
                PatchException ex = new PatchException("verify fail", e1);
                throw ex;
            }
            LOGGER.info((Object)"begin callBack PlatForm lego service Uninstall bat serviceMgr.bat", "");
            CmdUtil.runbatParams(legoServer, new String[]{"uninstall"});
            LOGGER.info((Object)"begin callBack Tomcat Uninstall bat service.bat", "");
            CmdUtil.runbatParams(legoWebSrv, new String[]{"uninstall"});
            LOGGER.info((Object)"begin callBack monitor Uninstall bat serviceMgr.bat", "");
            CmdUtil.runbatParams(monitor, new String[]{"uninstall"});
            LOGGER.info((Object)"begin callBack shortcut Uninstall bat rdShortcut.bat", "");
            CmdUtil.runbatParams(menuCmd, null);
        } else {
            String linuxShell = SAVE_PATH + "/Runtime/bin/rmService.sh";
            try {
                SignVerifier.getInstance().verify(new String[]{linuxShell});
            }
            catch (SignatureException e1) {
                PatchException ex = new PatchException("verify fail", e1);
                throw ex;
            }
            try {
                CmdUtil.runShell(linuxShell);
            }
            catch (IOException e) {
                PatchException ex = new PatchException("", e);
                throw ex;
            }
            catch (InterruptedException e) {
                PatchException ex = new PatchException("", e);
                throw ex;
            }
            LOGGER.info((Object)"begin callBack PlatForm Uninstall Shell rmService.sh", "");
        }
    }

    public static void updatecallBack() throws PatchException {
        try {
            Collection<ProductBundles> tmpList = LEGO_SYSTEM.getPdMap().values();
            Properties props = System.getProperties();
            String os = props.getProperty("os.name");
            if (sProductDelete) {
                DataBaseInfo dbInfor = LEGO_SYSTEM.getDbInfor();
                for (ProductBundles productBundles : tmpList) {
                    InitDBTool.uninstallProductDB(dbInfor, productBundles.getId());
                }
            }
            if (os.contains("Windows")) {
                if (sProductDelete) {
                    UninstallAction.exectProductBatScripts(tmpList);
                }
            } else if (sProductDelete) {
                UninstallAction.excuteProductShellScripts(tmpList);
            }
            LOGGER.info((Object)"end callBack platform.bat and product.bat", "");
        }
        catch (PatchException e) {
            LOGGER.error((Object)"call Back platform", (Throwable)e, "");
            PatchException ex = new PatchException("", e);
            throw ex;
        }
        catch (IOException e) {
            LOGGER.error((Object)"call Back platform", (Throwable)e, "");
            PatchException ex = new PatchException("", e);
            throw ex;
        }
        catch (SQLException e) {
            LOGGER.error((Object)("call Back platform" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException("call Back platform failed.");
            throw ex;
        }
    }

    private static void excuteProductShellScripts(Collection<ProductBundles> tmpList) throws PatchException {
        for (ProductBundles productBundles : tmpList) {
            String linuxInitCmd = productBundles.getLinuxUnsCmd();
            if (null == linuxInitCmd || linuxInitCmd.trim().length() <= 0) continue;
            String productBundlePath = productBundles.getId();
            String path = SAVE_PATH + "/" + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundlePath + "/" + linuxInitCmd;
            try {
                CmdUtil.runShell(path);
            }
            catch (IOException e) {
                PatchException ex = new PatchException("", e);
                throw ex;
            }
            catch (InterruptedException e) {
                PatchException ex = new PatchException("", e);
                throw ex;
            }
            LOGGER.info((Object)("begin callBack product sh:" + linuxInitCmd), "");
        }
    }

    private static void exectProductBatScripts(Collection<ProductBundles> tmpList) {
        for (ProductBundles productBundles : tmpList) {
            String windowsInitCmd = productBundles.getWindowsUnsCmd();
            if (null == windowsInitCmd || windowsInitCmd.trim().length() <= 0) continue;
            String productBundlePath = productBundles.getId();
            String path = SAVE_PATH + "/" + LegoResourceManager.getProValue("install.uninstalldb.script") + productBundlePath + "/" + windowsInitCmd;
            CmdUtil.runbatParams(path, null);
            LOGGER.info((Object)("begin callBack product.bat:" + windowsInitCmd), "");
        }
    }

    static {
        Collection<ProductBundles> pdList = LEGO_SYSTEM.getPdMap().values();
        if (!pdList.isEmpty()) {
            sProductDelete = true;
        }
    }
}

