/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.uninstall.autouninstall;

import com.huawei.lego.cli.uninstall.autouninstall.IUninstallActionExtend;
import com.huawei.lego.cli.uninstall.autouninstall.UninstallAction;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.SignVerifier;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Properties;

public class UninstallActionExtend
implements IUninstallActionExtend {
    public static final String SAVE_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final Log LOGGER = LogFactory.getInstance(UninstallAction.class);

    @Override
    public void serviceCallBack() throws PatchException {
        Properties props = System.getProperties();
        String os = props.getProperty("os.name");
        if (os.contains("Windows")) {
            String legoServer = SAVE_PATH + "/Runtime/LegoRuntime/serviceMgr.bat";
            try {
                SignVerifier.getInstance().verify(legoServer);
            }
            catch (SignatureException e) {
                throw new PatchException("verify fail", e);
            }
            LOGGER.debug((Object)"begin callBack PlatForm Uninstall bat", "");
            CmdUtil.runbatParams(legoServer, new String[]{"uninstall"});
        } else {
            String linuxShell = SAVE_PATH + "/Runtime/bin/rmService.sh";
            try {
                SignVerifier.getInstance().verify(linuxShell);
            }
            catch (SignatureException e) {
                throw new PatchException("verify fail", e);
            }
            try {
                CmdUtil.runShell(linuxShell);
            }
            catch (IOException ioe) {
                throw new PatchException("", ioe);
            }
            catch (InterruptedException ex) {
                throw new PatchException("", ex);
            }
            LOGGER.debug((Object)"begin callBack service  Uninstall Shell rmService.sh", "");
        }
    }
}

