/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitDBTool;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.UpdateUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CloudServiceUpgrade {
    private static final String SP = File.separator;
    private static Log logger = LogFactory.getInstance(CloudServiceUpgrade.class);

    public static void main(String[] args) {
        File file;
        if (args.length != 1) {
            logger.error((Object)"cloud service upgrade failed, params error.", "");
            SystemExitUtil.exitFail();
        }
        if (!(file = new File(args[0])).exists()) {
            logger.error((Object)"cloud service upgrade failed, the file not found.", "");
            SystemExitUtil.exitFail();
        }
        try {
            DataBaseInfo dbInfor = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            Map<String, String> versionMap = CloudServiceUpgrade.getBundleVersion(file);
            CloudServiceUpgrade.updateBaseData(dbInfor, versionMap);
            CloudServiceUpgrade.updateAppData(dbInfor, versionMap);
            UpdateUtil.convertCloudData();
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            logger.error((Object)("failed to upgrade cloud service, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
    }

    private static void updateBaseData(DataBaseInfo dbInfor, Map<String, String> versionMap) throws SQLException, IOException {
        logger.info((Object)"start update base data.", "");
        String oldVersion = versionMap.get("lego.platform.base.core");
        if (VerifyUtil.isEmpty((String)oldVersion)) {
            logger.error((Object)"updateBaseData failed, get old base bundle version is empty.", "");
            throw new PatchException("updateBaseData failed.");
        }
        String scriptPath = new File("").getCanonicalPath() + SP + "script" + SP + "platform" + SP + "gauss" + SP + "update";
        InitDBTool.updatePlatformDB(dbInfor, oldVersion, scriptPath, true);
    }

    private static void updateAppData(DataBaseInfo dbInfor, Map<String, String> versionMap) throws SQLException, IOException {
        Set<Map.Entry<String, String>> entrySet = versionMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if ("lego.platform.base.core".equals(entry.getKey())) continue;
            logger.info((Object)("start update " + entry.getKey()), "");
            String scriptPath = new File("").getCanonicalPath() + File.separator + "script" + File.separator + entry.getKey() + File.separator + "update";
            InitDBTool.updateProductDB(dbInfor, null, entry.getValue(), scriptPath);
        }
    }

    private static Map<String, String> getBundleVersion(File file) {
        FileInputStream input = null;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        try {
            Properties proper = new Properties();
            input = new FileInputStream(file);
            proper.load(input);
            String reg = "^[0-9]{1,}\\.[0-9]{1,}\\.[0-9]{1,}";
            Pattern pat = Pattern.compile(reg);
            Set<Map.Entry<Object, Object>> datas = proper.entrySet();
            for (Map.Entry<Object, Object> data : datas) {
                String key = String.valueOf(data.getKey());
                String value = String.valueOf(data.getValue());
                Matcher mat = pat.matcher(Normalizer.normalize(value, Normalizer.Form.NFKC));
                if (!mat.matches()) {
                    logger.error((Object)("get bundel version failed, key=" + key + ", value=" + value), "");
                    throw new PatchException("getBundleVersion failed.");
                }
                logger.info((Object)("app: " + key + ", version=" + value), "");
                dataMap.put(key, value);
            }
        }
        catch (IOException e) {
            try {
                logger.error((Object)("get bundle version failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("getBundleVersion failed.");
            }
            catch (Throwable throwable) {
                FileUtil.close(input, "");
                throw throwable;
            }
        }
        FileUtil.close(input, "");
        return dataMap;
    }
}

