/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.ism.drm.wcc.util.kmc.KmcInstance;
import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileEncryptor;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ConfigDataBackup {
    private static final Log logger = LogFactory.getInstance(ConfigDataBackup.class);
    private static final String LINUX_DMP = "/usr/local/gaussdb/bin/gs_dump";
    private static final String SALTFILE = "zip1.tmp";
    private static final String IVFILE = "zip2.tmp";
    private static final String SQL_FILE = "lego.sql";
    private static final String DATAFILE = "data.zip";
    private static final String WCC_FILE = "wcc.conf";
    private static final String WCC_HW_FILE = "wcc-hw.conf";
    private static final String BUNDLEFILE = "bundle.info";
    private static final String SP = File.separator;
    private static Map<String, String> installData = null;
    private static final String INSTALL_PATH = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
    private static final String LEGO_PROPERTIES = INSTALL_PATH + File.separator + "Runtime" + File.separator + "LegoRuntime" + File.separator + "conf" + File.separator + "lego.properties";
    private static final String DEFAULT_ENCRYPT_PASSWORD_KEY = "config.backup.encrypt.password.default";

    public static void backupData(String destFile, String encryptPwd) {
        String dstParent = new File(destFile).getParent();
        String sqlFile = dstParent + File.separator + SQL_FILE;
        File zipFile = null;
        ArrayList<String> fileList = new ArrayList<String>();
        try {
            ConfigDataBackup.exportData(sqlFile);
            zipFile = FileUtil.zipFile(new File(sqlFile));
            String ivFile = dstParent + SP + IVFILE;
            String saltFile = dstParent + SP + SALTFILE;
            FileEncryptor.encryptFileAccordingCipher(encryptPwd, zipFile, ivFile, saltFile, DATAFILE);
            fileList.add(DATAFILE);
            fileList.add(IVFILE);
            fileList.add(SALTFILE);
            logger.info((Object)"start export wcc.", "");
            ConfigDataBackup.exportKey(dstParent, encryptPwd);
            fileList.add(WCC_FILE);
            fileList.add(WCC_HW_FILE);
            logger.info((Object)"start export bundle version info.", "");
            String bundleFile = dstParent + SP + BUNDLEFILE;
            FileUtil.writeFile(bundleFile, ConfigDataBackup.getInstallInfo().get("bundleVersion"));
            fileList.add(BUNDLEFILE);
            FileUtil.zipFile(fileList, dstParent, destFile, false);
        }
        catch (Exception e) {
            logger.error((Object)("back data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("back data failed");
        }
        finally {
            File[] files;
            File file = new File(sqlFile);
            if (file.exists()) {
                file.delete();
            }
            if (null != zipFile && zipFile.exists()) {
                zipFile.delete();
            }
            for (File tmpFile : files = new File(dstParent).listFiles()) {
                if (!fileList.contains(tmpFile.getName())) continue;
                tmpFile.delete();
            }
        }
    }

    private static void exportData(String sqlFile) {
        Map<String, String> data = ConfigDataBackup.getInstallInfo();
        StringBuffer buffer = new StringBuffer();
        buffer.append(LINUX_DMP);
        buffer.append(" -h 127.0.0.1");
        buffer.append(" -U " + data.get("dbUser"));
        buffer.append(" -W " + data.get("dbPwd"));
        buffer.append(" -p " + data.get("dbPort"));
        buffer.append(" -Eutf8 ");
        buffer.append(" --pg-format ");
        buffer.append(" LEGO ");
        buffer.append(" -f ");
        buffer.append(sqlFile);
        logger.info((Object)"start config system data.", "");
        if (!CmdUtil.execStrCmd(buffer.toString())) {
            throw new PatchException("export data failed.");
        }
        if (!new File(sqlFile).exists()) {
            throw new PatchException("export data failed, dest file not found.");
        }
    }

    private static void exportKey(String path, String encryptPwd) {
        ConfigDataBackup.getInstallInfo();
        try {
            KmcInstance.getSoftInstance().exportMkFile(path + SP + WCC_FILE, encryptPwd.getBytes(StandardCharsets.UTF_8));
            KmcInstance.getHwInstance().exportMkFile(path + SP + WCC_HW_FILE, encryptPwd.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            logger.error((Object)"Export kmc ks file error. Exception:%s", ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    private static Map<String, String> getInstallInfo() {
        if (null != installData) {
            return installData;
        }
        File file = new File(OSInformation.getInstalledFile());
        if (!file.exists()) {
            throw new PatchException("can not find the RDInstalled.xml");
        }
        installData = new HashMap<String, String>();
        try {
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(file);
            List pathList = document.selectNodes("/install/installpath");
            if (null != pathList && !pathList.isEmpty()) {
                Element ele = (Element)pathList.get(0);
                installData.put("installPath", ele.attributeValue("path"));
            }
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            installData.put("dbPort", dbInfo.getDbPort());
            installData.put("dbUser", dbInfo.getDbaUsername());
            installData.put("dbPwd", dbInfo.getDbaPassword());
            StringBuilder data = new StringBuilder();
            String lineSp = System.getProperty("line.separator");
            List bundle = document.selectNodes("/install/platform");
            for (Object obj : bundle) {
                Element el = (Element)obj;
                data.append(el.attribute("id").getValue() + "=" + el.attribute("version").getValue() + lineSp);
            }
            List proBundle = document.selectNodes("/install/product");
            for (Object obj : proBundle) {
                Element el = (Element)obj;
                data.append(el.attribute("id").getValue() + "=" + el.attribute("version").getValue() + lineSp);
            }
            installData.put("bundleVersion", data.toString());
        }
        catch (Exception e) {
            logger.error((Object)("getInstallInfo failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("getInstallInfo failed");
        }
        return installData;
    }

    public static void main(String[] args) {
        try {
            String encryptPwd = null;
            String destFile = args[0];
            if (args.length == 1) {
                try {
                    encryptPwd = CertificateUtil.getPasswordFromConfig(LEGO_PROPERTIES, DEFAULT_ENCRYPT_PASSWORD_KEY);
                }
                catch (IOException e) {
                    logger.error((Object)"Get default encrypt password from lego.properties failed.", (Throwable)e);
                    SystemExitUtil.exitFail();
                }
            } else if (args.length == 2) {
                encryptPwd = args[0];
                destFile = args[1];
            } else {
                logger.error((Object)"configdata failed, param error.", "");
                SystemExitUtil.exitFail();
            }
            String destPath = new File(destFile).getParent();
            File path = new File(destPath);
            if (!path.exists()) {
                path.mkdirs();
            }
            ConfigDataBackup.backupData(destFile, encryptPwd);
            logger.info((Object)"config datab backup successfully.", "");
        }
        catch (Exception e) {
            logger.error((Object)("backup config data failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }
}

