/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.lego.common.cloud.service.merge.dbmerge.impl.DoubleDBMergeServiceImpl;
import com.huawei.lego.common.cloud.service.merge.util.ExportDataUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;

public class DoubleRDDataMerge {
    private static final String EXPORT_ACTION = "export";
    private static final String MERGE_ACTION = "merge";
    private static Log logger = LogFactory.getInstance(DoubleRDDataMerge.class);

    public static void main(String[] args) {
        if (!DoubleRDDataMerge.checkParams(args)) {
            SystemExitUtil.exitFail();
        }
        if (EXPORT_ACTION.equalsIgnoreCase(args[0])) {
            if (!ExportDataUtil.exportData()) {
                logger.error((Object)"export data failed in current node.", "");
                SystemExitUtil.exitFail();
            }
            return;
        }
        File file = new File(args[1]);
        if (!file.exists()) {
            logger.error((Object)("DoubleRD service upgrade failed, the file not found, filePath: " + file.getAbsolutePath()), "");
            SystemExitUtil.exitFail();
        }
        try {
            new DoubleDBMergeServiceImpl().merge(file);
            SystemExitUtil.exitOK();
        }
        catch (Exception e) {
            logger.error((Object)("failed to upgrade cloud service, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
    }

    private static boolean checkParams(String[] args) {
        if (args.length == 0) {
            logger.error((Object)"args length error.", "");
            return false;
        }
        if (!EXPORT_ACTION.equalsIgnoreCase(args[0]) && !MERGE_ACTION.equalsIgnoreCase(args[0])) {
            logger.error((Object)"action is error.", "");
            return false;
        }
        if (MERGE_ACTION.equalsIgnoreCase(args[0]) && args.length != 2) {
            logger.error((Object)"merge action params error.", "");
            return false;
        }
        return true;
    }
}

