/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.cli.update.UserInfoDataHandler;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class UserInfoDBProcessor {
    private static final Log LOGGER = LogFactory.getInstance(UserInfoDBProcessor.class);

    public static void processGauss(DataBaseInfo dbInfor) throws PatchException {
        Connection connection = null;
        try {
            LOGGER.info((Object)("start to execute processGauss of SyslogDBProcessor, dbType: " + dbInfor.getDbType()), "");
            connection = LegoDBConnection.getInstance().connectGaussDB(dbInfor, "lego");
            if (null != connection) {
                UserInfoDBProcessor.processUserEncryptChange(connection, dbInfor.getDbType());
            }
        }
        catch (PatchException e2) {
            PatchException ex = new PatchException("", e2);
            throw ex;
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)("SQLException: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private static void processUserEncryptChange(Connection conn, String dbType) throws PatchException {
        LOGGER.info((Object)"start to execute UserInfoHandler of UserMgrDBProcessor.", "");
        UserInfoDataHandler userInfoDataHandler = new UserInfoDataHandler();
        userInfoDataHandler.handleDBChange(conn, dbType);
        LOGGER.info((Object)"finish to execute UserInfoHandler of UserMgrDBProcessor.", "");
    }
}

