/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update;

import com.huawei.lego.cli.update.IDBHandler;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.common.util.CommonDBUtil;
import com.huawei.lego.common.util.SHAEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class UserInfoDataHandler
implements IDBHandler {
    private static final int TWO = 2;
    private static final long INT_7002 = 7002L;
    private static final long INT_7003 = 7003L;
    private static final long INT_7004 = 7004L;
    private static final long INT_7005 = 7005L;
    private static final long INT_7007 = 7007L;
    private static final long INT_7008 = 7008L;
    private static final long INT_7009 = 7009L;
    private static final long INT_7010 = 7010L;
    private static final long INT_7038 = 7038L;
    private static final long INT_7039 = 7039L;
    private static Log logger = LogFactory.getInstance(UserInfoDataHandler.class);

    @Override
    public void handleDBChange(Connection conn, String dbType) throws PatchException {
        if (this.tableIsExist(conn, "T_user")) {
            this.firstStep(conn);
        }
        if (this.tableIsExist(conn, "ti_nemgrprotocolextend")) {
            this.secondStep(conn);
        }
        if (this.tableIsExist(conn, "t_hiberarchynms_baseinfo")) {
            this.thirdStep(conn);
        }
        if (this.tableIsExist(conn, "T_operation_r_role")) {
            this.fourStep(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableIsExist(Connection conn, String tableName) {
        boolean flag = false;
        Statement pst = null;
        ResultSet resultnms = null;
        try {
            pst = CommonDBUtil.executeSQLQuery(conn, "SELECT * FROM information_schema.TABLES WHERE TABLE_NAME=?;", new Object[]{tableName});
            resultnms = pst.executeQuery();
            if (resultnms.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)("get table status failed: " + tableName), "");
        }
        catch (PatchException e) {
            logger.error((Object)("Select Table:" + tableName + "error"), (Throwable)e, "");
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
                if (null != resultnms) {
                    resultnms.close();
                }
            }
            catch (SQLException ew) {
                logger.error((Object)("Close pst error" + ExceptionUtil.getErrorMessage((Throwable)ew)), "");
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void thirdStep(Connection conn) {
        PreparedStatement pstatements = null;
        ResultSet rsultnms = null;
        try {
            pstatements = CommonDBUtil.executeSQLQuery(conn, "SELECT nms_id,userpwd FROM t_hiberarchynms_baseinfo;");
            rsultnms = pstatements.executeQuery();
            while (rsultnms.next()) {
                this.updateNmsInfoDB(conn, rsultnms);
            }
        }
        catch (SQLException ew) {
            logger.error((Object)("Select NMSINFO ERROR!" + ExceptionUtil.getErrorMessage((Throwable)ew)), "");
        }
        catch (PatchException e) {
            logger.error((Object)"Select NMSINFO ERROR!", (Throwable)e, "");
        }
        finally {
            try {
                if (null != rsultnms) {
                    rsultnms.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close pst Error!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (pstatements != null) {
                    pstatements.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close pst Error!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void secondStep(Connection conn) {
        PreparedStatement negMgrPst = null;
        ResultSet rsNemgr = null;
        try {
            negMgrPst = CommonDBUtil.executeSQLQuery(conn, "SELECT MOID,NETWORKPWD FROM ti_nemgrprotocolextend;");
            rsNemgr = negMgrPst.executeQuery();
            while (rsNemgr.next()) {
                this.updateNeMgrDb(conn, rsNemgr);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)("Select nemgr error !" + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
        catch (PatchException e) {
            logger.error((Object)"Select nemgr error !", (Throwable)e, "");
        }
        finally {
            try {
                if (null != rsNemgr) {
                    rsNemgr.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close pst error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (null != negMgrPst) {
                    negMgrPst.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close pst error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firstStep(Connection conn) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = CommonDBUtil.executeSQLQuery(conn, "SELECT user_id,user_pwd FROM T_user;");
            rs = pst.executeQuery();
            while (rs.next()) {
                this.updateUserInfoDb(conn, rs);
            }
        }
        catch (SQLException e) {
            logger.error((Object)("select User Error!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        catch (PatchException e) {
            logger.error((Object)"select User Error!", (Throwable)e, "");
        }
        finally {
            try {
                if (null != rs) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fourStep(Connection conn) {
        PreparedStatement pst = null;
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ResultSet rs3 = null;
        try {
            pst = CommonDBUtil.executeSQLQuery(conn, "SELECT role_id,opt_id FROM T_operation_r_role;");
            rs1 = pst.executeQuery();
            List<Long> roleIdList = this.updateRoleOpt(rs1);
            rs2 = pst.executeQuery();
            this.updateFor7003(conn, rs2, roleIdList);
            rs3 = pst.executeQuery();
            this.updateFor7008(conn, rs3, roleIdList);
            this.delUseLessDate(conn);
        }
        catch (SQLException e) {
            logger.error((Object)("select User Error!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        catch (PatchException e) {
            logger.error((Object)"select User Error!", (Throwable)e, "");
        }
        finally {
            try {
                if (null != rs3) {
                    rs3.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (null != rs2) {
                    rs2.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (null != rs1) {
                    rs1.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private void updateNmsInfoDB(Connection conn, ResultSet rs) throws PatchException {
        try {
            Long id = rs.getLong(1);
            String userpd = rs.getString(2);
            if (null != userpd && !"".equals(userpd) && AESEncryptor.encode(AESEncryptor.decode(userpd)).equals(userpd)) {
                String sh256str = SHAEncryptor.encrypt(AESEncryptor.decode(userpd));
                CommonDBUtil.executeSQL(conn, "update t_hiberarchynms_baseinfo set userpwd=? where nms_id=?", new Object[]{sh256str, id});
            }
        }
        catch (PatchException e) {
            PatchException ex = new PatchException("", e);
            throw ex;
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateNmsInfoDB failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private void updateUserInfoDb(Connection conn, ResultSet rs) throws PatchException {
        try {
            Long id = rs.getLong(1);
            String userpd = rs.getString(2);
            if (null != userpd && !"".equals(userpd) && AESEncryptor.encode(AESEncryptor.decode(userpd)).equals(userpd)) {
                String sh256str = SHAEncryptor.encrypt(AESEncryptor.decode(userpd));
                CommonDBUtil.executeSQL(conn, "update T_user set user_pwd=? where user_id=?", new Object[]{sh256str, id});
            }
        }
        catch (PatchException e) {
            PatchException ex = new PatchException("updateUserInfoDb failed", e);
            throw ex;
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateUserInfoDb failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private void updateNeMgrDb(Connection conn, ResultSet rs) throws PatchException {
        try {
            Long moId = rs.getLong(1);
            String nemgrpd = rs.getString(2);
            if (null != nemgrpd && !"".equals(nemgrpd)) {
                String decryptTmp = AESEncryptor.decode(nemgrpd);
                String newPwd = AESEncryptor.encode(decryptTmp);
                CommonDBUtil.executeSQL(conn, "update ti_nemgrprotocolextend set NETWORKPWD=? where MOID=?", new Object[]{newPwd, moId});
            }
        }
        catch (PatchException e) {
            PatchException ex = new PatchException("updateNeMgrDb failed.", e);
            throw ex;
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateNeMgrDb failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private List<Long> updateRoleOpt(ResultSet rs) throws PatchException {
        ArrayList<Long> roleIdList = new ArrayList<Long>();
        try {
            while (rs.next()) {
                Long roleId = rs.getLong(1);
                if (roleIdList.contains(roleId)) continue;
                roleIdList.add(roleId);
            }
            return roleIdList;
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateRoleOpt failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private void updateFor7008(Connection conn, ResultSet rs, List<Long> roleIdList) throws PatchException {
        try {
            while (rs.next()) {
                long roleId = rs.getLong(1);
                long optID = rs.getLong(2);
                this.updateFor7008ByRoledId(conn, roleIdList, roleId, optID);
            }
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateFor7008 failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private void updateFor7008ByRoledId(Connection conn, List<Long> roleIdList, long rId, long optID) throws PatchException {
        for (long roleId : roleIdList) {
            if (roleId != rId) continue;
            if (7007L == optID || 7009L == optID) {
                this.updateOrDelete(conn, rId, optID, 7008L);
                continue;
            }
            if (7010L != optID && 7038L != optID && 7039L != optID) continue;
            this.updateOrDelete(conn, rId, optID, 7008L);
        }
    }

    private void updateFor7003(Connection conn, ResultSet rs, List<Long> roleIdList) throws PatchException {
        try {
            while (rs.next()) {
                long rId = rs.getLong(1);
                long optID = rs.getLong(2);
                for (long roleId : roleIdList) {
                    if (roleId != rId || 7002L != optID && 7004L != optID && 7005L != optID) continue;
                    this.updateOrDelete(conn, rId, optID, 7003L);
                }
            }
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateFor7003 faile: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }

    private void delUseLessDate(Connection conn) {
        try {
            CommonDBUtil.executeSQL(conn, "DELETE FROM  T_operation_r_role WHERE opt_id = 7002 or opt_id = 7004 or opt_id = 7005 or opt_id = 7007 or opt_id = 7009 or opt_id = 7010 or opt_id = 7038 or opt_id = 7039");
        }
        catch (SQLException e) {
            logger.error((Object)("delUseLessDate error: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        try {
            CommonDBUtil.executeSQL(conn, "DELETE FROM  T_operations WHERE opt_id = 7002 or opt_id = 7004 or opt_id = 7005 or opt_id = 7007 or opt_id = 7009 or opt_id = 7010 or opt_id = 7038 or opt_id = 7039");
        }
        catch (SQLException ex) {
            logger.error((Object)("delUseLessDate error: " + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
        try {
            CommonDBUtil.executeSQL(conn, "update T_operations set serial_number = '7000-400-10' where serial_number = '7000-400-10-1';");
        }
        catch (SQLException ex) {
            logger.error((Object)("Update date error" + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
        try {
            CommonDBUtil.executeSQL(conn, "update T_operations set serial_number = '7000-500-10' where serial_number = '7000-500-10-1';");
        }
        catch (SQLException ex) {
            logger.error((Object)("Update date error" + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
    }

    private void updateOrDelete(Connection conn, Long roleId, Long optID, Long optId) {
        try {
            boolean temp = this.dataIsExist(conn, roleId, optId);
            if (!temp) {
                CommonDBUtil.executeSQL(conn, "update T_operation_r_role set opt_id=? where role_id=?", new Object[]{optId, roleId});
            } else {
                CommonDBUtil.executeSQL(conn, "delete from T_operation_r_role where opt_id=? and role_id=?", new Object[]{optID, roleId});
            }
        }
        catch (SQLException ex) {
            logger.error((Object)("Update Role Info error" + ExceptionUtil.getErrorMessage((Throwable)ex)), "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dataIsExist(Connection conn, Long roleID, Long optID) {
        ResultSet rs1 = null;
        Statement pst = null;
        try {
            pst = CommonDBUtil.executeSQLQuery(conn, "SELECT role_id,opt_id FROM T_operation_r_role WHERE role_id=? AND opt_id=?;", new Object[]{roleID, optID});
            rs1 = pst.executeQuery();
            if (rs1.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (PatchException e) {
            logger.error((Object)"select User Error!", (Throwable)e, "");
        }
        catch (SQLException e) {
            logger.error((Object)("select User Error!" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
                if (null != rs1) {
                    rs1.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)("Close Pst Error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
        return false;
    }
}

