/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.update.autoupdate;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.util.dbtool.InitSQL;
import com.huawei.drm.install.common.util.dbtool.LegoDBConnection;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.AESEncryptor;
import com.huawei.lego.common.util.SHAEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UserInfoDataHandler {
    private static final String MYSQL = "MySQL";
    private static final String SQLSERVER = "Microsoft SQL Server";
    private static final String GAUSS = "Gauss";
    private static final int INT_2 = 2;
    private static final Log LOGGER = LogFactory.getInstance(UserInfoDataHandler.class);

    public static void updateUserInfo(DataBaseInfo dbInfor) throws PatchException {
        Connection conn = null;
        Statement pst = null;
        try {
            if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
                conn = LegoDBConnection.getInstance().connectionGauss(dbInfor);
            }
            if (null == conn) {
                throw new PatchException("Database can not  connect, stop update and exit");
            }
            UserInfoDataHandler.handleDBChange(conn, dbInfor.getDbType());
        }
        catch (PatchException e) {
            LOGGER.error((Object)"drop DB error", (Throwable)e, "");
            PatchException ex = new PatchException("", e);
            throw ex;
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)("drop DB error" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    public static void handleDBChange(Connection conn, String dbType) throws PatchException {
        PreparedStatement pst1 = null;
        try {
            pst1 = InitSQL.executeSQLQuery(conn, "SELECT user_id,user_pwd FROM T_user;");
            ResultSet rs = pst1.executeQuery();
            while (rs.next()) {
                UserInfoDataHandler.updateUserInfoDb(conn, rs);
            }
        }
        catch (PatchException ep) {
            LOGGER.error((Object)"", (Throwable)ep, "");
            PatchException ex = new PatchException("", ep);
            throw ex;
        }
        catch (SQLException e) {
            LOGGER.error((Object)("handleDBChange failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            PatchException ex = new PatchException(ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
        finally {
            try {
                if (pst1 != null) {
                    pst1.close();
                }
            }
            catch (SQLException e) {
                LOGGER.error((Object)("close failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            }
        }
    }

    private static void updateUserInfoDb(Connection conn, ResultSet rs) throws PatchException {
        try {
            Long id = rs.getLong(1);
            String userpd = rs.getString(2);
            if (null != userpd && !"".equals(userpd) && AESEncryptor.encode(AESEncryptor.decode(userpd)).equals(userpd)) {
                String sh256str = SHAEncryptor.encrypt(AESEncryptor.decode(userpd));
                InitSQL.executeSQL(conn, "update T_user set user_pwd=? where user_id=?", new Object[]{sh256str, id});
            }
        }
        catch (SQLException e) {
            PatchException ex = new PatchException("updateUserInfoDb failed: " + ExceptionUtil.getErrorMessage((Throwable)e));
            throw ex;
        }
    }
}

