/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.user;

import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserManager {
    private static Log logger = LogFactory.getInstance(UserManager.class);

    public static void main(String[] args) {
        if (args.length < 1) {
            logger.error((Object)("args length is: " + args.length), "");
            SystemExitUtil.exitFail();
        }
        if (!UserManager.checkUserName(args[0])) {
            logger.error((Object)"param format is error.", "");
            SystemExitUtil.exitFail();
        }
        try {
            String cmdLine;
            String pwd = WccEncryptor.decode(LegoResourceManager.getProValue("linux.user.pwd"));
            if (!UserManager.checkStrIsNull(pwd)) {
                logger.error((Object)"get user pwd failed.", "");
                SystemExitUtil.exitFail();
            }
            if (CmdUtil.execShellCmd(cmdLine = UserManager.getCmdLine(args[0], pwd))) {
                SystemExitUtil.exitOK();
            }
        }
        catch (Exception e) {
            logger.error((Object)("create user failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        SystemExitUtil.exitFail();
    }

    private static boolean checkUserName(String userName) {
        Pattern pattern = Pattern.compile("^[a-zA-Z]{4,10}$");
        Matcher matcher = pattern.matcher(Normalizer.normalize(userName, Normalizer.Form.NFKC));
        return matcher.matches();
    }

    private static String getCmdLine(String userName, String pwd) {
        StringBuffer cmdLine = new StringBuffer();
        cmdLine.append("useradd ").append(userName).append(" -m;").append("echo ").append(userName).append(":").append(pwd).append(" | chpasswd ");
        return cmdLine.toString();
    }

    private static boolean checkStrIsNull(String str) {
        boolean isTrue = true;
        if (null == str || "".equals(str)) {
            isTrue = false;
        }
        return isTrue;
    }
}

