/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class InstallDBTool {
    private static Log logger = LogFactory.getInstance(InstallDBTool.class);
    private static final String GAUSS = "Gauss";

    public static boolean checkDbValid(DataBaseInfo dbInfor) {
        boolean isDbValid = false;
        if (GAUSS.equalsIgnoreCase(dbInfor.getDbType())) {
            isDbValid = InstallDBTool.connectionGauss(dbInfor);
        }
        return isDbValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean connectionGauss(DataBaseInfo dbDtoInfor) {
        Connection gaussConn = null;
        boolean isValid = false;
        try {
            String host = dbDtoInfor.getDbHost();
            int port = Integer.parseInt(dbDtoInfor.getDbPort());
            String user = dbDtoInfor.getDbaUsername();
            String pwd = dbDtoInfor.getDbaPassword();
            String url = "jdbc:postgresql://" + host + ":" + port + "/postgres";
            Class.forName("org.postgresql.Driver");
            gaussConn = DriverManager.getConnection(url, user, pwd);
            isValid = true;
        }
        catch (SQLException e) {
            logger.error((Object)("connection failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            boolean bl = false;
            return bl;
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("connection gauss failed: " + ExceptionUtil.getErrorMessage((Throwable)e)));
            boolean bl = false;
            return bl;
        }
        finally {
            if (gaussConn != null) {
                try {
                    gaussConn.close();
                }
                catch (SQLException e1) {
                    logger.error((Object)("DB Connection Close Error" + ExceptionUtil.getErrorMessage((Throwable)e1)), "0x000252000FB5003B");
                }
            }
        }
        return isValid;
    }
}

