/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.cli.util;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.lego.cli.dto.InstallDto;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.install.NetWorkPanel;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.ParamCheck;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class PrepareParamUtil {
    private static InstallDto sInstallDto = new InstallDto();
    private static final String FILENAME = "config/config.xml";
    private static final Log LOGGER = LogFactory.getInstance(PrepareParamUtil.class);

    public static InstallDto getsInstallDto() {
        return sInstallDto;
    }

    public static void setsInstallDto(InstallDto installsDto) {
        sInstallDto = installsDto;
    }

    public static void initEnv(String dbPwd, String managerDbaPwd) {
        LOGGER.debug((Object)"", "Auto Deploy Infor");
        File file = new File(FILENAME);
        if (file.exists()) {
            PrepareParamUtil.readCliConfig(dbPwd, managerDbaPwd, file);
            LOGGER.debug((Object)"Config.xml is not exsist!", "");
        } else {
            File legofile = new File(OSInformation.getInstalledFile());
            if (legofile.exists()) {
                PrepareParamUtil.readLegoInstallXML(dbPwd, managerDbaPwd, legofile);
            } else {
                LOGGER.error((Object)"The Install configuration file is missing, uninstall termination", "");
                PrepareParamUtil.exitFail(-1);
            }
        }
        PrepareParamUtil.checkInstallDto();
    }

    private static void checkInstallDto() {
        try {
            if (!ParamCheck.checkStrNull(sInstallDto.getInstallpath()) && ParamCheck.checkDBParam(sInstallDto.getDbDto()) && ParamCheck.checkIpAddress(sInstallDto.getNetWorkPanel().getWorkMangIp())) {
                return;
            }
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)e, "Db info check failed.");
        }
        LOGGER.error((Object)"CheckInstallDto failed.", "");
        SystemPrint.systemPrintStr(LegoResourceManager.getString("install.err.10001"));
        SystemExitUtil.exitFail();
    }

    public static NetWorkPanel getNetworkPanel(Document document) {
        try {
            String isEnable;
            if (null == document) {
                File file = new File(FILENAME);
                if (!file.exists()) {
                    throw new PatchException("getNetworkPanel failed, the config.xml not found.");
                }
                SAXReader sax = new SAXReader();
                CommonUtil.setSecurityFeatures((SAXReader)sax);
                document = sax.read(file);
            }
            Element haInfoEle = (Element)document.selectSingleNode("/install/hainfo");
            String enable = haInfoEle.attributeValue("enable");
            Element systemIpEle = (Element)document.selectSingleNode("/install/systemip");
            NetWorkPanel panel = new NetWorkPanel();
            panel.setWorkMangIp(systemIpEle.attributeValue("ipaddress"));
            panel.setWorkMangHttpPort(systemIpEle.attributeValue("systemHttpPort"));
            panel.setWorkMangHttpsPort(systemIpEle.attributeValue("systemHttpsPort"));
            boolean isEnableHA = false;
            if (!VerifyUtil.isEmpty((String)enable) && "true".equalsIgnoreCase(enable)) {
                panel.setWorkMangFloatIp(systemIpEle.attributeValue("systemFloatIp"));
                isEnableHA = true;
            }
            boolean isEnableSecond = false;
            Element secondaddress = (Element)document.selectSingleNode("/install/secondip");
            if (null != secondaddress && !VerifyUtil.isEmpty((String)(isEnable = secondaddress.attributeValue("isEnable"))) && isEnable.equalsIgnoreCase("true")) {
                isEnableSecond = true;
                panel.setSecondip(secondaddress.attributeValue("address"));
                panel.setSecondHttpsPort(secondaddress.attributeValue("secondHttpsPort"));
                panel.setSecondHttpPort(secondaddress.attributeValue("secondHttpPort"));
                if (isEnableHA) {
                    panel.setSecondFloatIp(secondaddress.attributeValue("secondfloatip"));
                }
            }
            panel.setEnableSecondIp(isEnableSecond);
            return panel;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Failed to get getNetworkPanel info, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    private static void readCliConfig(String dbPwd, String managerDbaPwd, File file) {
        SAXReader sax = new SAXReader();
        try {
            Document document = sax.read(file);
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Element osEle = (Element)document.selectSingleNode("/install/osname");
            String osName = osEle.getTextTrim();
            sInstallDto.setOsname(osName);
            LOGGER.debug((Object)("OS:" + sInstallDto.getOsname()), "");
            Element ele = (Element)document.selectSingleNode("/install/installpath");
            String path = ele.attributeValue("path");
            sInstallDto.setInstallpath(path);
            Element dbElement = (Element)document.selectSingleNode("/install/database");
            String dbType = dbElement.attributeValue("type");
            String dbhost = dbElement.attributeValue("dbhost");
            String dbport = dbElement.attributeValue("dbport");
            String dbuserName = dbElement.attributeValue("dbuserName");
            String managerdbusername = dbElement.attributeValue("managerdbusername");
            String dbfilepath = dbElement.attributeValue("dbfilepath");
            String dbpath = dbElement.attributeValue("dbpath");
            String dbpassword = dbPwd;
            DataBaseInfo dbInfor = new DataBaseInfo();
            dbInfor.setDbType(dbType);
            dbInfor.setDbHost(dbhost);
            dbInfor.setDbPort(dbport);
            dbInfor.setDbaUsername(dbuserName);
            dbInfor.setDbaPassword(dbpassword);
            dbInfor.setManagerUsername(managerdbusername);
            dbInfor.setManagerPassword(managerDbaPwd);
            dbInfor.setDbFilePath(dbfilepath);
            dbInfor.setDbPath(dbpath);
            sInstallDto.setDbDto(dbInfor);
            Element haInfoEle = (Element)document.selectSingleNode("/install/hainfo");
            String enable = haInfoEle.attributeValue("enable");
            if (null != enable && "true".equalsIgnoreCase(enable)) {
                sInstallDto.setEanbleHA(true);
            }
            sInstallDto.setNetWorkPanel(PrepareParamUtil.getNetworkPanel(document));
            List rollbackExcludeList = document.selectNodes("/install/rollback/exclude");
            for (Node element : rollbackExcludeList) {
                String exDir = element.getText();
                if (null == exDir || exDir.equals("")) continue;
                sInstallDto.getRollBackExcludeList().add(exDir);
            }
            Element ptIdEle = (Element)document.selectSingleNode("/install/platform");
            String ptId = ptIdEle.attributeValue("id");
            sInstallDto.setPlatformId(ptId);
            LOGGER.debug((Object)("PT BUNDLE:" + sInstallDto.getPlatformId()), "");
            List pdElementList = document.selectNodes("/install/product");
            ArrayList<String> productList = new ArrayList<String>();
            for (Node element : pdElementList) {
                String productId = ((Element)element).attributeValue("id");
                productList.add(productId);
            }
            sInstallDto.setProductList(productList);
            List extendElementList = document.selectNodes("/install/extend/class");
            ArrayList<String> extendClzs = new ArrayList<String>();
            if (null != extendElementList && !extendElementList.isEmpty()) {
                for (Node element : extendElementList) {
                    String extendClzName = ((Element)element).attributeValue("cardclass");
                    extendClzs.add(extendClzName);
                }
                sInstallDto.setProductExtendClzList(extendClzs);
            }
            LOGGER.debug((Object)"", "Param End");
        }
        catch (DocumentException | SAXException e1) {
            LOGGER.error((Object)e1, "Read xml failed.");
        }
    }

    private static void readLegoInstallXML(String dbPwd, String managerPwd, File file) {
        SAXReader sax = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            InstalledSystem system = InitInstalledXmlTool.getInstalledSystem();
            sInstallDto.setOsname("Linux");
            sInstallDto.setInstallpath(system.getInstallpath());
            sInstallDto.setDbDto(system.getDbInfor());
            sInstallDto.setNetWorkPanel(system.getNetWorkPanel());
            Document document = sax.read(file);
            List rollbackExcludeList = document.selectNodes("/install/rollback/exclude");
            for (Node element : rollbackExcludeList) {
                String exDir = element.getText();
                if (null == exDir || exDir.equals("")) continue;
                sInstallDto.getRollBackExcludeList().add(exDir);
            }
            Element ptIdEle = (Element)document.selectSingleNode("/install/platform");
            String ptId = ptIdEle.attributeValue("id");
            sInstallDto.setPlatformId(ptId);
            List pdEleList = document.selectNodes("/install/product");
            ArrayList<String> productList = new ArrayList<String>();
            for (Node element : pdEleList) {
                String productId = ((Element)element).attributeValue("id");
                productList.add(productId);
            }
            sInstallDto.setProductList(productList);
            List pdExtendEleList = document.selectNodes("/install/extend/class");
            ArrayList<String> extendClzs = new ArrayList<String>();
            if (null != pdExtendEleList && !pdExtendEleList.isEmpty()) {
                for (Node element : pdExtendEleList) {
                    String extendClzName = ((Element)element).attributeValue("cardclass");
                    extendClzs.add(extendClzName);
                }
                sInstallDto.setProductExtendClzList(extendClzs);
            }
        }
        catch (DocumentException | SAXException e) {
            LOGGER.error((Object)e, "Read xml failed.");
        }
    }

    private static NetWorkPanel getNetWorkInfo(Document document) {
        NetWorkPanel panel = new NetWorkPanel();
        Element systemIpEle = (Element)document.selectSingleNode("/install/httpsip");
        panel.setWorkMangIp(systemIpEle.getTextTrim());
        Element httpEle = (Element)document.selectSingleNode("/install/httport");
        panel.setWorkMangHttpPort(httpEle.getTextTrim());
        Element httpsEle = (Element)document.selectSingleNode("/install/httpsport");
        panel.setWorkMangHttpsPort(httpsEle.getTextTrim());
        Element floatIp = (Element)document.selectSingleNode("/install/floatip");
        if (null != floatIp) {
            panel.setWorkMangFloatIp(floatIp.getTextTrim());
        }
        return panel;
    }

    public static void exitFail(int status) {
        System.exit(status);
    }
}

