/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common;

import com.huawei.lego.common.InstallConstant;
import com.huawei.lego.common.dto.Disk;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.dto.SystemInfor;
import com.huawei.lego.common.memory.LinuxSystemTool;
import com.huawei.lego.common.memory.WindowsGetMem;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.disk.DiskResouceUse;
import com.huawei.lego.common.util.disk.LinuxDiskUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class Singleton {
    private static final Singleton INSTANCE = new Singleton();
    private static final Log logger = LogFactory.getInstance(Singleton.class);
    private static String basePath = Singleton.getAbsPath();
    private static String softWareName = LegoResourceManager.getProValue("software.install.name");
    private SystemInfor systemInfor;
    private List<String> movedFileList = new ArrayList<String>();
    private boolean renameInstallFile = false;
    private InstalledSystem system = new InstalledSystem();

    private Singleton() {
        this.initSystemInfor();
    }

    public static String getBasePath() {
        return basePath;
    }

    public static String getSoftWareName() {
        return softWareName;
    }

    public static String getAbsPath() {
        String jarPath = Singleton.class.getProtectionDomain().getCodeSource().getLocation().toString();
        try {
            jarPath = URLDecoder.decode(jarPath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e, "decode error :" + e.getMessage());
        }
        String bath = "";
        if (-1 != jarPath.indexOf(":") && null != System.getProperty("os.name") && System.getProperty("os.name").contains("Windows")) {
            bath = jarPath.substring(jarPath.indexOf("/") + 1, jarPath.lastIndexOf("/"));
            bath = bath.substring(0, bath.lastIndexOf("/") + 1);
        } else {
            bath = jarPath.substring(jarPath.indexOf("/"), jarPath.lastIndexOf("/"));
            bath = bath.substring(0, bath.lastIndexOf("/") + 1);
        }
        return bath;
    }

    public static void recoveryInstallFile() {
        if (Singleton.getInstance().isRenameInstallFile()) {
            String installedFile = OSInformation.getInstalledFile();
            File file = new File(installedFile);
            if (file.exists()) {
                String installedFileLego = OSInformation.getUserHomePath() + "/legoInstalled.xml";
                file.renameTo(new File(installedFileLego));
            } else {
                String installedFileroot = OSInformation.getCurrentUserHomePaht() + "/" + LegoResourceManager.getProValue("install.params.installed.file");
                File fileroot = new File(installedFileroot);
                if (fileroot.exists()) {
                    String installedFileLegoroot = OSInformation.getCurrentUserHomePaht() + "/legoInstalled.xml";
                    fileroot.renameTo(new File(installedFileLegoroot));
                }
            }
        }
        if (OSInformation.isWindows()) {
            String userPath = System.getProperty("user.home");
            for (String name : Singleton.getInstance().getMovedFileList()) {
                File srcFile = new File(OSInformation.getUserHomePath() + File.separator + name);
                File destFile = new File(userPath + File.separator + name);
                logger.info((Object)("start recovery " + srcFile.getName() + ", result=" + srcFile.renameTo(destFile)), "");
            }
        }
    }

    private void initSystemInfor() {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.US);
        formatter.applyPattern("0.00");
        this.systemInfor = new SystemInfor();
        Properties props = System.getProperties();
        String strOS = props.getProperty("os.name");
        String srtOSVersion = props.getProperty("os.version");
        this.systemInfor.setOsName(strOS + " " + srtOSVersion);
        long gb = 0x100000L;
        double totalMemorySize = 0.0;
        totalMemorySize = strOS.contains("Windows") ? (double)WindowsGetMem.getTotalMemInfo() : (double)LinuxSystemTool.getTotalMemInfo();
        String totoMemory = formatter.format(totalMemorySize / (double)gb);
        try {
            this.systemInfor.setMemory(formatter.parse(totoMemory).toString());
        }
        catch (ParseException e) {
            logger.error((Object)e, "0x000252000FB50006");
        }
        ArrayList<Disk> tmpDisks = new ArrayList<Disk>();
        List<DiskResouceUse> disks = LinuxDiskUtil.getDisk();
        for (DiskResouceUse diskResouceUse : disks) {
            Disk diskObj = new Disk();
            diskObj.setDiskName(diskResouceUse.getDiskName().replaceAll("G", ""));
            diskObj.setDiskSize(diskResouceUse.getTotal().replaceAll("G", ""));
            diskObj.setDiskFreeSize(diskResouceUse.getAvail().replaceAll("G", ""));
            tmpDisks.add(diskObj);
        }
        this.systemInfor.setDisks(tmpDisks);
    }

    public SystemInfor getSystemInfor() {
        return this.systemInfor;
    }

    public List<String> getMovedFileList() {
        return this.movedFileList;
    }

    public boolean isRenameInstallFile() {
        return this.renameInstallFile;
    }

    public void setRenameInstallFile(boolean renameInstallFile) {
        this.renameInstallFile = renameInstallFile;
    }

    public InstalledSystem getSystem() {
        return this.system;
    }

    public static Singleton getInstance() {
        return INSTANCE;
    }

    static {
        InstallConstant.setsBasePath(basePath);
        File logDir = new File(basePath + "logs");
        boolean canWrite = false;
        if (logDir.exists()) {
            SecureRandom random = new SecureRandom();
            String tmpFileName = basePath + "logs/" + random.nextLong() + "_tmp.txt";
            File tmpFile = new File(tmpFileName);
            try {
                boolean succTmp1 = tmpFile.createNewFile();
                boolean succTmp2 = tmpFile.delete();
                canWrite = succTmp1 && succTmp2;
            }
            catch (IOException e) {
                canWrite = false;
                logger.error((Object)("exception: " + canWrite), "");
            }
        } else {
            canWrite = logDir.mkdir();
        }
        if (canWrite) {
            logger.info((Object)"can write.", "");
            System.setProperty("LEGO.INSTALL.LOGDIR", basePath);
        } else {
            logger.info((Object)"can not write.", "");
            System.setProperty("LEGO.INSTALL.LOGDIR", OSInformation.getUserHomePath());
        }
    }
}

