/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.certs.PrivateKey;
import com.huawei.lego.common.certs.TaskExcuter;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ChangePrivateKeyPwd {
    private static final String CMD_RESULT = "cmdResult";
    private static final String EXCEPT_RESULT = "exceptResult";
    private static final String BACKEND = "backend";
    private static final String TOMCAT = "tomcat";
    private static final String CHECK_COMPLEX = "check";
    private static Log logger = LogFactory.getInstance(ChangePrivateKeyPwd.class);

    public static void main(String[] args) {
        ChangePrivateKeyPwd.checkParam(args);
        logger.info((Object)("start change type=" + args[0]), "");
        try {
            PrivateKey key = new PrivateKey();
            ChangePrivateKeyPwd.initEnvironment(key, args[0]);
            ChangePrivateKeyPwd.initAliasNameAndOldPwd(key);
            ChangePrivateKeyPwd.initPrivateKeyPwd(key);
            if (key.isUpdateTomcatPrivateKey()) {
                logger.info((Object)"start update server.xml keyPass.", "");
                ChangePrivateKeyPwd.updateServerXML(key.getNewKeyPwd());
            }
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.PWD.UPDATE.SUCC"));
        }
        catch (Exception e) {
            logger.error((Object)"ChangePrivateKeyPwd failed.", "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.TRY.LATER"));
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static void updateServerXML(String keyPwd) {
        String installPath = InitInstalledXmlTool.getInstallPath();
        String serverXml = installPath + File.separator + LegoResourceManager.getProValue("install.tomcat.conf.file.path");
        File xml = new File(serverXml);
        if (!xml.exists()) {
            logger.error((Object)"can not find the file server.xml or http port is null, not changed, return.", "");
            throw new PatchException("updateServerXML failed.");
        }
        FileOutputStream fout = null;
        XMLWriter writer = null;
        SAXReader reader = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                Attribute keyStorePass = ((Element)ele).attribute("keystorePass");
                if (null == keyStore || null == keyStorePass) continue;
                ((Element)ele).addAttribute("keyPass", WccEncryptor.encode(keyPwd));
                break;
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fout = new FileOutputStream(new File(serverXml));
            writer = new XMLWriter((OutputStream)fout, format);
            writer.write(document);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("update server.xml failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("update server.xml failed.");
            }
            catch (Throwable throwable) {
                ChangePrivateKeyPwd.closeStream(fout);
                ChangePrivateKeyPwd.closeXmlWriter(writer);
                throw throwable;
            }
        }
        ChangePrivateKeyPwd.closeStream(fout);
        ChangePrivateKeyPwd.closeXmlWriter(writer);
    }

    private static void closeXmlWriter(XMLWriter writer) {
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)e, "close xml writer failed.");
            }
        }
    }

    private static void closeStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, "close stream failed.");
            }
        }
    }

    private static void checkParam(String[] args) {
        if (args.length < 1) {
            logger.error((Object)"change private key pwd failed, args is error.", "");
            SystemExitUtil.exitFail();
        }
        if (args.length == 2 && CHECK_COMPLEX.equalsIgnoreCase(args[0])) {
            if (ChangePrivateKeyPwd.checkPasswordComplex(args[1])) {
                SystemExitUtil.exitOK();
            } else {
                SystemExitUtil.exitFail();
            }
        }
        if (!(BACKEND.equalsIgnoreCase(args[0]) || TOMCAT.equalsIgnoreCase(args[0]) || CHECK_COMPLEX.equalsIgnoreCase(args[0]))) {
            logger.error((Object)("change private key pwd failed, param=" + args[0]), "");
            SystemExitUtil.exitFail();
        }
    }

    private static void initEnvironment(PrivateKey key, String type) {
        Object file;
        String keystore;
        String sp = File.separator;
        String installPath = InitInstalledXmlTool.getInstallPath();
        key.setType(type);
        if (key.isBackend()) {
            keystore = installPath + sp + "Runtime" + sp + LegoResourceManager.getProValue("install.platform.keystore");
        } else {
            file = ChangePrivateKeyPwd.getTomcatKeyStore(installPath);
            logger.info((Object)("getTomcatKeyStore=" + (String)file), "");
            keystore = installPath + sp + "Runtime" + sp + "Tomcat6" + sp + (String)file;
        }
        file = new File(keystore);
        if (!((File)file).exists()) {
            logger.error((Object)"initEnvironment failed, keystore is not found.", "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.FILE.NOT.FOUND"));
            throw new PatchException("initEnvironment failed");
        }
        key.setKeyStore(keystore);
    }

    private static String getTomcatKeyStore(String installPath) {
        String value = "";
        try {
            String filePath = installPath + File.separator + LegoResourceManager.getProValue("install.tomcat.conf.file.path");
            File file = new File(filePath);
            if (!file.exists()) {
                logger.error((Object)"getTomcatKeyStore failed, can not find the server.xml.", "");
                throw new PatchException("server.xml is not exists.");
            }
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(new File(filePath));
            List connectorEles = document.selectNodes("/Server/Service/Connector");
            for (Node element : connectorEles) {
                Attribute keystoreFile = ((Element)element).attribute("keystoreFile");
                Attribute keystorePass = ((Element)element).attribute("keystorePass");
                if (keystoreFile == null || keystorePass == null) continue;
                value = keystoreFile.getStringValue();
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("getTomcatKeyStore failed, errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
        return value;
    }

    private static void initAliasNameAndOldPwd(PrivateKey key) {
        String alias;
        int iCount = 0;
        String password = "";
        for (iCount = 0; iCount <= 3; ++iCount) {
            if (iCount == 3) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.PWD.INPUT.TIMES.LIMIT"));
                throw new PatchException("password error time is more than 3 times.");
            }
            password = new String(System.console().readPassword("Please input Keystore password: ", new Object[0]));
            key.setKeyStorePwd(password);
            if (ChangePrivateKeyPwd.checkKeyStoreOldPwd(key, false)) break;
            logger.error((Object)"the keystore pwd is error. ", "");
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.KEYSTORE.PWD.ERR"));
        }
        String aliasName = VerifyUtil.isEmpty((String)(alias = System.console().readLine("Enter the alias name of the private key.[bcmrootca]: ", new Object[0]))) ? "bcmrootca" : alias;
        key.setAliasName(aliasName);
        if (aliasName.length() >= 100 || !ChangePrivateKeyPwd.checkKeyStoreOldPwd(key, true)) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.ALIAS.NOT.FOUND", aliasName));
            throw new PatchException("alias name is not exists, name=" + aliasName + ", size=" + aliasName.length());
        }
        key.setAliasName(aliasName);
    }

    private static void initPrivateKeyPwd(PrivateKey privateKey) {
        int iCount = 0;
        String oldPwd = "";
        String newPwd = "";
        for (iCount = 0; iCount <= 3; ++iCount) {
            boolean updateResult;
            if (iCount == 3) {
                SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.PWD.INPUT.TIMES.LIMIT"));
                throw new PatchException("password error time is more than 3 times.");
            }
            oldPwd = new String(System.console().readPassword("Enter the old password of the private key: ", new Object[0]));
            privateKey.setOldKeyPwd(oldPwd);
            int tmp = 0;
            for (tmp = 0; tmp <= 3; ++tmp) {
                if (tmp == 3) {
                    SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.PWD.INPUT.TIMES.LIMIT"));
                    throw new PatchException("password error time is more than 3 times.");
                }
                newPwd = new String(System.console().readPassword("Enter the new password of the private key: ", new Object[0]));
                if (!ChangePrivateKeyPwd.checkPasswordComplex(newPwd)) {
                    SystemPrint.systemPrintStr(LegoResourceManager.getString("LEGO.KEYSTORE.PASSWORD.COMPLEX.CHECK"));
                    continue;
                }
                if (newPwd.equals(oldPwd)) {
                    SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.OLDPW.NEWPD.SAME"));
                    continue;
                }
                String confirmPwd = new String(System.console().readPassword("Re-enter the new password of the private key: ", new Object[0]));
                if (!newPwd.equals(confirmPwd)) {
                    SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.OLD.NEW.PASSWORD.SAME"));
                    continue;
                }
                privateKey.setNewKeyPwd(newPwd);
                break;
            }
            if (!(updateResult = ChangePrivateKeyPwd.updatePrivateKeyPwd(privateKey))) continue;
            logger.info((Object)"update password successfully.", "");
            return;
        }
    }

    private static boolean updatePrivateKeyPwd(PrivateKey privateKey) {
        String sp = File.separator;
        String installPath = InitInstalledXmlTool.getInstallPath();
        String runtimePath = installPath + sp + "Runtime" + sp + "jre6.0.18" + sp + "bin" + sp + "keytool";
        if (OSInformation.isWindows()) {
            runtimePath = runtimePath + ".exe";
        }
        File keyTool = new File(runtimePath);
        File keyStore = new File(privateKey.getKeyStore());
        if (!keyTool.exists() || !keyStore.exists()) {
            logger.error((Object)"updatePrivateKeyPwd failed, keytool or keystore is not exists.", "");
            return false;
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(runtimePath);
        cmd.append(" -keypasswd -alias ");
        cmd.append(privateKey.getAliasName());
        cmd.append(" -keystore ");
        cmd.append(privateKey.getKeyStore());
        String[] results = new String[]{"Cannot", "recover", "key"};
        Map<String, Boolean> result = ChangePrivateKeyPwd.execCmd(cmd.toString(), new String[]{privateKey.getKeyStorePwd(), privateKey.getOldKeyPwd(), privateKey.getNewKeyPwd(), privateKey.getNewKeyPwd()}, results);
        if (result.get(CMD_RESULT).booleanValue()) {
            return true;
        }
        if (result.get(EXCEPT_RESULT).booleanValue()) {
            SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.KEY.OLD.PWD.ERROR"));
            return false;
        }
        SystemPrint.systemPrintStr(LegoResourceManager.getString("CERT.PWD.UPDATE.OTHER.ERROR"));
        return false;
    }

    private static boolean checkKeyStoreOldPwd(PrivateKey privateKey, boolean isCheckAlias) {
        String sp = File.separator;
        String installPath = InitInstalledXmlTool.getInstallPath();
        String runtimePath = installPath + sp + "Runtime" + sp + "jre6.0.18" + sp + "bin" + sp + "keytool";
        File keyTool = new File(runtimePath);
        File keyStore = new File(privateKey.getKeyStore());
        if (!keyTool.exists() || !keyStore.exists()) {
            logger.error((Object)"checkKeyStoreOldpwd failed, keytool or keystore is not exists.", "");
            return false;
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(runtimePath);
        cmd.append(" -list ");
        cmd.append("-v ");
        cmd.append("-keystore ");
        cmd.append(privateKey.getKeyStore());
        if (isCheckAlias) {
            cmd.append(" -alias ");
            cmd.append(privateKey.getAliasName());
        }
        Map<String, Boolean> result = ChangePrivateKeyPwd.execCmd(cmd.toString(), new String[]{privateKey.getKeyStorePwd()}, new String[0]);
        return result.get(CMD_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Boolean> execCmd(String cmd, String[] params, String[] results) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean expectResult = false;
        boolean cmdResult = false;
        Process ps = null;
        try {
            ps = Runtime.getRuntime().exec(cmd);
            BufferedWriter outputBW = new BufferedWriter(new OutputStreamWriter(ps.getOutputStream(), StandardCharsets.UTF_8));
            for (String param : params) {
                outputBW.write(param);
                outputBW.newLine();
            }
            outputBW.flush();
            InputStreamReader input = new InputStreamReader(ps.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader inputBr = new BufferedReader(input);
            CountDownLatch done = new CountDownLatch(2);
            ExecutorService pool = Executors.newFixedThreadPool(2);
            Future<Boolean> futureInfo = pool.submit(new TaskExcuter(inputBr, results, done));
            InputStreamReader err = new InputStreamReader(ps.getErrorStream(), StandardCharsets.UTF_8);
            BufferedReader errBr = new BufferedReader(err);
            Future<Boolean> futureError = pool.submit(new TaskExcuter(errBr, results, done));
            ChangePrivateKeyPwd.waitAllProcessorComplete(done);
            if (ChangePrivateKeyPwd.getResult(futureInfo) || ChangePrivateKeyPwd.getResult(futureError)) {
                logger.error((Object)"get the expect result successfully.", "");
                expectResult = true;
            }
            if (ps.waitFor() == 0) {
                logger.error((Object)"get the cmd exec result successfully.", "");
                cmdResult = true;
            }
        }
        catch (Exception e) {
            logger.error((Object)"exec failed", ExceptionUtil.getErrorMessage((Throwable)e));
        }
        finally {
            if (null != ps) {
                ps.destroy();
            }
        }
        result.put(EXCEPT_RESULT, expectResult);
        result.put(CMD_RESULT, cmdResult);
        return result;
    }

    private static boolean getResult(Future<Boolean> result) {
        Boolean actionResult;
        try {
            actionResult = result.get();
        }
        catch (Exception e) {
            logger.error((Object)"get result failed.", "");
            actionResult = false;
        }
        return actionResult;
    }

    private static boolean waitAllProcessorComplete(CountDownLatch completedSignal) {
        try {
            boolean inTime = completedSignal.await(2L, TimeUnit.MINUTES);
            if (!inTime) {
                logger.error((Object)"WaitAllProcessorComplete overTime.", "");
            }
            return inTime;
        }
        catch (InterruptedException e) {
            logger.error((Object)"WaitAllProcessorComplete failed.", (Throwable)e, "");
            return false;
        }
    }

    private static boolean checkPasswordComplex(String pwd) {
        String excludeRegex = "[`'\"\\^&\\(\\)\\|<>\\s]";
        String numberLowerLetterRegex = "(?=.*\\d)(?=.*[a-z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        String numberUpperLetterRegex = "(?=.*\\d)(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        String lowerUpperLetterRegex = "(?=.*[a-z])(?=.*[A-Z])(?=.*[~!@#\\$%\\^&\\*\\(\\)\\-_=+\\\\|\\[{}\\];:,<.>/?]).{8,18}";
        Pattern pattern = Pattern.compile(excludeRegex);
        Matcher match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.find()) {
            return false;
        }
        pattern = Pattern.compile(numberLowerLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(numberUpperLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        if (match.matches()) {
            return true;
        }
        pattern = Pattern.compile(lowerUpperLetterRegex);
        match = pattern.matcher(Normalizer.normalize(pwd, Normalizer.Form.NFKC));
        return match.matches();
    }

    public static void updateKeyPwd(PrivateKey privateKey) {
        String sp = File.separator;
        String installPath = InitInstalledXmlTool.getInstallPath();
        String runtimePath = installPath + sp + "Runtime" + sp + "jre6.0.18" + sp + "bin" + sp + "keytool";
        if (OSInformation.isWindows()) {
            runtimePath = runtimePath + ".exe";
        }
        File keyTool = new File(runtimePath);
        File keyStore = new File(privateKey.getKeyStore());
        if (!keyTool.exists() || !keyStore.exists()) {
            logger.error((Object)"updateKeyPwd failed, keytool or keystore is not exists.", "");
            throw new PatchException("updateKeyPwd failed.");
        }
        StringBuilder cmd = new StringBuilder();
        cmd.append(runtimePath);
        cmd.append(" -keypasswd -alias ");
        cmd.append(privateKey.getAliasName());
        cmd.append(" -keystore ");
        cmd.append(privateKey.getKeyStore());
        Map<String, Boolean> result = ChangePrivateKeyPwd.execCmd(cmd.toString(), new String[]{privateKey.getKeyStorePwd(), privateKey.getOldKeyPwd(), privateKey.getNewKeyPwd(), privateKey.getNewKeyPwd()}, new String[0]);
        if (!result.get(CMD_RESULT).booleanValue()) {
            logger.error((Object)"updateKeyPwd failed, cmd run failed.", "");
            throw new PatchException("updateKeyPwd failed.");
        }
    }
}

