/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.certs.mapping.CertFileNameMapping;
import com.huawei.lego.common.certs.mapping.KeyStoreNamingMapping;
import com.huawei.lego.core.sdk.util.TextEditor;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Component {
    private static final Log logger = LogFactory.getInstance(Component.class);
    private String name;
    private String home;
    private String baseLocation;
    private String configuration;
    private String certLocation;
    private List<String> certFileList;
    private CertFileNameMapping certFileNameMapping;
    private TextEditor editor;

    private Component() {
    }

    public String getName() {
        return this.name;
    }

    public String getHome() {
        return this.home;
    }

    public String getBaseLocation() {
        return this.baseLocation;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getCertLocation() {
        return this.certLocation;
    }

    public List<String> getCertFileList() {
        return this.certFileList;
    }

    public CertFileNameMapping getCertFileNameMapping() {
        return this.certFileNameMapping;
    }

    public String getCertFilePath(String certFile) {
        return Paths.get(this.certLocation, new String[0]).resolve(Paths.get(certFile, new String[0]).getFileName()).toString();
    }

    public TextEditor getEditor() {
        return this.editor;
    }

    public static Component create(String component, String baseLocation, String configuration, String certFileFilter, Function<Component, CertFileNameMapping> certFileNameMapping, TextEditor editor) {
        String certLocation;
        String installPath = CertificateUtil.getInstallPath();
        Component certInfo = new Component();
        certInfo.name = component;
        certInfo.home = installPath;
        certInfo.baseLocation = Paths.get(installPath, baseLocation).toString();
        certInfo.configuration = Paths.get(certInfo.baseLocation, configuration).toString();
        String[] parts = Component.split(certFileFilter);
        certInfo.certLocation = certLocation = Paths.get(certInfo.baseLocation, parts[0]).toString();
        certInfo.certFileList = parts[1].contains("*") ? Component.find(certInfo.certLocation, parts[1]) : Collections.singletonList(Paths.get(certInfo.certLocation, parts[1]).toString());
        certInfo.certFileNameMapping = certFileNameMapping.apply(certInfo);
        certInfo.editor = editor;
        return certInfo;
    }

    private static String[] split(String filter) {
        String expr;
        String base;
        int i = filter.indexOf(42);
        int j = i >= 0 ? filter.lastIndexOf(47, i) : filter.lastIndexOf(47);
        if (j == -1) {
            base = "";
            expr = filter;
        } else {
            base = filter.substring(0, j);
            expr = filter.substring(j + 1);
        }
        String path = base.length() > 0 ? base : "./";
        return new String[]{path, expr};
    }

    private static List<String> find(String base, String filter) {
        Path path = Paths.get(base, new String[0]);
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + filter);
        File[] items = path.toFile().listFiles(file -> matcher.matches(file.toPath().getFileName()));
        File[] files = items != null ? items : new File[]{};
        return Stream.of(files).map(file -> path.resolve(file.getName()).toString()).collect(Collectors.toList());
    }

    public static Component nodeAgent() {
        return Component.create("NodeAgent", "Runtime/NodeAgent", "conf/nodeAgent-pwd.properties", "certs/*.keystore", KeyStoreNamingMapping::new, TextEditor.template((String)"((^|[\\r\\n])(%s=))(?<value>[^\\r\\n]*)([\\r\\n]|$)", (String)"$1%s\n"));
    }

    public static Component webServer() {
        return Component.create("WebServer", "Runtime/Tomcat6", "conf/server.xml", "certs/*.keystore", KeyStoreNamingMapping::new, TextEditor.template((String)"(\\s+%s=\")(?<value>[^\"]+)(\"\\s*)", (String)"$1%s$3"));
    }
}

