/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.certs.CertificateUtil;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ExportServiceCert {
    private static final String SP = File.separator;
    private static final String TOMCAT_CERT = "WebServer.cert";
    private static final String NODEAGENT_CERT = "NodeAgent.cert";
    private static Log logger = LogFactory.getInstance(ExportServiceCert.class);
    private String installPath = InitInstalledXmlTool.getInstallPath();
    private String certPath = this.installPath + SP + "Runtime" + SP + "LegoRuntime" + SP + "certs" + SP + "components";

    public ExportServiceCert() {
        File path = new File(this.certPath);
        if (!path.exists() && !path.mkdirs()) {
            throw new PatchException("ExportServiceCert failed, create components path failed.");
        }
    }

    public void exportTomcatCert() {
        logger.info((Object)"start export Tomcat cert.", "");
        String serverXml = this.installPath + SP + LegoResourceManager.getProValue("install.tomcat.conf.file.path");
        File xml = new File(serverXml);
        if (!xml.exists()) {
            logger.error((Object)"can not find the file server.xml.", "");
            throw new PatchException("updateServerXML failed.");
        }
        SAXReader reader = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                Attribute keyStore = ((Element)ele).attribute("keystoreFile");
                Attribute keyStorePass = ((Element)ele).attribute("keystorePass");
                Attribute keyStoreType = ((Element)ele).attribute("keystoreType");
                if (null == keyStore || null == keyStorePass || null == keyStoreType) continue;
                logger.info((Object)"find the value, start export cert file.", "");
                String keystorFile = this.installPath + SP + LegoResourceManager.getProValue("install.lego_version.frontend.war") + SP + keyStore.getValue();
                CertificateUtil certObj = new CertificateUtil(keystorFile, WccEncryptor.decode(keyStorePass.getValue()), keyStoreType.getValue());
                certObj.exportCertsToFile(this.certPath, TOMCAT_CERT);
                logger.info((Object)"export tomcat cert successfully.", "");
                break;
            }
        }
        catch (Exception e) {
            logger.error((Object)("exportTomcatCert failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("exportTomcatCert failed.");
        }
    }

    public void exportNodeAgentCert() {
        logger.info((Object)"start export nodeagent cert.", "");
        String nodeagentHome = this.installPath + SP + "Runtime" + SP + "NodeAgent";
        String configFile = nodeagentHome + SP + "conf" + SP + "nodeAgent-pwd.properties";
        File file = new File(configFile);
        if (!file.exists()) {
            throw new PatchException("exportNodeAgentCert failed, config file not found.");
        }
        Properties prop = new Properties();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            prop.load(inputStream);
            String keystorePass = WccEncryptor.decode(prop.getProperty("keystorePass"));
            String keystoreFile = prop.getProperty("keystorePath");
            CertificateUtil certObj = new CertificateUtil(nodeagentHome + SP + keystoreFile, keystorePass, "JKS");
            certObj.exportCertsToFile(this.certPath, NODEAGENT_CERT);
            logger.info((Object)"export nodeagent cert successfully.", "");
        }
        catch (Exception e) {
            throw new PatchException("Failed to export node agent cert. errMsg=" + ExceptionUtil.getErrorMessage((Throwable)e));
        }
    }

    public void exportKeyStoreCert() {
        this.exportTomcatCert();
        this.exportNodeAgentCert();
    }
}

