/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs;

import com.huawei.lego.common.exception.InstallException;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.CmdUtil;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.common.util.WccEncryptor;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ReplaceKeyStore {
    private static Log logger = LogFactory.getInstance(ReplaceKeyStore.class);
    private static String installPath = "";
    private static String oldKeyStore = "";
    private static final String JKS = "JKS";
    private static final String PKCS = "PKCS12";
    private static final String JCEKS = "JCEKS";

    public static void main(String[] args) {
        if (args.length < 3) {
            logger.error((Object)"the param is error.", "");
            SystemExitUtil.exitFail();
        }
        ReplaceKeyStore.initSystemInfo();
        String keyTool = args[0];
        String keyStore = args[1];
        String keyStoreType = args[2];
        ReplaceKeyStore.checkParam(keyTool, keyStore, keyStoreType);
        try {
            File file = new File(keyStore);
            String keyPass = ReplaceKeyStore.getKeyStorePwd(keyTool, keyStore, keyStoreType);
            ReplaceKeyStore.modifyKeyStore(file, keyPass, keyStoreType);
        }
        catch (Exception e) {
            logger.error((Object)("replace keystorey failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            SystemExitUtil.exitFail();
        }
        SystemExitUtil.exitOK();
    }

    private static void initSystemInfo() {
        try {
            installPath = InitInstalledXmlTool.getInstalledSystem().getInstallpath();
        }
        catch (InstallException e) {
            SystemPrint.systemPrintStr(e.getErrorMsg());
            SystemExitUtil.exitFail();
        }
    }

    private static void checkParam(String keyTool, String keyStore, String keyType) {
        if (!new File(keyStore).exists() || !new File(keyTool).exists()) {
            logger.error((Object)"the keystore file or keytool is not exists.", "");
            SystemExitUtil.exitFail();
        }
        if (!(JKS.equalsIgnoreCase(keyType) || PKCS.equalsIgnoreCase(keyType) || JCEKS.equalsIgnoreCase(keyType))) {
            logger.error((Object)("the keystore type is error:" + keyType), "");
            SystemExitUtil.exitFail();
        }
    }

    private static void modifyKeyStore(File keyStore, String pwd, String keyStoreType) throws Exception {
        try {
            String path = keyStore.getCanonicalPath();
            String fileName = keyStore.getName();
            String tomcatCertsPath = installPath + "/Runtime/Tomcat6/certs";
            ReplaceKeyStore.isSureReplace();
            FileUtil.copyFile(path, tomcatCertsPath + File.separator + fileName);
            ReplaceKeyStore.modifyXML(fileName, pwd, keyStoreType);
            String oldFile = installPath + "/Runtime/Tomcat6/" + oldKeyStore;
            File file = new File(oldFile);
            if (!"".equals(oldKeyStore) && file.exists() && !file.getName().equals(fileName)) {
                boolean succ = file.delete();
                logger.info((Object)("need clean old keystore, clean result: " + succ), "");
            }
        }
        catch (Exception e) {
            logger.error((Object)("Exception happend in modifyKeyStore: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("modifyKeyStore failed.");
        }
    }

    private static void isSureReplace() {
        String msg = "You are going to change the certfile of web, Are you sure you really want to perform the operation? (y/n):";
        String isTrue = System.console().readLine(msg, new Object[0]);
        if ("y".equalsIgnoreCase(isTrue)) {
            return;
        }
        logger.info((Object)"user canceled modify keystore.", "");
        SystemExitUtil.exitFail();
    }

    private static void modifyXML(String fileName, String password, String storeType) throws Exception {
        XMLWriter writer2 = null;
        FileOutputStream fos = null;
        try {
            String filePath = installPath + File.separator + LegoResourceManager.getProValue("install.tomcat.conf.file.path");
            File file = new File(filePath);
            if (!file.exists()) {
                throw new FileNotFoundException("server.xml is not exists.");
            }
            SAXReader reader = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(new File(filePath));
            List connectorEles = document.selectNodes("/Server/Service/Connector");
            for (Node element : connectorEles) {
                String protocol = ((Element)element).attributeValue("protocol");
                Attribute keystoreFile = ((Element)element).attribute("keystoreFile");
                Attribute keystorePass = ((Element)element).attribute("keystorePass");
                if (protocol != null && protocol.contains("com.huawei.lego.tomcat.http.LegoHttp11Protocol") && keystoreFile != null && keystorePass != null) {
                    oldKeyStore = keystoreFile.getValue();
                    ((Element)element).addAttribute("keystorePass", WccEncryptor.encode(password));
                    ((Element)element).addAttribute("keystoreFile", "certs/" + fileName);
                    ((Element)element).addAttribute("keystoreType", storeType);
                }
                Attribute sslcertsFile = ((Element)element).attribute("SSLCertificateFile");
                if (protocol == null || !protocol.contains("com.huawei.lego.tomcat.http.LegoHttp11Protocol") || keystoreFile == null || keystorePass == null || sslcertsFile == null) continue;
                ((Element)element).addAttribute("SSLCertificateFile", "certs/" + fileName);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            fos = new FileOutputStream(new File(filePath));
            writer2 = new XMLWriter((OutputStream)fos, format);
            writer2.write(document);
        }
        catch (Exception e) {
            try {
                logger.error((Object)("modify server.xml failed, replace keystore failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                throw new PatchException("modifyXML failed.");
            }
            catch (Throwable throwable) {
                ReplaceKeyStore.releaseXmlWriter(writer2);
                FileUtil.close(fos, "close fos ");
                throw throwable;
            }
        }
        ReplaceKeyStore.releaseXmlWriter(writer2);
        FileUtil.close(fos, "close fos ");
    }

    private static void releaseXmlWriter(XMLWriter stream) {
        if (null != stream) {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)e, "close xml writer failed.");
            }
        }
    }

    private static String getKeyStorePwd(String keytool, String keystore, String keystoreType) {
        char[] pwd = null;
        while (!ReplaceKeyStore.checkKeyStoreOldpwd(keytool, keystore, keystoreType, new String(pwd = System.console().readPassword("Please input secret key: ", new Object[0])))) {
            SystemPrint.systemPrintStr("Certificate password error.");
        }
        return new String(pwd);
    }

    private static boolean checkKeyStoreOldpwd(String keytool, String keyStore, String keyStoreType, String pwd) {
        StringBuffer cmd = new StringBuffer();
        cmd.append(keytool);
        cmd.append(" -list ");
        cmd.append("-v ");
        cmd.append("-keystore ");
        cmd.append(keyStore);
        cmd.append(" -storepass ");
        cmd.append(pwd);
        cmd.append(" -storetype ");
        cmd.append(keyStoreType);
        return CmdUtil.execStrCmd(cmd.toString());
    }
}

