/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.mapping;

import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.mapping.CertFileNameMapping;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;

public class CertFileSuffixMapping
implements CertFileNameMapping {
    private Component component;

    public CertFileSuffixMapping(Component component) {
        this.component = component;
    }

    @Override
    public String mapping(String file) {
        List<String> items = this.component.getCertFileList();
        String suffix = CertFileSuffixMapping.suffix(file);
        int index = file.lastIndexOf(".");
        if (index < 0) {
            return null;
        }
        for (String item : items) {
            if (!Objects.equals(CertFileSuffixMapping.suffix(item), suffix)) continue;
            return Paths.get(item, new String[0]).getParent().resolve(Paths.get(file, new String[0]).getFileName()).toString();
        }
        return null;
    }

    private static String suffix(String item) {
        int index = item.lastIndexOf(".");
        return index >= 0 ? item.substring(index) : null;
    }
}

