/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.replace;

import com.huawei.lego.common.certs.BackupDetail;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.ComponentCommand;
import com.huawei.lego.common.certs.mapping.CertFileNameMapping;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.TextEditor;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class CertificateReplaceCommand
extends ComponentCommand {
    private static Log logger = LogFactory.getInstance(CertificateReplaceCommand.class);

    public CertificateReplaceCommand(Component component) {
        super(component);
    }

    public void execute(String ... args) {
        Map.Entry<Map<String, Object>, List<String>> context = this.initialize(args);
        HashMap<String, String> backups = new HashMap<String, String>();
        try {
            this.execute(context, backups);
        }
        catch (Exception e) {
            logger.error((Object)"replace certificate faile. Starting rollback temp files");
            this.rollback(backups);
            throw SystemExitUtil.failed("Failed to change the certificate.", e);
        }
    }

    protected abstract Map.Entry<Map<String, Object>, List<String>> initialize(String[] var1);

    private void execute(Map.Entry<Map<String, Object>, List<String>> context, Map<String, String> backups) {
        Calendar calendar = Calendar.getInstance(Locale.CHINA);
        Date date = calendar.getTime();
        this.checkNewCertificate(context.getKey(), context.getValue(), date);
        long timestamp = date.getTime();
        Component component = this.getComponent();
        if ("NodeAgent".equals(component.getName())) {
            timestamp = 0L;
        }
        List<String> fileset = this.getComponentCertFileList();
        BackupDetail detail = new BackupDetail();
        detail.setTimestamp(timestamp);
        detail.setFileset(fileset);
        String configuration = component.getConfiguration();
        TextEditor editor = this.createConfigEditor(this.filter(context.getKey(), String.class), context.getValue());
        String config = FileUtil.readAll(configuration);
        if (config == null) {
            throw SystemExitUtil.failed("Failed to load certificate config for " + this.getComponent().getName());
        }
        Map data = editor.takeOne(config, new Function[]{this::getPatternKey});
        detail.setConfigs(data);
        String configBackup = BackupDetail.getBackupFileName(configuration, timestamp);
        backups.put(configBackup, null);
        this.backupConfig(detail, configBackup);
        this.backupOldCertificates(timestamp, backups);
        this.archiveNewCertificate(context.getKey(), context.getValue());
        this.moveCertFiles(context.getValue(), backups);
        String updated = editor.edit(config);
        this.updateConfig(timestamp, updated, data);
        List<String> needResrvedFiles = backups.keySet().stream().filter(backupFile -> backupFile.contains(".bak.")).collect(Collectors.toList());
        this.cleanOldBackupFiles(component, timestamp, needResrvedFiles);
        this.restart(timestamp);
        this.feedback(new JSONObject().set((Object)"timestamp", (Object)timestamp).toString());
    }

    private List<String> getComponentCertFileList() {
        Component component = this.getComponent();
        Path baseLocation = Paths.get(component.getBaseLocation(), new String[0]);
        return component.getCertFileList().stream().map(file -> baseLocation.relativize(Paths.get(file, new String[0]))).map(Path::toString).map(file -> file.replaceAll("^\\.[\\/]", "")).collect(Collectors.toList());
    }

    private void cleanOldBackupFiles(Component component, long timestamp, List<String> needResrvedFiles) {
        this.cleanOldBackupFiles(component.getCertLocation(), timestamp, needResrvedFiles);
        this.cleanOldBackupFiles(Paths.get(component.getConfiguration(), new String[0]).getParent().toString(), timestamp, needResrvedFiles);
        this.cleanOldBackupFiles(Paths.get(this.getCertificateArchivePath(), new String[0]).toString(), timestamp, needResrvedFiles);
    }

    protected abstract void checkNewCertificate(Map<String, Object> var1, List<String> var2, Date var3);

    private String getPatternKey(String pattern) {
        Matcher matcher = Pattern.compile("\\b[a-zA-Z0-9_-]+(?==)").matcher(pattern);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private void cleanOldBackupFiles(String path, long timestamp, List<String> needResrvedFiles) {
        File item = Paths.get(path, new String[0]).toFile();
        File[] files = item.isDirectory() ? item.listFiles(file -> CertificateReplaceCommand.isOldBackupFile(file, timestamp, needResrvedFiles)) : item.getParentFile().listFiles(file -> file.getName().startsWith(item.getName() + ".bak.") && CertificateReplaceCommand.isOldBackupFile(file, timestamp, needResrvedFiles));
        if (files == null) {
            logger.error((Object)"clean backup cert file and config failed");
            return;
        }
        for (File file2 : files) {
            boolean done = file2.delete();
            logger.info((Object)String.format("clean backup file %s %s.", file2.getName(), done ? "success" : "failed"));
        }
    }

    private static boolean isOldBackupFile(File file, long timestamp, List<String> needResrvedFiles) {
        if (timestamp == 0L) {
            try {
                return file.getName().contains(".bak.") && !needResrvedFiles.contains(file.getCanonicalPath());
            }
            catch (IOException e) {
                logger.error((Object)"Get File error.");
                return true;
            }
        }
        return file.getName().contains(".bak.") && !file.getName().endsWith(".bak." + timestamp);
    }

    private <T> Map<String, T> filter(Map<String, Object> data, Class<T> type) {
        HashMap result = new HashMap();
        data.forEach((k, v) -> result.put(k, type.isInstance(v) ? v : null));
        return result;
    }

    private void moveCertFiles(List<String> files, Map<String, String> backups) {
        CertFileNameMapping mapper = this.getComponent().getCertFileNameMapping();
        for (String file : files) {
            CertificateReplaceCommand.move(file, mapper.mapping(file), "coping cert file", backups);
        }
    }

    protected void backupConfig(BackupDetail detail, String dest) {
        JSONObject json = JSONObject.fromObject((Object)detail);
        FileUtil.writeFile(dest, json.toString());
    }

    protected void updateConfig(long timestamp, String config, Map<String, String> backup) {
        FileUtil.writeFile(this.getComponent().getConfiguration(), config);
    }

    protected abstract TextEditor createConfigEditor(Map<String, String> var1, List<String> var2);

    protected void backupOldCertificates(long timestamp, Map<String, String> backups) {
        List files = Stream.of(this.getComponent().getCertFileList(), Collections.singletonList(this.getCertificateArchivePath())).flatMap(Collection::stream).collect(Collectors.toList());
        for (String file : files) {
            CertificateReplaceCommand.move(file, BackupDetail.getBackupFileName(file, timestamp), "back up certificate file", backups);
        }
    }

    protected abstract void archiveNewCertificate(Map<String, Object> var1, List<String> var2);

    protected boolean confirm() {
        String msg = String.format("You are going to change the certificate file of %s. After certificate file replaced, component %s will be shutdown. Are you sure you want to perform the operation? (y/n):", this.getComponent().getName(), this.getComponent().getName());
        return CertificateReplaceCommand.confirm(msg);
    }

    protected void success() {
        SystemExitUtil.exitOK();
    }

    public static void main(String ... args) {
        CertificateFactory cf;
        try {
            cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw SystemExitUtil.failed("obtain x.509 certificate factory failed", e);
        }
        Certificate[] certificates = (Certificate[])Arrays.stream(args).map(arg -> CertificateReplaceCommand.loadCertificate(cf, arg)).toArray(Certificate[]::new);
        Date date = new Date();
        String error = CertificateReplaceCommand.verify(certificates, date);
        if (error != null) {
            throw SystemExitUtil.failed(error);
        }
    }

    private static Certificate loadCertificate(CertificateFactory cf, String path) {
        Certificate certificate;
        File file = new File(path);
        try (FileInputStream stream = new FileInputStream(file);){
            certificate = cf.generateCertificate(stream);
        }
        catch (FileNotFoundException e) {
            throw SystemExitUtil.failed("file is not found. filename: " + file.getName(), e);
        }
        catch (IOException e) {
            throw SystemExitUtil.failed("fail to load file. filename: " + file.getName(), e);
        }
        catch (CertificateException e) {
            throw SystemExitUtil.failed("file format is incorrect. filename: " + file.getName(), e);
        }
        return certificate;
    }

    static String verify(Certificate[] certificates, Date date) {
        return Optional.ofNullable(CertificateReplaceCommand.verifyChain(certificates)).orElseGet(() -> CertificateReplaceCommand.checkValidity(certificates, date));
    }

    static String verifyChain(Certificate[] certificates) {
        if (certificates == null) {
            return "not provide certificate chain";
        }
        int n = certificates.length;
        for (int i = 0; i < n - 1; ++i) {
            X509Certificate subject = (X509Certificate)certificates[i];
            X509Certificate issuer = (X509Certificate)certificates[i + 1];
            if (!subject.getIssuerX500Principal().equals(issuer.getSubjectX500Principal())) {
                return "Certificates do not chain";
            }
            try {
                subject.verify(issuer.getPublicKey());
                continue;
            }
            catch (GeneralSecurityException e) {
                logger.error((Object)"verify certificate chain failed", (Throwable)e);
                return "verify certificate chain failed";
            }
        }
        X509Certificate last = (X509Certificate)certificates[n - 1];
        if (last.getIssuerX500Principal().equals(last.getSubjectX500Principal())) {
            try {
                last.verify(last.getPublicKey());
            }
            catch (GeneralSecurityException e) {
                return "verify root ca failed";
            }
        } else {
            logger.info((Object)"root ca is not self-signed certificate");
        }
        return null;
    }

    private static String checkValidity(Certificate[] certificates, Date date) {
        int n = certificates.length;
        for (int i = 0; i < n; ++i) {
            String error = CertificateReplaceCommand.checkValidity(certificates[i], date, i >= 1);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static String checkValidity(Certificate cert, Date date, boolean strict) {
        if (!(cert instanceof X509Certificate)) {
            return "certificate format is not X.509";
        }
        X509Certificate certificate = (X509Certificate)cert;
        Date notAfter = certificate.getNotAfter();
        if (notAfter.before(date)) {
            return "certificate is expired.";
        }
        Date notBefore = certificate.getNotBefore();
        if (!notBefore.after(date)) {
            logger.info((Object)("certificate is valid in [" + notBefore + " - " + notAfter + "]"));
            return null;
        }
        long diff = notBefore.getTime() - date.getTime();
        if (!strict && diff <= TimeUnit.MINUTES.toMillis(5L)) {
            logger.info((Object)("certificate is valid in [" + notBefore + " - " + notAfter + "], waiting for certificate to valid. wait time: " + diff + " millis."));
            CommonUtil.sleep((long)diff);
            return null;
        }
        return "certificate is not yet valid.";
    }
}

