/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.certs.replace;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.lego.common.certs.Component;
import com.huawei.lego.common.certs.replace.CertificateReplaceCommand;
import com.huawei.lego.common.util.ConsoleUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.common.util.SystemPrint;
import com.huawei.lego.core.sdk.file.util.FileUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.TextEditor;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public abstract class JKSCertificateReplaceCommand
extends CertificateReplaceCommand {
    protected static final String KEY_STORE = "keyStore";
    protected static final String KEY_STORE_TYPE = "keystoreType";
    protected static final String KEY_STORE_FILE = "keystoreFile";
    protected static final String KEY_STORE_PASS = "keystorePass";
    protected static final String KEY_PASS = "keyPass";
    private static Log logger = LogFactory.getInstance(JKSCertificateReplaceCommand.class);

    public JKSCertificateReplaceCommand(Component component) {
        super(component);
    }

    @Override
    protected Map.Entry<Map<String, Object>, List<String>> initialize(String[] args) {
        KeyStore keyStore;
        String keyStoreType = args[0];
        String keyStorePath = args[1];
        try {
            keyStore = KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw SystemExitUtil.failed("get " + keyStoreType + " key store instance failed", e);
        }
        File keyStoreFile = new File(keyStorePath);
        if (!keyStoreFile.exists()) {
            throw SystemExitUtil.failed("key store file is not exists. path: " + keyStorePath);
        }
        String pass = this.readPassword(keyStore, keyStoreFile);
        if (!this.confirm()) {
            throw SystemExitUtil.failed("user canceled modify keystore.");
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(KEY_STORE, keyStore);
        options.put(KEY_STORE_TYPE, keyStoreType);
        options.put(KEY_STORE_PASS, pass);
        options.put(KEY_PASS, pass);
        return new AbstractMap.SimpleEntry<Map<String, Object>, List<String>>(options, Collections.singletonList(keyStorePath));
    }

    private String readPassword(KeyStore keyStore, File keyStoreFile) {
        String keyStorePass;
        boolean reading;
        do {
            keyStorePass = ConsoleUtil.readPassword("Please input secret key: ", new Object[0]);
            try (FileInputStream stream = new FileInputStream(keyStoreFile);){
                keyStore.load(stream, keyStorePass.toCharArray());
                reading = false;
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                if (ConsoleUtil.redirected()) {
                    throw SystemExitUtil.failed("validate key store file and password failed", e);
                }
                SystemPrint.systemPrintStr("Certificate password error");
                reading = true;
            }
        } while (reading);
        return WccEncryptor.encrypt((String)keyStorePass);
    }

    @Override
    protected TextEditor createConfigEditor(Map<String, String> context, List<String> certFiles) {
        if (certFiles.size() != 1) {
            throw SystemExitUtil.failed("number of cert file is not one");
        }
        List fields = this.getConfigFields().stream().map(this::normalizeConfigField).collect(Collectors.toList());
        HashMap<String, String> data = new HashMap<String, String>(context);
        Component component = this.getComponent();
        String keyStoreFile = Paths.get(component.getBaseLocation(), new String[0]).relativize(Paths.get(component.getCertFileNameMapping().mapping(certFiles.get(0)), new String[0])).toString();
        data.put(KEY_STORE_FILE, JKSCertificateReplaceCommand.formatPath(keyStoreFile.replaceAll("^.[\\\\/]", "")));
        for (String[] field : fields) {
            data.put(field[0], (String)data.get(field[1]));
        }
        data.entrySet().removeIf(entry -> !this.containConfigField(fields, (String)entry.getKey()));
        TextEditor editor = component.getEditor();
        for (Map.Entry entry2 : data.entrySet()) {
            editor = editor.then((String)entry2.getKey(), (String)entry2.getValue());
        }
        return editor.care((Object)"value");
    }

    protected static String formatPath(String path) {
        return path.replaceAll("\\\\", "\\\\\\\\");
    }

    private String[] normalizeConfigField(String name) {
        int index = name.indexOf(58);
        if (index >= 0) {
            return new String[]{name.substring(0, index), name.substring(index + 1)};
        }
        return new String[]{name, name};
    }

    private boolean containConfigField(List<String[]> items, String item) {
        for (String[] array : items) {
            if (!array[0].equals(item)) continue;
            return true;
        }
        return false;
    }

    protected abstract List<String> getConfigFields();

    @Override
    protected void checkNewCertificate(Map<String, Object> context, List<String> certFiles, Date date) {
        KeyStore keyStore = (KeyStore)context.get(KEY_STORE);
        Certificate[] chain = this.getCertificateChain(keyStore);
        String error = JKSCertificateReplaceCommand.verify(chain, date);
        if (error != null) {
            throw SystemExitUtil.failed(error);
        }
    }

    @Override
    protected void archiveNewCertificate(Map<String, Object> context, List<String> certFiles) {
        KeyStore keyStore = (KeyStore)context.get(KEY_STORE);
        Certificate certificate = this.getCertificate(keyStore);
        StringWriter writer = new StringWriter();
        PemWriter pemWriter = new PemWriter((Writer)writer);
        try {
            pemWriter.writeObject((PemObjectGenerator)new PemObject(this.getComponent().getName(), certificate.getEncoded()));
        }
        catch (IOException | CertificateEncodingException e) {
            throw SystemExitUtil.failed("export public certificate failed for " + this.getComponent().getName(), e);
        }
        finally {
            try {
                pemWriter.close();
            }
            catch (Exception e) {
                logger.error((Object)"pemWriter close error:", (Throwable)e, "");
            }
        }
        String archivePath = this.getCertificateArchivePath();
        boolean done = FileUtil.writeText((File)new File(archivePath), (String)writer.toString());
        if (!done) {
            throw SystemExitUtil.failed("archive public certificate failed for " + this.getComponent().getName());
        }
    }

    private Certificate getCertificate(KeyStore keyStore) {
        Map.Entry<String, Certificate> entry = this.findCertificate(keyStore);
        if (entry != null) {
            return entry.getValue();
        }
        throw SystemExitUtil.failed("obtain public certificate failed for " + this.getComponent().getName());
    }

    private Map.Entry<String, Certificate> findCertificate(KeyStore keyStore) {
        try {
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                Certificate certificate;
                String alias = aliases.nextElement();
                if (alias.startsWith("ca-") || (certificate = keyStore.getCertificate(alias)) == null) continue;
                return new AbstractMap.SimpleEntry<String, Certificate>(alias, certificate);
            }
        }
        catch (KeyStoreException ignore) {
            LogManager.error((Object)("find Certificate error. msg:" + ExceptionUtil.getErrorMessage((Throwable)ignore)));
        }
        return null;
    }

    private Certificate[] getCertificateChain(KeyStore keyStore) {
        Certificate[] chain;
        Map.Entry<String, Certificate> entry = this.findCertificate(keyStore);
        if (entry == null) {
            return null;
        }
        try {
            chain = keyStore.getCertificateChain(entry.getKey());
        }
        catch (KeyStoreException e) {
            logger.error((Object)"get certificate chain failed", (Throwable)e);
            return null;
        }
        if (chain == null) {
            return new Certificate[0];
        }
        return chain;
    }
}

