/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changeport;

import com.huawei.lego.common.changeport.MappingProKey;
import com.huawei.lego.common.changeport.PortsUtil;
import com.huawei.lego.common.changeport.ProcessFile;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.exception.StartException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import com.huawei.util.CommonUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class ChangePort {
    private static final String portFile = "config/conf/port.ini";
    public static final String SDKFILE = "default.properties";
    private static Log logger = LogFactory.getInstance(ChangePort.class);
    private static InstalledSystem systemInfo = null;
    private static String installPath = "";
    private static String oldPortFile = "";
    private static String newPortFile = "";
    private static String backEndJar = "";
    private static String frontJar = "";
    private static boolean isPlatFromUpgrade = false;

    public static void main(String[] args) {
        block6: {
            if (args.length < 1) {
                logger.error((Object)"param error, use check Port or update Port.", "");
                SystemExitUtil.exitFail();
            }
            try {
                ChangePort.initFilePath();
                if (args[0].equals("checkPort")) {
                    PortsUtil.checkPortIsUsed();
                    break block6;
                }
                if (args[0].equals("updatePort")) {
                    ChangePort.updateAllPort();
                    break block6;
                }
                logger.error((Object)"only support check Port and update Port. ", "");
                return;
            }
            catch (StartException e) {
                logger.error((Object)("these ports is used or illegal: " + e.getMessage()), "");
                SystemExitUtil.exitFail();
            }
            catch (PatchException e) {
                logger.error((Object)("update ports failed: " + e), "");
                SystemExitUtil.exitFail();
            }
        }
        SystemExitUtil.exitOK();
    }

    private static void initFilePath() {
        try {
            systemInfo = InitInstalledXmlTool.getInstalledSystem();
            installPath = systemInfo.getInstallpath() + File.separator;
            oldPortFile = installPath + "Runtime@tmp/bin/" + portFile;
            newPortFile = installPath + "Runtime/bin/" + portFile;
            backEndJar = installPath + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + File.separator + "Lego-Core-SDK-Bundle-0.0.1-SNAPSHOT.jar";
            frontJar = installPath + LegoResourceManager.getProValue("install.lego_version.frontend.jar.path") + File.separator + "Lego-Core-SDK-Bundle-0.0.1-SNAPSHOT.jar";
        }
        catch (Exception e) {
            logger.error((Object)("init file path failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("");
        }
    }

    public static void updateAllPort() {
        try {
            ChangePort.initFilePath();
            PortsUtil uti = new PortsUtil(portFile);
            Map<String, String> allMsg = MappingProKey.getOldMapData(uti.getAllPorts());
            ProcessFile.updateJarFile(backEndJar, SDKFILE, allMsg);
            ProcessFile.updateJarFile(frontJar, SDKFILE, allMsg);
            ProcessFile.updateGaussPort(systemInfo, allMsg.get("gauss.port"));
            ProcessFile.updateInstalledMsg(installPath, allMsg);
        }
        catch (Exception e) {
            ProcessFile.rollBack();
            logger.error((Object)("update port failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update port failed");
        }
        List<String> fileList = ProcessFile.getChangedFile();
        if (null != fileList && fileList.size() != 0) {
            for (String file : fileList) {
                FileUtil.deleteFile(file + "@tmp");
            }
        }
    }

    public static void changePortConfFile(String key, String value) {
        HashMap<String, String> ports = new HashMap<String, String>();
        ports.put(key, value);
        PropertyUtil proUtil = new PropertyUtil(portFile);
        String currentValue = proUtil.getValue(key);
        if (null != currentValue && !currentValue.equals(value)) {
            ProcessFile.updatePortConfFile(ports, portFile);
        }
    }

    public static boolean isPlatFromUpgrade() {
        return isPlatFromUpgrade;
    }

    public static void setPlatFromUpgrade(boolean isPlatFromUpgrade) {
        ChangePort.isPlatFromUpgrade = isPlatFromUpgrade;
    }

    public static void upgradePortConfFile() {
        ChangePort.initFilePath();
        if (!ChangePort.isPlatFromUpgrade()) {
            return;
        }
        File file = new File(oldPortFile);
        if (!file.exists()) {
            ChangePort.updateOtherPort();
            return;
        }
        PortsUtil oldPort = new PortsUtil(oldPortFile);
        PortsUtil newPort = new PortsUtil(newPortFile);
        ChangePort.updateConfig(oldPort, newPort);
    }

    private static void updateOtherPort() {
        String oldConfFile = installPath + "Runtime@tmp/LegoRuntime/conf/lego.properties";
        PortsUtil oldPort = new PortsUtil(oldConfFile);
        PortsUtil newPort = new PortsUtil(newPortFile);
        HashMap<String, String> updateList = new HashMap<String, String>();
        Map<String, String> allMsg = MappingProKey.getNewMapData(oldPort.getAllPorts());
        Map<String, String> newPortList = newPort.getAllPorts();
        ChangePort.getOldHttpPortInfo(allMsg);
        ChangePort.getGaussPort(allMsg);
        Set<String> keyList = allMsg.keySet();
        for (String oldKey : keyList) {
            String oldValue = allMsg.get(oldKey);
            if (null != oldValue && oldValue.contains(":")) {
                oldValue = oldValue.substring(oldValue.lastIndexOf(":") + 1);
            }
            if (!newPortList.containsKey(oldKey) || oldValue.equals(newPortList.get(oldKey))) continue;
            updateList.put(oldKey, oldValue);
        }
        ProcessFile.updatePortConfFile(updateList, newPortFile);
    }

    private static void getOldHttpPortInfo(Map<String, String> oldPortList) {
        String sp = File.separator;
        String xmlFile = installPath + sp + "Runtime@tmp" + sp + "Tomcat6/conf/server.xml";
        File xml = new File(xmlFile);
        if (!xml.exists()) {
            logger.error((Object)"the server.xml is not exists, return.", "");
            return;
        }
        String httpsKey = "https.port";
        String httpKey = "http.port";
        if (OSInformation.isLinux()) {
            httpKey = "linux.http.to.https.redirect.port";
        }
        SAXReader reader = new SAXReader();
        try {
            CommonUtil.setSecurityFeatures((SAXReader)reader);
            Document document = reader.read(xml);
            List element = document.selectNodes("/Server/Service/Connector");
            for (Node ele : element) {
                String httpPortValue;
                Attribute tmp = ((Element)ele).attribute("redirectPort");
                Attribute aPort = ((Element)ele).attribute("port");
                String string = httpPortValue = OSInformation.isLinux() ? "8080" : "80";
                if (null != aPort && null != tmp) {
                    httpPortValue = aPort.getValue();
                }
                if (null == tmp && null != aPort) {
                    oldPortList.put(httpsKey, aPort.getValue());
                    continue;
                }
                oldPortList.put(httpKey, httpPortValue);
            }
        }
        catch (Exception e) {
            logger.error((Object)("get http and https port from server.xml failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("get http and https port from server.xml failed.");
        }
    }

    private static void getGaussPort(Map<String, String> oldPortList) {
        String gaussKey = "gauss.port";
        String dataPath = systemInfo.getDbInfor().getDbFilePath() + File.separator + "postgresql.conf";
        File file = new File(dataPath);
        if (!file.exists()) {
            logger.error((Object)"the data config file postgresql is not exist, get data port failed.", "");
            throw new PatchException("get data port failed.");
        }
        PropertyUtil gaussPro = new PropertyUtil(dataPath);
        oldPortList.put(gaussKey, gaussPro.getValue("port"));
    }

    private static void updateConfig(PortsUtil old, PortsUtil newest) {
        HashMap<String, String> updateList = new HashMap<String, String>();
        Map<String, String> oldPortsList = old.getAllPorts();
        Map<String, String> newPortsList = newest.getAllPorts();
        Set<String> keyList = oldPortsList.keySet();
        for (String key : keyList) {
            String value = oldPortsList.get(key);
            if (!newPortsList.containsKey(key) || value.equals(newPortsList.get(key))) continue;
            updateList.put(key, value);
        }
        ProcessFile.updatePortConfFile(updateList, newPortFile);
    }
}

