/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.common.changeport;

import com.huawei.drm.install.common.dto.DataBaseInfo;
import com.huawei.drm.install.common.dto.DataBaseUtil;
import com.huawei.lego.common.dto.InstalledSystem;
import com.huawei.lego.common.exception.PatchException;
import com.huawei.lego.common.util.FileUtil;
import com.huawei.lego.common.util.InitInstalledXmlTool;
import com.huawei.lego.common.util.JarFileUtil;
import com.huawei.lego.common.util.LegoResourceManager;
import com.huawei.lego.common.util.OSInformation;
import com.huawei.lego.common.util.PropertyUtil;
import com.huawei.lego.common.util.dbtool.ChangeDbInforInJar;
import com.huawei.lego.common.util.dbtool.GaussDBUtil;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class ProcessFile {
    private static final String BACKFILE = "@tmp";
    private static final int INDEX_1 = 1;
    private static final int INDEX_2 = 2;
    private static boolean updateGaussPort = false;
    private static Log logger = LogFactory.getInstance(ProcessFile.class);
    private static List<String> changedFile = new ArrayList<String>();

    private ProcessFile() {
    }

    public static boolean isUpdateGaussPort() {
        return updateGaussPort;
    }

    public static void setUpdateGaussPort(boolean updateGaussPort) {
        ProcessFile.updateGaussPort = updateGaussPort;
    }

    public static List<String> getChangedFile() {
        return changedFile;
    }

    private static String copyFileFromJar(String jarFile, String targetFile) {
        String filePath = "";
        File tmp = new File(jarFile);
        String destFile = targetFile.substring(targetFile.lastIndexOf("/") + 1);
        String dest = tmp.getParent() + File.separator + destFile;
        try {
            JarFileUtil.copyFileFromJar(jarFile, targetFile, dest);
            File destF = new File(dest);
            if (!destF.exists()) {
                logger.error((Object)"copyFileFromJar failed, maybe targetFile is not exists.", "");
                return filePath;
            }
            filePath = destF.getCanonicalPath();
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("can not find the file: " + tmp.getName()), "");
        }
        catch (IOException e) {
            logger.error((Object)("copy file from jar failed: " + e), "");
        }
        return filePath;
    }

    private static Map<String, String> parseTargetFile(String targetFile) {
        HashMap<String, String> mps = new HashMap<String, String>();
        PropertyUtil proU = new PropertyUtil(targetFile);
        Properties pro = proU.getProp();
        Set<Object> keys = pro.keySet();
        for (String string : keys) {
            String value = pro.getProperty(string);
            mps.put(string, value);
        }
        return mps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTmpFile(String file, String buf) {
        File tmpFile = new File(file);
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        FileWriter writer = null;
        try {
            tmpFile.createNewFile();
            writer = new FileWriter(tmpFile);
            writer.write(buf);
            writer.flush();
        }
        catch (IOException e) {
            try {
                logger.error((Object)("write used or illegal port to tmp file failed: " + e), "");
            }
            catch (Throwable throwable) {
                ProcessFile.releaseStream(writer);
                throw throwable;
            }
            ProcessFile.releaseStream(writer);
        }
        ProcessFile.releaseStream(writer);
    }

    public static void updateGaussPort(InstalledSystem system, String ports) {
        if (null == ports || "".equals(ports)) {
            logger.info((Object)"gauss port is null, return.", "");
            return;
        }
        String dbConfFile = "";
        try {
            DataBaseInfo dbInfo = system.getDbInfor();
            String dbPath = dbInfo.getDbFilePath();
            dbConfFile = dbPath + File.separator + "postgresql.conf";
            ProcessFile.updateGaussConfFile(dbConfFile, ports);
            if (ProcessFile.isUpdateGaussPort()) {
                if (OSInformation.isWindows()) {
                    ProcessFile.reStartGauss();
                }
                String sp = File.separator;
                String jarFile = system.getInstallpath() + sp + LegoResourceManager.getProValue("install.lego_version.backend.jar.path") + sp + LegoResourceManager.getProValue("install.db.propfile.jar");
                FileUtil.copyFile(jarFile, jarFile + BACKFILE);
                changedFile.add(jarFile);
                dbInfo.setDbPort(ports);
                ChangeDbInforInJar.changePropDBFile(dbInfo, system.getInstallpath());
            }
        }
        catch (Exception e) {
            logger.error((Object)("update gauss conf file failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("update gauss conf file failed.");
        }
    }

    private static void reStartGauss() throws Exception {
        try {
            logger.info((Object)"restart gaussdb.", "");
            GaussDBUtil.stopGaussDB();
            GaussDBUtil.startGaussDB();
        }
        catch (Exception e) {
            logger.error((Object)("restart gaussdb failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void updateGaussConfFile(String targetFile, String port) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = null;
        FileReader fr = null;
        FileWriter writer = null;
        fr = new FileReader(targetFile);
        reader = new BufferedReader(fr);
        String text = null;
        while ((text = FileUtil.getLineFromFile(reader)) != null) {
            if (text.startsWith("port") && text.contains("=") && ProcessFile.isGaussPortChanged(text, port)) {
                ProcessFile.setUpdateGaussPort(true);
                text = "port=" + port;
            }
            sb.append(text);
            sb.append(System.getProperty("line.separator"));
        }
        ProcessFile.releaseStream(reader);
        ProcessFile.releaseStream(fr);
        try {
            if (!ProcessFile.isUpdateGaussPort()) return;
            FileUtil.copyFile(targetFile, targetFile + BACKFILE);
            changedFile.add(targetFile);
            writer = new FileWriter(targetFile);
            writer.write(sb.toString());
            writer.flush();
            return;
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"the gauss port config file is not exists.", "");
            throw new PatchException("FileNotFoundException");
        }
        catch (IOException e) {
            logger.error((Object)("update postgrel file failed: " + e), "");
            throw new PatchException("");
        }
        catch (FileNotFoundException e) {
            try {
                logger.error((Object)"the gauss port config file is not exists.", "");
                throw new PatchException("FileNotFoundException");
                catch (Exception e2) {
                    logger.error((Object)("read gauss port conf file failed:" + ExceptionUtil.getErrorMessage((Throwable)e2)), "");
                    throw new PatchException("updateGaussConfFile failed.");
                }
            }
            catch (Throwable throwable) {
                ProcessFile.releaseStream(reader);
                ProcessFile.releaseStream(fr);
                throw throwable;
            }
        }
        finally {
            ProcessFile.releaseStream(writer);
        }
    }

    private static boolean isGaussPortChanged(String str, String value) {
        String[] itr = str.split("=");
        return itr.length != 2 || !itr[1].equals(value);
    }

    public static void updateInstalledMsg(String installPath, Map<String, String> dataMap) {
        String sp = File.separator;
        String binFile = LegoResourceManager.getProValue("install.params.installed.file");
        String instsllFile = OSInformation.getInstalledFile();
        try {
            ProcessFile.updateInstallFile(instsllFile, dataMap);
            ProcessFile.updateInstallFile(binFile, dataMap);
            DataBaseInfo dbInfo = InitInstalledXmlTool.getInstalledSystem().getDbInfor();
            dbInfo.setDbPort(dataMap.get("gauss.port"));
            DataBaseUtil.updateDatabaseConfig(installPath, dbInfo);
            if (OSInformation.isWindows()) {
                String xmlFile = installPath + sp + "Runtime" + sp + "monitor" + sp + binFile;
                ProcessFile.updateInstallFile(xmlFile, dataMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("udpate install file failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("udpate install file failed.");
        }
    }

    private static void updateInstallFile(String file, Map<String, String> dataMap) throws Exception {
        XMLWriter output = null;
        boolean isChanged = false;
        try {
            File tmpFile = new File(file);
            if (!tmpFile.exists()) {
                logger.error((Object)("the file is not exists, update install file failed." + tmpFile.getName()), "");
                throw new FileNotFoundException();
            }
            String httpsPort = dataMap.get("https.port");
            SAXReader sax = new SAXReader();
            CommonUtil.setSecurityFeatures((SAXReader)sax);
            Document document = sax.read(new File(file));
            Element httpsElement = (Element)document.selectSingleNode("/install/httpsport");
            if (null != httpsPort && !httpsPort.equals(httpsElement.getText())) {
                httpsElement.setText(httpsPort);
                isChanged = true;
            }
            if (!isChanged) {
                logger.info((Object)"no need change https and data port in install file.", "");
                return;
            }
            changedFile.add(file);
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding("UTF-8");
            output = new XMLWriter((Writer)new FileWriter(file), format);
            output.write(document);
            output.flush();
            ProcessFile.closeOutStream(null, output);
        }
        catch (Exception e) {
            logger.error((Object)("change install file failed." + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("updateInstallFile failed.");
        }
        finally {
            ProcessFile.closeOutStream(null, output);
        }
    }

    private static void closeOutStream(FileOutputStream out, XMLWriter writer) {
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)"close out stream failed.", "");
            }
        }
        if (null != writer) {
            try {
                writer.close();
            }
            catch (IOException e) {
                logger.error((Object)"close writer  failed.", "");
            }
        }
    }

    public static void updateProperties(String file, Map<String, String> checkPorts) {
        File f = new File(file);
        if (!f.exists()) {
            return;
        }
        Map<String, String> newData = ProcessFile.getNewData(checkPorts, file);
        if (null != newData && newData.size() != 0) {
            logger.info((Object)"some port is updated, need changed.", "");
            ProcessFile.updateFile(file, newData);
        }
    }

    public static void updatePortConfFile(Map<String, String> updatePort, String newFile) {
        try {
            ProcessFile.updateFile(newFile, updatePort);
        }
        catch (Exception e) {
            logger.error((Object)("update port.ini failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
            throw new PatchException("updatePortConfFile failed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateJarFile(String jarFile, String targetFile, Map<String, String> checkPorts) {
        if (!new File(jarFile).exists()) {
            logger.info((Object)"the jar file needed to change is not exists, return.", "");
            return;
        }
        String outFile = "";
        try {
            outFile = ProcessFile.copyFileFromJar(jarFile, targetFile);
            if ("".equals(outFile)) {
                throw new PatchException("copy file from jar failed.");
            }
            Map<String, String> newData = ProcessFile.getNewData(checkPorts, outFile);
            if (null != newData && newData.size() != 0) {
                ProcessFile.updateFile(outFile, newData);
                ProcessFile.updateJar(jarFile, targetFile, outFile);
            }
        }
        finally {
            FileUtil.deleteFile(outFile);
        }
    }

    public static void rollBack() {
        if (null == changedFile || changedFile.size() == 0) {
            logger.error((Object)"no file need rollback.", "");
            return;
        }
        for (String file : changedFile) {
            try {
                FileUtil.copyFile(file + BACKFILE, file);
            }
            catch (Exception e) {
                File tmpFile = new File(file);
                logger.error((Object)("RollBack file: " + tmpFile.getName() + " failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), "");
                continue;
            }
            FileUtil.deleteFile(file + BACKFILE);
        }
    }

    private static Map<String, String> getNewData(Map<String, String> checkPorts, String file) {
        Map<String, String> currentKeys = ProcessFile.parseTargetFile(file);
        HashMap<String, String> newData = new HashMap<String, String>();
        Set<String> keys = checkPorts.keySet();
        for (String key : keys) {
            String value = checkPorts.get(key);
            if (!currentKeys.containsKey(key)) continue;
            String currentValue = currentKeys.get(key);
            if (null != currentValue && currentValue.contains(":")) {
                currentValue = currentValue.substring(currentValue.lastIndexOf(":") + 1);
            }
            if (value.equals(currentValue)) continue;
            newData.put(key, value);
        }
        return newData;
    }

    private static void updateJar(String jarFile, String targetFile, String outFile) {
        String backJar = jarFile + BACKFILE;
        try {
            FileUtil.copyFile(jarFile, backJar);
            changedFile.add(jarFile);
            JarFileUtil.editJar(jarFile, targetFile, outFile);
        }
        catch (IOException e) {
            throw new PatchException("change jar failed: " + e);
        }
    }

    private static void updateFile(String file, Map<String, String> data) {
        String backFile = file + BACKFILE;
        try {
            FileUtil.copyFile(file, backFile);
            FileUtil.modifyDBPropFileUsingStr(backFile, data, file);
        }
        catch (IOException e) {
            if (new File(backFile).exists()) {
                FileUtil.deleteFile(file);
                FileUtil.reNameFile(backFile, file);
            }
            throw new PatchException("change properties file failed: " + e);
        }
        finally {
            FileUtil.deleteFile(backFile);
        }
    }

    private static void releaseStream(Closeable stream) {
        if (null != stream) {
            try {
                stream.close();
                stream = null;
            }
            catch (IOException e) {
                logger.error((Object)("Release Stream is Error:" + e.getMessage()), "");
            }
        }
    }
}

